/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.net.httpconnection;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.URL;
import org.appwork.utils.net.httpconnection.AbstractSocksHTTPConnection;
import org.appwork.utils.net.httpconnection.HTTPConnectionUtils;
import org.appwork.utils.net.httpconnection.HTTPProxy;
import org.appwork.utils.net.httpconnection.SocketStreamInterface;
import org.appwork.utils.net.socketconnection.Socks5SocketConnection;
import org.appwork.utils.net.socketconnection.SocksSocketConnection;

public class Socks5HTTPConnectionImpl
extends AbstractSocksHTTPConnection {
    public Socks5HTTPConnectionImpl(URL url, HTTPProxy proxy, SocksSocketConnection.DESTTYPE destType) {
        super(url, proxy, destType);
    }

    public Socks5HTTPConnectionImpl(URL url, HTTPProxy proxy) {
        super(url, proxy);
    }

    @Override
    protected Socket createRawConnectionSocket(InetAddress bindInetAddress) throws IOException {
        Socks5SocketConnection socket = this.buildSocksSocketConnection();
        socket.setSoTimeout(this.getReadTimeout());
        return socket;
    }

    @Override
    protected SocketStreamInterface connect(SocketStreamInterface socketStream) throws IOException {
        Socket socket = socketStream.getSocket();
        Socks5SocketConnection socks5Socket = (Socks5SocketConnection)socket;
        this.endPointInetSocketAddress = this.buildConnectEndPointSocketAddress(socks5Socket);
        socks5Socket.connect(this.endPointInetSocketAddress, this.getConnectTimeout(), this.proxyRequest);
        return socketStream;
    }

    @Override
    protected HTTPConnectionUtils.IPVERSION getEndPointIPVersion() {
        return HTTPConnectionUtils.IPVERSION.IPV4_IPV6;
    }

    @Override
    protected Socks5SocketConnection buildSocksSocketConnection() {
        Socks5SocketConnection socket = new Socks5SocketConnection(this.getProxy(), this.getDestType());
        return socket;
    }
}

