/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.net.throttledconnection;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import org.appwork.utils.Exceptions;
import org.appwork.utils.net.throttledconnection.ThrottledConnection;
import org.appwork.utils.net.throttledconnection.ThrottledConnectionHandler;

public class ThrottledOutputStream
extends OutputStream
implements ThrottledConnection {
    private ThrottledConnectionHandler handler;
    private OutputStream out;
    protected volatile long transferedCounter = 0L;
    protected volatile long transferedCounter2 = 0L;
    private volatile int limitCurrent = 0;
    private int limitCounter = 0;
    private int offset;
    private int todo;
    private int rest;
    private long slotTimeLeft = 0L;
    private long lastTimeReset = 0L;
    private final long onems = 1000000L;
    private final long onesec = 1000000000L;

    public ThrottledOutputStream(OutputStream out) {
        this.out = out;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        if (this.handler != null) {
            this.handler.removeThrottledConnection(this);
            this.handler = null;
        }
        ThrottledOutputStream throttledOutputStream = this;
        synchronized (throttledOutputStream) {
            this.notify();
        }
        this.out.close();
    }

    @Override
    public void flush() throws IOException {
        this.out.flush();
    }

    @Override
    public ThrottledConnectionHandler getHandler() {
        return this.handler;
    }

    @Override
    public int getLimit() {
        return this.limitCurrent;
    }

    public OutputStream getOutputStream() {
        return this.out;
    }

    @Override
    public void setHandler(ThrottledConnectionHandler manager) {
        if (this.handler != null && this.handler != manager) {
            this.handler.removeThrottledConnection(this);
        }
        this.handler = manager;
        if (this.handler != null) {
            this.handler.addThrottledConnection(this);
        }
    }

    @Override
    public void setLimit(int kpsLimit) {
        if (kpsLimit == this.limitCurrent) {
            return;
        }
        this.limitCurrent = Math.max(0, kpsLimit);
    }

    public void setOutputStream(OutputStream os) {
        if (os == null) {
            throw new IllegalArgumentException("Outputstream is null");
        }
        if (os == this) {
            throw new IllegalArgumentException("Outputstream loop!");
        }
        this.out = os;
    }

    @Override
    public long transfered() {
        return this.transferedCounter;
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (this.limitCurrent == 0) {
            this.out.write(b, off, len);
            this.transferedCounter += (long)len;
        } else {
            this.offset = off;
            this.rest = len;
            while (this.rest > 0) {
                this.writeWait(this.rest);
                this.todo = Math.min(this.limitCounter, this.rest);
                this.out.write(b, this.offset, this.todo);
                this.offset += this.todo;
                this.rest -= this.todo;
                this.transferedCounter += (long)this.todo;
                this.limitCounter -= this.todo;
            }
        }
    }

    @Override
    public void write(int b) throws IOException {
        this.out.write(b);
        ++this.transferedCounter;
        if (this.limitCurrent != 0) {
            --this.limitCounter;
            this.writeWait(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void writeWait(int len) throws IOException {
        long current = System.nanoTime();
        this.slotTimeLeft = Math.max(0L, current - this.lastTimeReset);
        if (this.limitCounter <= 0 && this.slotTimeLeft < this.onesec) {
            ThrottledOutputStream throttledOutputStream = this;
            synchronized (throttledOutputStream) {
                try {
                    long wait = this.onesec - this.slotTimeLeft;
                    this.lastTimeReset = current + wait;
                    long ns = wait % this.onems;
                    this.wait(wait /= this.onems, (int)ns);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw Exceptions.initCause(new InterruptedIOException("throttle interrupted"), e);
                }
            }
            this.limitCounter = this.limitCurrent;
            if (this.limitCounter <= 0) {
                this.limitCounter = len;
            }
        } else if (this.slotTimeLeft >= this.onesec) {
            this.limitCounter = this.limitCurrent;
            this.lastTimeReset = current;
            if (this.limitCounter <= 0) {
                this.limitCounter = len;
            }
        }
    }
}

