/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.speedmeter;

import org.appwork.utils.Time;
import org.appwork.utils.speedmeter.SpeedMeterInterface;

public class AverageSpeedMeter
implements SpeedMeterInterface {
    private final long[] bytes;
    private final long[] times;
    private final int size;
    private int index;
    private final Object LOCK = new Object();
    private long stalled = 0L;
    private long timeout = -1L;
    private final SpeedMeterInterface.Resolution resolution;
    private long totalValue;
    private long totalTime;
    private long lastPutTime = -1L;

    @Override
    public final SpeedMeterInterface.Resolution getResolution() {
        return this.resolution;
    }

    protected final long getMinimumDuration() {
        return this.getResolution().factor;
    }

    public AverageSpeedMeter(int size, SpeedMeterInterface.Resolution resolution) {
        this.size = size;
        this.bytes = new long[this.size];
        this.times = new long[this.size];
        this.index = 0;
        if (resolution == null) {
            throw new IllegalArgumentException("Resolution is null!");
        }
        this.resolution = resolution;
        this.resetSpeedmeter();
    }

    public AverageSpeedMeter(int size) {
        this(size, SpeedMeterInterface.Resolution.MILLI_SECONDS);
    }

    public AverageSpeedMeter() {
        this(5);
    }

    @Override
    public long getValue(SpeedMeterInterface.Resolution requestedResolution) {
        return this.getValue(requestedResolution, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getValue(SpeedMeterInterface.Resolution requestedResolution, boolean untilNow) {
        long value;
        long time;
        Object object = this.LOCK;
        synchronized (object) {
            time = untilNow ? this.totalTime : this.totalTime + Time.systemIndependentCurrentJVMTimeMillis() - (this.lastPutTime < 0L ? 0L : this.lastPutTime);
            value = this.totalValue;
        }
        if (time > this.getMinimumDuration()) {
            return (long)((double)value * ((double)this.getResolution().factor / (double)requestedResolution.factor) / (double)time);
        }
        if (time > 0L) {
            double factor = (double)(this.getMinimumDuration() / time) * 1.0;
            return (long)(factor * ((double)value * ((double)this.getResolution().factor / (double)requestedResolution.factor) / (double)time));
        }
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void putBytes(long x, long time) {
        long now = Time.systemIndependentCurrentJVMTimeMillis();
        x = Math.max(0L, x);
        time = Math.max(0L, time);
        Object object = this.LOCK;
        synchronized (object) {
            this.lastPutTime = now;
            if (x == 0L) {
                this.stalled += time;
                if (this.timeout > 0L && this.stalled > this.timeout) {
                    this.resetSpeedmeter();
                }
            } else {
                long thisTime;
                int index = this.index;
                long[] bytes = this.bytes;
                long[] times = this.times;
                long lastBytes = bytes[index];
                bytes[index] = x;
                long lastTime = times[index];
                times[index] = thisTime = time + this.stalled;
                this.totalValue = this.totalValue - lastBytes + x;
                this.totalTime = this.totalTime - lastTime + thisTime;
                this.stalled = 0L;
                this.index = (index + 1) % this.size;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resetSpeedmeter() {
        Object object = this.LOCK;
        synchronized (object) {
            int size = this.size;
            long[] bytes = this.bytes;
            long[] times = this.times;
            for (int index = 0; index < size; ++index) {
                bytes[index] = -1L;
                times[index] = 0L;
            }
            this.lastPutTime = -1L;
            this.index = 0;
            this.totalTime = 0L;
            this.totalValue = 0L;
        }
    }

    public void setStallTimeout(long timeout) {
        this.timeout = timeout <= 0L ? -1L : timeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putBytes(long x) {
        Object object = this.LOCK;
        synchronized (object) {
            long now = Time.systemIndependentCurrentJVMTimeMillis();
            if (this.lastPutTime == -1L) {
                this.lastPutTime = now;
            } else {
                this.putBytes(x, now - this.lastPutTime);
            }
        }
    }
}

