/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.speedmeter;

import org.appwork.utils.Time;

public interface SpeedMeterInterface {
    public void resetSpeedmeter();

    public long getValue(Resolution var1);

    public void putBytes(long var1, long var3);

    public Resolution getResolution();

    public static enum Resolution {
        SECONDS(1L){

            @Override
            public long getTime() {
                return Time.systemIndependentCurrentJVMTimeMillis() / 1000L;
            }
        }
        ,
        MILLI_SECONDS(1000L){

            @Override
            public long getTime() {
                return Time.systemIndependentCurrentJVMTimeMillis();
            }
        }
        ,
        MICRO_SECONDS(1000000L){

            @Override
            public long getTime() {
                return System.nanoTime() / 1000L;
            }
        }
        ,
        NANO_SECONDS(1000000000L){

            @Override
            public long getTime() {
                return System.nanoTime();
            }
        };

        public final long factor;

        public abstract long getTime();

        private Resolution(long factor) {
            this.factor = factor;
        }
    }
}

