/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.swing;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeListener;
import javax.swing.Action;
import javax.swing.TransferHandler;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.text.JTextComponent;
import org.appwork.utils.swing.HelpNotifierCallbackListener;

public class HelpNotifier
implements FocusListener,
CaretListener {
    private final JTextComponent field;
    protected Color defaultColor = null;
    protected Color watchColor = Color.GRAY;
    private String infoTxt = null;
    private final HelpNotifierCallbackListener listener;

    public static void register(JTextComponent field, HelpNotifierCallbackListener owner, String helpText) {
        new HelpNotifier(field, helpText, owner);
    }

    private HelpNotifier(final JTextComponent field, String helpTxt, HelpNotifierCallbackListener listener) {
        this.field = field;
        this.listener = listener;
        this.field.setText(helpTxt);
        this.infoTxt = helpTxt;
        this.defaultColor = field.getForeground();
        this.focusLost(null);
        this.caretUpdate(null);
        this.field.addCaretListener(this);
        this.field.addFocusListener(this);
        this.field.getActionMap().put("paste", new Action(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (field.getText().equals(HelpNotifier.this.infoTxt)) {
                    field.setText("");
                    field.setForeground(HelpNotifier.this.defaultColor);
                }
                TransferHandler.getPasteAction().actionPerformed(e);
            }

            @Override
            public void addPropertyChangeListener(PropertyChangeListener listener) {
            }

            @Override
            public Object getValue(String key) {
                return null;
            }

            @Override
            public boolean isEnabled() {
                return TransferHandler.getPasteAction().isEnabled();
            }

            @Override
            public void putValue(String key, Object value) {
            }

            @Override
            public void removePropertyChangeListener(PropertyChangeListener listener) {
            }

            @Override
            public void setEnabled(boolean b) {
            }
        });
    }

    @Override
    public void caretUpdate(CaretEvent arg0) {
        if (this.field != null) {
            if (this.field.getDocument().getLength() == 0 || this.field.getText().equals(this.infoTxt)) {
                if (this.listener != null) {
                    this.listener.onHelpNotifyShown(this.field);
                }
            } else if (this.listener != null) {
                this.listener.onHelpNotifyHidden(this.field);
                this.field.setForeground(this.defaultColor);
            }
        }
    }

    @Override
    public void focusGained(FocusEvent arg0) {
        if (this.field != null && this.field.getText().equals(this.infoTxt)) {
            this.field.setText("");
            this.field.setForeground(this.defaultColor);
        }
    }

    @Override
    public void focusLost(FocusEvent arg0) {
        if (this.field != null && (this.field.getDocument().getLength() == 0 || this.field.getText().equals(this.infoTxt))) {
            this.field.setText(this.infoTxt);
            this.field.setForeground(this.watchColor);
        }
    }
}

