/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.swing.dialog;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionListener;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import net.miginfocom.swing.MigLayout;
import org.appwork.utils.BinaryLogic;
import org.appwork.utils.locale._AWU;
import org.appwork.utils.swing.EDTHelper;
import org.appwork.utils.swing.dialog.AbstractDialog;
import org.appwork.utils.swing.dialog.Dialog;
import org.appwork.utils.swing.dialog.DialogCanceledException;
import org.appwork.utils.swing.dialog.DialogClosedException;
import org.appwork.utils.swing.dialog.DialogIcon;
import org.appwork.utils.swing.dialog.LoginDialogInterface;

public class LoginDialog
extends AbstractDialog<LoginData>
implements ActionListener,
CaretListener,
LoginDialogInterface {
    public static final int DISABLE_REMEMBER = 0x100000;
    protected JTextField accid;
    private JPasswordField pass;
    private Color titleColor;
    private String preUser;
    private String prePass;
    private boolean preSave = false;
    private JCheckBox save;
    private final boolean rememberDisabled;
    private String message;

    public static void main(String[] args) {
        try {
            LoginDialog d = new LoginDialog(0);
            LoginData response = Dialog.getInstance().showDialog(d);
            System.out.println("Remember logins: " + response.isSave());
            System.out.println("Username: " + response.getUsername());
            System.out.println("Password: " + response.getPassword());
        }
        catch (DialogClosedException e) {
            e.printStackTrace();
        }
        catch (DialogCanceledException e) {
            e.printStackTrace();
        }
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public LoginDialog(int flag) {
        this(flag, _AWU.T.AccountNew_AccountNew_title(), _AWU.T.AccountNew_AccountNew_message(), DialogIcon.DIALOG_LOGIN.get(32));
    }

    public LoginDialog(int flag, String title, String message, Icon icon) {
        super(flag & 0xFFFFFFFF & 0xFFFFFFDF, title, icon, null, null);
        this.rememberDisabled = BinaryLogic.containsAll(flag, 0x100000);
        this.message = message;
    }

    protected JLabel addSettingName(String name) {
        JLabel lbl = new JLabel(name);
        lbl.setForeground(this.titleColor);
        return lbl;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    @Override
    public void caretUpdate(CaretEvent e) {
        if (this.accid.getText().length() == 0) {
            this.okButton.setEnabled(false);
        } else {
            this.okButton.setEnabled(true);
        }
    }

    @Override
    protected LoginData createReturnValue() {
        if ((this.getReturnmask() & 0x22) == 0) {
            return null;
        }
        return new LoginData(this.accid.getText(), new String(this.pass.getPassword()), this.save.isSelected());
    }

    @Override
    public JComponent layoutDialogContent() {
        JPanel contentpane = new JPanel();
        this.titleColor = Color.DARK_GRAY;
        this.accid = new JTextField(10);
        this.accid.addCaretListener(this);
        this.pass = new JPasswordField(10);
        this.save = new JCheckBox();
        if (this.rememberDisabled) {
            this.save.setEnabled(false);
        }
        contentpane.setLayout(new MigLayout("ins 5, wrap 2", "[]10[grow,fill]", "[][]"));
        this.addUserNameField(contentpane);
        this.addPasswordField(contentpane);
        this.addSave(contentpane);
        this.accid.setText(this.preUser);
        this.pass.setText(this.prePass);
        this.save.setSelected(this.preSave);
        return contentpane;
    }

    protected void addPasswordField(JPanel contentpane) {
        contentpane.add(this.addSettingName(_AWU.T.AccountNew_layoutDialogContent_password()));
        contentpane.add((Component)this.pass, "sizegroup g1");
    }

    protected void addUserNameField(JPanel contentpane) {
        contentpane.add((Component)new JLabel(this.message), "spanx");
        contentpane.add(this.addSettingName(this.getTranslationUserName()));
        contentpane.add((Component)this.accid, "sizegroup g1,width 100:250:n");
    }

    protected String getTranslationUserName() {
        return _AWU.T.AccountNew_layoutDialogContent_accountname();
    }

    protected void addSave(JPanel contentpane) {
        contentpane.add(this.addSettingName(_AWU.T.AccountNew_layoutDialogContent_save()));
        contentpane.add((Component)this.save, "sizegroup g1");
    }

    @Override
    protected void packed() {
        super.packed();
        this.setResizable(false);
    }

    @Override
    protected void initFocus(JComponent focus) {
        this.accid.selectAll();
        this.accid.requestFocusInWindow();
    }

    public void setPasswordDefault(String password) {
        this.prePass = password;
    }

    public void setRememberDefault(boolean preSave) {
        this.preSave = preSave;
    }

    public void setUsernameDefault(String user) {
        this.preUser = user;
    }

    @Override
    public String getUsername() {
        if ((this.getReturnmask() & 0x22) == 0) {
            return null;
        }
        return (String)new EDTHelper<String>(){

            @Override
            public String edtRun() {
                return LoginDialog.this.accid.getText();
            }
        }.getReturnValue();
    }

    @Override
    public String getPassword() {
        if ((this.getReturnmask() & 0x22) == 0) {
            return null;
        }
        return (String)new EDTHelper<String>(){

            @Override
            public String edtRun() {
                return new String(LoginDialog.this.pass.getPassword());
            }
        }.getReturnValue();
    }

    @Override
    public String getDefaultUsername() {
        return this.preUser;
    }

    @Override
    public String getDefaultPassword() {
        return this.prePass;
    }

    @Override
    public boolean isDefaultRememberSelected() {
        return this.preSave;
    }

    @Override
    public boolean isRememberSelected() {
        if ((this.getReturnmask() & 0x22) == 0) {
            return false;
        }
        return new EDTHelper<Boolean>(){

            @Override
            public Boolean edtRun() {
                return LoginDialog.this.save.isSelected();
            }
        }.getReturnValue() == Boolean.TRUE;
    }

    @Override
    public boolean isRememberOptionVisible() {
        return !this.rememberDisabled;
    }

    public static class LoginData {
        private final String username;
        private final String password;
        private final boolean save;

        public LoginData(String username, String password, boolean save) {
            this.username = username;
            this.password = password;
            this.save = save;
        }

        public String getPassword() {
            return this.password;
        }

        public String getUsername() {
            return this.username;
        }

        public boolean isSave() {
            return this.save;
        }
    }
}

