/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.swing.dialog;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import net.miginfocom.swing.MigLayout;
import org.appwork.scheduler.DelayedRunnable;
import org.appwork.swing.MigPanel;
import org.appwork.swing.components.ExtCheckBox;
import org.appwork.swing.components.ExtPasswordField;
import org.appwork.swing.components.ExtTextArea;
import org.appwork.swing.components.ExtTextField;
import org.appwork.utils.BinaryLogic;
import org.appwork.utils.StringUtils;
import org.appwork.utils.locale._AWU;
import org.appwork.utils.net.httpconnection.HTTPProxy;
import org.appwork.utils.swing.EDTHelper;
import org.appwork.utils.swing.EDTRunner;
import org.appwork.utils.swing.dialog.AbstractDialog;
import org.appwork.utils.swing.dialog.DefaultButtonPanel;

public class ProxyDialog
extends AbstractDialog<HTTPProxy>
implements CaretListener {
    protected JComboBox<HTTPProxy.TYPE> cmbType;
    protected ExtTextField txtHost;
    protected ExtTextField txtPort;
    protected ExtTextField txtUser;
    private ExtPasswordField txtPass;
    private JLabel lblUser;
    private JLabel lblPass;
    private JLabel lblPort;
    private JLabel lblHost;
    private DelayedRunnable delayer;
    private final HTTPProxy proxy;
    private ExtTextArea desc;
    private String message;
    private ExtCheckBox cbAuth;
    private boolean authRequired = false;
    private ScheduledExecutorService executer;
    private JCheckBox remember;
    private JLabel rememberLbl;
    private Component lblCheckBox;

    public void setMessage(String message) {
        this.message = message;
    }

    public boolean isTypeEditable() {
        return true;
    }

    public boolean isHostEditable() {
        HTTPProxy.TYPE sel = (HTTPProxy.TYPE)this.cmbType.getSelectedItem();
        switch (sel) {
            case AUTO: 
            case NONE: {
                return false;
            }
        }
        return true;
    }

    public boolean isPortEditable() {
        HTTPProxy.TYPE sel = (HTTPProxy.TYPE)this.cmbType.getSelectedItem();
        switch (sel) {
            case AUTO: 
            case NONE: 
            case DIRECT: {
                return false;
            }
        }
        return true;
    }

    public ProxyDialog(HTTPProxy usedProxy, String message) {
        super(256, _AWU.T.proxydialog_title(), null, _AWU.T.lit_save(), _AWU.T.ABSTRACTDIALOG_BUTTON_CANCEL());
        this.proxy = usedProxy;
        this.message = message;
    }

    @Override
    protected MigPanel createBottomPanel() {
        return super.createBottomPanel();
    }

    @Override
    protected DefaultButtonPanel createBottomButtonPanel() {
        if (!this.isShowRemember()) {
            return super.createBottomButtonPanel();
        }
        DefaultButtonPanel ret = this.createButtonPanelImpl("ins 0", "[]", "0[grow,fill]0");
        this.remember = new JCheckBox();
        this.rememberLbl = new JLabel(_AWU.T.proxydialog_remember());
        ret.add((Component)this.rememberLbl, "");
        ret.add((Component)this.remember, "");
        return ret;
    }

    public boolean isRememberChecked() {
        return new EDTHelper<Boolean>(){

            @Override
            public Boolean edtRun() {
                return ProxyDialog.this.remember != null && ProxyDialog.this.remember.isSelected();
            }
        }.getReturnValue() == Boolean.TRUE;
    }

    protected boolean isShowRemember() {
        return false;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.updateCombinations();
        HTTPProxy.TYPE sel = (HTTPProxy.TYPE)this.cmbType.getSelectedItem();
        if (e.getSource() == this.cmbType) {
            switch (sel) {
                case HTTP: {
                    if (!this.txtPort.isUnchangedSetText() && !StringUtils.isEmpty(this.txtPort.getText())) break;
                    this.txtPort.setText("8080");
                    break;
                }
                case HTTPS: {
                    if (!this.txtPort.isUnchangedSetText() && !StringUtils.isEmpty(this.txtPort.getText())) break;
                    this.txtPort.setText("443");
                    break;
                }
                case SOCKS4: 
                case SOCKS4A: 
                case SOCKS5: {
                    if (!this.txtPort.isUnchangedSetText() && !StringUtils.isEmpty(this.txtPort.getText())) break;
                    this.txtPort.setText("1080");
                    break;
                }
                case AUTO: 
                case NONE: 
                case DIRECT: {
                    break;
                }
                default: {
                    if (!this.txtPort.isUnchangedSetText()) break;
                    this.txtPort.setText("1080");
                }
            }
            this.cbAuth.updateDependencies();
        } else {
            super.actionPerformed(e);
        }
    }

    protected void updateCombinations() {
        this.cmbType.setEnabled(this.isTypeEditable());
        this.txtPass.setEnabled(this.isPasswordEditable());
        this.lblPass.setEnabled(this.isPasswordEditable());
        this.lblUser.setEnabled(this.isUserEditable());
        this.txtUser.setEnabled(this.isUserEditable());
        if (!this.isPasswordEditable() && !this.isUserEditable()) {
            this.lblCheckBox.setEnabled(false);
            this.cbAuth.setEnabled(false);
            this.cbAuth.setSelected(false);
        } else {
            this.cbAuth.setEnabled(true);
            this.lblCheckBox.setEnabled(true);
        }
        this.txtPort.setEnabled(this.isPortEditable());
        this.lblPort.setEnabled(this.isPortEditable());
        this.lblHost.setEnabled(this.isHostEditable());
        this.txtHost.setEnabled(this.isHostEditable());
    }

    protected boolean isUserEditable() {
        HTTPProxy.TYPE sel = (HTTPProxy.TYPE)this.cmbType.getSelectedItem();
        switch (sel) {
            case AUTO: 
            case NONE: 
            case DIRECT: {
                return false;
            }
        }
        return true;
    }

    protected boolean isPasswordEditable() {
        HTTPProxy.TYPE sel = (HTTPProxy.TYPE)this.cmbType.getSelectedItem();
        switch (sel) {
            case AUTO: 
            case NONE: 
            case DIRECT: 
            case SOCKS4: 
            case SOCKS4A: {
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void caretUpdate(CaretEvent e) {
        block11: {
            boolean enable = false;
            try {
                HTTPProxy.TYPE sel = (HTTPProxy.TYPE)this.cmbType.getSelectedItem();
                switch (sel) {
                    case HTTP: 
                    case HTTPS: 
                    case SOCKS4: 
                    case SOCKS4A: 
                    case SOCKS5: {
                        break;
                    }
                    default: {
                        enable = true;
                    }
                }
                if (this.cmbType.getSelectedIndex() != 2) {
                    if (this.txtHost.getDocument().getLength() <= 0 || this.txtPort.getDocument().getLength() <= 0) break block11;
                    try {
                        int port = Integer.parseInt(this.txtPort.getText().trim());
                        if (port > 0 && port <= 65535) {
                            enable = true;
                        }
                        break block11;
                    }
                    catch (Throwable throwable) {}
                    break block11;
                }
                if (this.txtHost.getDocument().getLength() > 0) {
                    enable = true;
                }
            }
            finally {
                this.okButton.setEnabled(enable);
            }
        }
    }

    public HTTPProxy.TYPE getSelectedType() {
        return (HTTPProxy.TYPE)new EDTHelper<HTTPProxy.TYPE>(){

            @Override
            public HTTPProxy.TYPE edtRun() {
                return (HTTPProxy.TYPE)ProxyDialog.this.cmbType.getSelectedItem();
            }
        }.getReturnValue();
    }

    @Override
    protected HTTPProxy createReturnValue() {
        int mask = this.getReturnmask();
        if (BinaryLogic.containsSome(mask, 64)) {
            return null;
        }
        if (BinaryLogic.containsSome(mask, 4)) {
            return null;
        }
        try {
            HTTPProxy.TYPE type = this.getType();
            HTTPProxy.TYPE selected = (HTTPProxy.TYPE)this.cmbType.getSelectedItem();
            switch (selected) {
                case NONE: {
                    return HTTPProxy.NONE;
                }
                case DIRECT: {
                    type = HTTPProxy.TYPE.DIRECT;
                    return HTTPProxy.parseHTTPProxy("direct://" + this.txtHost.getText());
                }
            }
            HTTPProxy ret = new HTTPProxy(type, this.txtHost.getText(), Integer.parseInt(this.txtPort.getText().trim()));
            if (this.proxy != null) {
                ret.setPreferNativeImplementation(this.proxy.isPreferNativeImplementation());
            }
            ret.setPass(this.txtPass.getText());
            ret.setUser(this.txtUser.getText());
            return ret;
        }
        catch (Throwable e) {
            this.getLogger().log(e);
            return null;
        }
    }

    @Override
    public void dispose() {
        try {
            super.dispose();
            this.delayer.stop();
        }
        finally {
            try {
                this.executer.shutdown();
            }
            catch (Throwable throwable) {}
        }
    }

    public String getHost() {
        return this.txtHost.getText();
    }

    public String getPass() {
        return this.txtPass.getText();
    }

    public int getPort() {
        try {
            return Integer.parseInt(this.txtPort.getText());
        }
        catch (Exception e) {
            return -1;
        }
    }

    public HTTPProxy getProxy() {
        HTTPProxy ret = new HTTPProxy(this.getType());
        ret.setHost(this.getHost());
        ret.setPort(this.getPort());
        if (this.proxy != null) {
            ret.setPreferNativeImplementation(this.proxy.isPreferNativeImplementation());
        }
        if (this.isAuthEnabled()) {
            ret.setUser(this.getUser());
            ret.setPass(this.getPass());
        }
        return ret;
    }

    public HTTPProxy.TYPE getType() {
        return this.getSelectedType();
    }

    public String getUser() {
        return this.txtUser.getText();
    }

    private boolean isAuthEnabled() {
        return this.cbAuth.isSelected();
    }

    public boolean isAuthRequired() {
        return this.authRequired;
    }

    @Override
    public JComponent layoutDialogContent() {
        JPanel panel = new JPanel(new MigLayout("ins 0, wrap 4", "[][grow 10,fill][][grow 3,fill]"));
        this.desc = new ExtTextArea();
        this.desc.setText(this.message);
        this.desc.setLabelMode(true);
        this.cmbType = new JComboBox();
        this.cmbType.setModel(this.createModel());
        final ListCellRenderer<HTTPProxy.TYPE> org = this.cmbType.getRenderer();
        this.cmbType.setRenderer(new ListCellRenderer(){

            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                JLabel ret = (JLabel)org.getListCellRendererComponent(list, ((HTTPProxy.TYPE)value).getLabel(), index, isSelected, cellHasFocus);
                return ret;
            }
        });
        this.cmbType.addActionListener(this);
        this.lblHost = new JLabel(_AWU.T.ProxyDialog_hostport());
        this.desc.setFont(this.lblHost.getFont());
        this.txtHost = new ExtTextField(){

            @Override
            public void onChanged() {
                if (ProxyDialog.this.delayer != null) {
                    ProxyDialog.this.delayer.resetAndStart();
                }
            }
        };
        this.executer = Executors.newSingleThreadScheduledExecutor();
        this.delayer = new DelayedRunnable(this.executer, 2000L){

            @Override
            public void delayedrun() {
                new EDTRunner(){

                    @Override
                    protected void runInEDT() {
                        ProxyDialog.this.set(ProxyDialog.this.txtHost.getText());
                    }
                };
            }

            @Override
            public String getID() {
                return "ProxyDialog";
            }
        };
        this.txtHost.addCaretListener(this);
        this.lblPort = new JLabel(":");
        this.txtPort = new ExtTextField();
        this.txtPort.setText("88080");
        this.txtPort.setHelpText(_AWU.T.ProxyDialog_port_help());
        this.txtPort.setHorizontalAlignment(4);
        this.txtPort.setPreferredSize(this.txtPort.getPreferredSize());
        this.txtPort.addCaretListener(this);
        this.lblUser = new JLabel(_AWU.T.ProxyDialog_username());
        this.txtUser = new ExtTextField();
        this.lblPass = new JLabel(_AWU.T.ProxyDialog_password());
        this.txtPass = new ExtPasswordField();
        this.cbAuth = new ExtCheckBox(this.txtUser, this.lblPass, this.txtPass, this.lblUser);
        this.txtHost.setHelpText(_AWU.T.ProxyDialog_hostport_help());
        this.txtUser.setHelpText(_AWU.T.ProxyDialog_username_help());
        this.txtPass.setHelpText(_AWU.T.ProxyDialog_password_help());
        this.lblCheckBox = new JLabel(_AWU.T.ProxyDialog_requires_auth());
        MigPanel cbPanel = new MigPanel("ins 0", "[][grow]", "[]");
        cbPanel.add(this.cbAuth);
        cbPanel.add(this.lblCheckBox);
        panel.add((Component)this.desc, "spanx,pushx,growx,gapbottom 10");
        panel.add((Component)new JLabel(_AWU.T.ProxyDialog_type()), "gapleft 10");
        panel.add(this.cmbType, "spanx");
        panel.add((Component)this.lblHost, "gapleft 10");
        panel.add(this.txtHost);
        panel.add(this.lblPort);
        panel.add((Component)this.txtPort, "shrinkx");
        panel.add((Component)cbPanel, "spanx,gaptop 5,gapleft 5");
        panel.add((Component)this.lblUser, "gapleft 10");
        panel.add((Component)this.txtUser, "spanx");
        panel.add((Component)this.lblPass, "gapleft 10");
        panel.add((Component)this.txtPass, "spanx");
        this.okButton.setEnabled(true);
        this.registerFocus(this.txtPort);
        this.registerFocus(this.txtUser);
        this.registerFocus(this.txtHost);
        this.txtPort.setText("");
        this.set(this.proxy);
        this.cbAuth.setSelected(this.cbAuth.isSelected() || this.isAuthRequired());
        this.cbAuth.updateDependencies();
        this.updateCombinations();
        return panel;
    }

    protected ComboBoxModel<HTTPProxy.TYPE> createModel() {
        DefaultComboBoxModel<HTTPProxy.TYPE> model = new DefaultComboBoxModel<HTTPProxy.TYPE>();
        block3: for (HTTPProxy.TYPE t : HTTPProxy.TYPE.values()) {
            switch (t) {
                case AUTO: 
                case DIRECT: {
                    continue block3;
                }
                default: {
                    model.addElement(t);
                }
            }
        }
        return model;
    }

    private void registerFocus(final JTextField field) {
        field.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                field.selectAll();
            }

            @Override
            public void focusLost(FocusEvent e) {
            }
        });
    }

    protected void set(final HTTPProxy p) {
        if (p == null) {
            return;
        }
        new EDTRunner(){

            @Override
            protected void runInEDT() {
                ProxyDialog.this.updateCombinations();
                ProxyDialog.this.txtUser.setText(p.getUser());
                switch (p.getType()) {
                    case NONE: 
                    case DIRECT: {
                        ProxyDialog.this.cmbType.setSelectedItem(p.getType());
                        ProxyDialog.this.txtHost.setText(p.getLocal());
                        break;
                    }
                    case HTTP: 
                    case HTTPS: {
                        ProxyDialog.this.cmbType.setSelectedItem(p.getType());
                        ProxyDialog.this.txtHost.setText(p.getHost());
                        ProxyDialog.this.txtPort.setText(p.getPort() + "");
                        ProxyDialog.this.txtUser.setText(p.getUser());
                        ProxyDialog.this.txtPass.setText(p.getPass());
                        break;
                    }
                    case SOCKS4: 
                    case SOCKS4A: {
                        ProxyDialog.this.cmbType.setSelectedItem(p.getType());
                        ProxyDialog.this.txtHost.setText(p.getHost());
                        ProxyDialog.this.txtPort.setText(p.getPort() + "");
                        ProxyDialog.this.txtUser.setText(p.getUser());
                        break;
                    }
                    case SOCKS5: {
                        ProxyDialog.this.cmbType.setSelectedItem(HTTPProxy.TYPE.SOCKS5);
                        ProxyDialog.this.txtHost.setText(p.getHost());
                        ProxyDialog.this.txtPort.setText(p.getPort() + "");
                        ProxyDialog.this.txtUser.setText(p.getUser());
                        ProxyDialog.this.txtPass.setText(p.getPass());
                    }
                }
                ProxyDialog.this.cbAuth.setSelected(StringUtils.isNotEmpty(ProxyDialog.this.txtHost.getText()));
            }
        };
    }

    protected void set(String text) {
        int carPos = this.txtHost.getCaretPosition();
        String myText = text;
        if (myText.endsWith(":")) {
            return;
        }
        for (int i = 0; i < 2; ++i) {
            try {
                String userInfo;
                URL url = new URL(myText);
                this.txtHost.setText(url.getHost());
                if (url.getPort() > 0) {
                    this.txtPort.setText(url.getPort() + "");
                }
                if ((userInfo = url.getUserInfo()) != null) {
                    int in = userInfo.indexOf(":");
                    if (in >= 0) {
                        this.txtUser.setText(userInfo.substring(0, in));
                        this.txtPass.setText(userInfo.substring(in + 1));
                    } else {
                        this.txtUser.setText(userInfo);
                    }
                }
                return;
            }
            catch (MalformedURLException e) {
                if (!text.contains(":")) continue;
                myText = "http://" + myText;
                continue;
            }
        }
        this.txtHost.setCaretPosition(carPos);
    }

    public void setAuthRequired(final boolean b) {
        this.authRequired = b;
        if (this.cbAuth != null) {
            new EDTRunner(){

                @Override
                protected void runInEDT() {
                    ProxyDialog.this.cbAuth.setSelected(b);
                }
            };
        }
    }
}

