/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.swing.locator;

import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import org.appwork.utils.Hash;
import org.appwork.utils.StringUtils;
import org.appwork.utils.os.CrossSystem;
import org.appwork.utils.swing.SwingUtils;
import org.appwork.utils.swing.dialog.AbstractDialog;
import org.appwork.utils.swing.dialog.InternDialog;
import org.appwork.utils.swing.locator.CenterOfScreenLocator;
import org.appwork.utils.swing.locator.Locator;

public abstract class AbstractLocator
implements Locator {
    protected String id;

    public AbstractLocator() {
        this.id = null;
    }

    public AbstractLocator(String id) {
        this.id = id;
    }

    protected String getStorageID(Window frame) {
        return this.getClass().getName().replaceAll("(^.*\\.|[\\d\\$]+$)", "") + "-" + this.getID(frame);
    }

    public String getID() {
        return this.id;
    }

    public static String getAutoWindowID(Window window) {
        Class<?> windowClass;
        if (window instanceof InternDialog) {
            AbstractDialog dialog = ((InternDialog)window).getDialogModel();
            windowClass = dialog.getClass();
        } else {
            windowClass = window.getClass();
        }
        String title = "";
        if (window instanceof Dialog) {
            title = ((Dialog)window).getTitle();
        }
        if (StringUtils.isEmpty(title) && window instanceof Frame) {
            title = ((Frame)window).getTitle();
        }
        return windowClass.getName().replaceAll("[\\d\\$]+$", "") + "-" + Hash.getMD5(title);
    }

    protected String getID(Window window) {
        if (this.id == null) {
            this.id = AbstractLocator.getAutoWindowID(window);
        }
        return this.id;
    }

    public static Point correct(Point point, Window d) {
        Dimension prefSize = d.getSize();
        return AbstractLocator.correct(point, prefSize);
    }

    public static Point correct(Point point, Dimension prefSize) {
        GraphicsEnvironment ge;
        Rectangle preferedRect = new Rectangle(point.x, point.y, prefSize.width, prefSize.height);
        GraphicsDevice biggestInteresctionScreen = SwingUtils.getScreenByBounds(preferedRect);
        if (biggestInteresctionScreen == null && (biggestInteresctionScreen = (ge = GraphicsEnvironment.getLocalGraphicsEnvironment()).getDefaultScreenDevice()) == null) {
            System.out.println("GraphicsEnvironment.getDefaultScreenDevice returned null?!");
            return preferedRect.getLocation();
        }
        Rectangle bounds = SwingUtils.getUsableScreenBounds(biggestInteresctionScreen);
        if (CrossSystem.getOS().isMinimum(CrossSystem.OperatingSystem.WINDOWS_8)) {
            bounds.x -= 16;
            bounds.y -= 16;
            bounds.width += 32;
            bounds.height += 32;
        }
        if (preferedRect.x + preferedRect.width > bounds.x + bounds.width) {
            preferedRect.x = bounds.x + bounds.width - preferedRect.width;
        }
        if (preferedRect.y + preferedRect.height > bounds.y + bounds.height) {
            preferedRect.y = bounds.y + bounds.height - preferedRect.height;
        }
        if (preferedRect.x < bounds.x) {
            preferedRect.x = bounds.x;
        }
        if (preferedRect.y < bounds.y) {
            preferedRect.y = bounds.y;
        }
        return preferedRect.getLocation();
    }

    public static Point validate(Point point, Window dialog) {
        GraphicsDevice[] screens;
        point = AbstractLocator.correct(point, dialog);
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        for (GraphicsDevice screen : screens = ge.getScreenDevices()) {
            Rectangle bounds = screen.getDefaultConfiguration().getBounds();
            if (!bounds.contains(point)) continue;
            return point;
        }
        return new CenterOfScreenLocator().getLocationOnScreen(dialog);
    }
}

