/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.swing.renderer;

import java.awt.Color;
import java.awt.Component;
import javax.swing.Icon;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;
import org.appwork.resources.AWUTheme;
import org.appwork.utils.swing.renderer.RenderLabel;

public class MultipleRenderLabel
extends JPanel {
    private static final long serialVersionUID = -378709535509849986L;
    private RenderLabel left;
    private RenderLabel[] rights = null;
    private int ICONCOUNT = 0;

    public MultipleRenderLabel(int size) {
        super(new MigLayout("ins 0", "[]0[fill,grow,align right]"));
        this.rights = new RenderLabel[size];
        this.ICONCOUNT = size;
        this.left = new RenderLabel();
        this.add(this.left);
        this.left.setOpaque(false);
        for (int i = 0; i < this.ICONCOUNT; ++i) {
            this.rights[i] = new RenderLabel();
            this.add((Component)this.rights[i], "dock east");
            this.rights[i].setOpaque(false);
        }
        this.setOpaque(false);
    }

    public void clearIcons(int counter) {
        for (int i = counter; i < this.ICONCOUNT; ++i) {
            this.rights[i].setIcon(null);
            this.rights[i].setText(null);
            this.rights[i].setToolTipText(null);
        }
    }

    @Override
    public String getToolTipText() {
        StringBuilder sb = new StringBuilder();
        if (this.left.getToolTipText() != null) {
            sb.append(this.left.getToolTipText());
        }
        for (int i = this.rights.length - 1; i >= 0; --i) {
            if (this.rights[i].getToolTipText() == null) continue;
            if (sb.length() > 0) {
                sb.append(" | ");
            }
            sb.append(this.rights[i].getToolTipText());
        }
        if (sb.length() > 0) {
            return sb.toString();
        }
        return null;
    }

    @Override
    public void setEnabled(boolean b) {
        if (this.left == null) {
            return;
        }
        if (!b) {
            this.left.setDisabledIcon(AWUTheme.I().getDisabledIcon(this.left.getIcon()));
        }
        this.left.setEnabled(b);
        for (int i = 0; i < this.ICONCOUNT; ++i) {
            if (!b) {
                this.rights[i].setDisabledIcon(AWUTheme.I().getDisabledIcon(this.rights[i].getIcon()));
            }
            this.rights[i].setEnabled(b);
        }
    }

    @Override
    public void setForeground(Color fg) {
        super.setForeground(fg);
        if (this.left == null) {
            return;
        }
        this.left.setForeground(fg);
        for (RenderLabel right : this.rights) {
            right.setForeground(fg);
        }
    }

    public void setIcon(int i, Icon icon, String text, String tooltip) {
        if (i < 0 && this.ICONCOUNT > 0) {
            this.left.setIcon(icon);
            this.left.setToolTipText(tooltip);
        } else {
            if (i < 0 || i >= this.ICONCOUNT) {
                return;
            }
            this.rights[i].setIcon(icon);
            this.rights[i].setText(text);
            this.rights[i].setToolTipText(tooltip);
        }
    }

    public void setText(String text, Icon icon) {
        this.left.setIcon(icon);
        this.left.setText(text);
        this.left.setToolTipText(text);
    }
}

