/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.swing.windowmanager;

import java.awt.Window;
import java.lang.reflect.InvocationTargetException;
import org.appwork.utils.ReflectionUtils;
import org.appwork.utils.swing.windowmanager.ResetRunnable;
import org.appwork.utils.swing.windowmanager.WindowManager;
import org.appwork.utils.swing.windowmanager.WindowResetListener;
import org.appwork.utils.swing.windowmanager.WindowsWindowManager;

public class MacWindowManager
extends WindowsWindowManager {
    protected static boolean REQUESTFOREGROUND_SUPPORTED = true;

    @Override
    protected void initForegroundLock() {
    }

    @Override
    protected boolean setFocusableWindowState(Window w, boolean b) {
        return true;
    }

    @Override
    protected void putOffscreen(Window w, WindowManager.FrameState state) {
    }

    @Override
    public void setZState(Window w, WindowManager.FrameState state) {
        switch (state) {
            case OS_DEFAULT: {
                return;
            }
            case TO_FRONT_FOCUSED: {
                if (w.hasFocus()) {
                    return;
                }
                WindowResetListener hasListener = this.findListener(w);
                ResetRunnable runner = (ResetRunnable)this.runnerMap.get(w);
                if (runner == null) {
                    runner = new ResetRunnable(this, w, hasListener);
                    this.runnerMap.put(w, runner);
                    this.executeAfterASecond(runner);
                }
                runner.setState(state);
                this.setFocusableWindowState(w, true);
                this.setFocusable(w, true);
                this.setAlwaysOnTop(w, true);
                this.toFrontAltWorkaround(w, true);
                if (REQUESTFOREGROUND_SUPPORTED) {
                    try {
                        Object application = ReflectionUtils.invoke("com.apple.eawt.Application", "getApplication", null, Class.forName("com.apple.eawt.Application"), new Class[0], new Object[0]);
                        ReflectionUtils.invoke("com.apple.eawt.Application", "requestForeground", application, Void.TYPE, new Class[]{Boolean.TYPE}, new Object[]{true});
                    }
                    catch (NoSuchMethodError ignore) {
                        REQUESTFOREGROUND_SUPPORTED = false;
                    }
                    catch (IllegalAccessError ignore) {
                        REQUESTFOREGROUND_SUPPORTED = false;
                    }
                    catch (ClassNotFoundException e) {
                        REQUESTFOREGROUND_SUPPORTED = false;
                    }
                    catch (SecurityException e) {
                        REQUESTFOREGROUND_SUPPORTED = false;
                    }
                    catch (InvocationTargetException e) {
                        REQUESTFOREGROUND_SUPPORTED = false;
                    }
                }
                this.requestFocus(w);
                break;
            }
            case TO_BACK: {
                this.setAlwaysOnTop(w, false);
                this.toBack(w);
                break;
            }
            default: {
                WindowResetListener hasListener = this.findListener(w);
                ResetRunnable runner = (ResetRunnable)this.runnerMap.get(w);
                if (runner == null) {
                    runner = new ResetRunnable(this, w, hasListener);
                    this.runnerMap.put(w, runner);
                    this.executeAfterASecond(runner);
                }
                runner.setState(state);
                this.setFocusableWindowState(w, false);
                this.setAlwaysOnTop(w, true);
                this.toFrontAltWorkaround(w, false);
            }
        }
    }
}

