/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.launcher;

import java.io.File;
import java.security.Security;
import java.util.Arrays;
import org.appwork.app.launcher.parameterparser.ParameterParser;
import org.appwork.loggingv3.LogV3;
import org.appwork.resources.AWUTheme;
import org.appwork.shutdown.ShutdownController;
import org.appwork.utils.Application;
import org.appwork.utils.IO;
import org.appwork.utils.logging2.LogSource;
import org.appwork.utils.logging2.LogSourceRedirector;
import org.appwork.utils.os.CrossSystem;
import org.appwork.utils.singleapp.AnotherInstanceRunningException;
import org.appwork.utils.singleapp.IncommingMessageListener;
import org.appwork.utils.singleapp.Response;
import org.appwork.utils.singleapp.ResponseListener;
import org.appwork.utils.singleapp.SingleAppInstance;
import org.jdownloader.logging.LogController;
import org.jdownloader.startup.Main;
import org.jdownloader.updatev2.JDClassLoaderLauncher;
import org.jdownloader.updatev2.RestartController;

public class StandaloneLauncher {
    private static LogSource LOGGER;

    public static void main(final String[] args) throws Exception {
        LOGGER = LogController.getInstance().getLogger(StandaloneLauncher.class.getName());
        try {
            Application.printSystemProperties(LOGGER, Arrays.asList("env_MYJD_USER", "env_MYJD_PASSWORD", "env_JD_PASSWORD", "env_JD_EMAIL"));
        }
        catch (Throwable e) {
            Application.printSystemProperties(LOGGER);
        }
        LOGGER.info("Args: " + Arrays.toString(args));
        long t = System.currentTimeMillis();
        ParameterParser pp = RestartController.getInstance().getParameterParser(args);
        LOGGER.info("Restart Controller init done in " + (System.currentTimeMillis() - t));
        t = System.currentTimeMillis();
        LOGGER.info("Parse Arguments");
        pp.parse((File)null);
        LOGGER.info("Parameter Parse done in " + (System.currentTimeMillis() - t));
        t = System.currentTimeMillis();
        LOGGER.info("Single Instance Controller");
        SingleAppInstance singleInstance = null;
        if (!pp.hasCommandSwitch("n")) {
            singleInstance = new SingleAppInstance("JD2", Application.getTemp().getParentFile(), null);
            singleInstance.setForwardMessageDirectIfNoOtherInstanceIsFound(false);
            try {
                String[] stringArray;
                ResponseListener responseListener = new ResponseListener(){

                    @Override
                    public void onReceivedResponse(Response r) {
                        LOGGER.info("Received Response from existing instance: " + r);
                    }

                    @Override
                    public void onConnected(String[] message) {
                        LOGGER.info("existing jD instance found!");
                        LOGGER.info("Send parameters to existing jD instance and exit: " + Arrays.toString(args));
                    }
                };
                if (args.length == 0) {
                    String[] stringArray2 = new String[1];
                    stringArray = stringArray2;
                    stringArray2[0] = "--focus";
                } else {
                    stringArray = args;
                }
                singleInstance.start(responseListener, stringArray);
            }
            catch (AnotherInstanceRunningException e) {
                LOGGER.log(e);
                System.exit(1);
            }
            catch (SingleAppInstance.ErrorReadingResponseException e) {
                LOGGER.log(e);
            }
            catch (Exception e) {
                LOGGER.log(e);
                LOGGER.info("Instance Handling not possible!");
            }
        }
        StandaloneLauncher.launchJDownloader(args, singleInstance);
    }

    public static void launchJDownloader(String[] args, SingleAppInstance singleInstance) throws Exception {
        try {
            String jarName;
            File pidFile;
            long pid;
            if (!CrossSystem.isMac() && Application.isJared(StandaloneLauncher.class) && (pid = CrossSystem.getPID()) >= 1L && (!(pidFile = Application.getResource(jarName = Application.getJarName(StandaloneLauncher.class).replaceFirst("(?i)\\.jar$", ".pid"))).exists() || pidFile.isFile() && pidFile.delete())) {
                pidFile.deleteOnExit();
                IO.writeStringToFile(pidFile, Long.toString(pid) + "\n");
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        JDClassLoaderLauncher.updateClassPath();
        Main.main((String[])args);
        if (singleInstance != null) {
            singleInstance.setListener((IncommingMessageListener)Main.PARAMETER_HANDLER);
        }
    }

    static {
        File file;
        if (System.getProperty("org.appwork.LoggerFactory") == null) {
            System.setProperty("org.appwork.LoggerFactory", LogSourceRedirector.class.getName());
        }
        if (System.getProperty("java.net.preferIPv6Addresses") == null) {
            System.setProperty("java.net.preferIPv6Addresses", "system");
        }
        Application.setApplication(".jd_home");
        String root = Application.getRoot(StandaloneLauncher.class);
        LogV3.info("Application Root: " + root);
        System.setProperty("java.util.Arrays.useLegacyMergeSort", "true");
        try {
            Security.setProperty("networkaddress.cache.negative.ttl", "0");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        AWUTheme.I().setNameSpace("org/jdownloader/");
        ShutdownController.getInstance().setLogger(LogController.getInstance().getLogger(ShutdownController.class.getName()));
        if (System.getProperty("syserr") != null) {
            file = new File(System.getProperty("syserr"));
            Application.PauseableOutputStream stream = Application.ERR_OUT;
            Application.addStreamCopy(file, stream);
        }
        if (System.getProperty("sysout") != null) {
            file = new File(System.getProperty("sysout"));
            Application.addStreamCopy(file, Application.STD_OUT);
        }
    }
}

