/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.update;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.management.ManagementFactory;
import java.net.URISyntaxException;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.Pattern;
import org.appwork.console.AbstractConsole;
import org.appwork.console.ConsoleDialog;
import org.appwork.exceptions.WTFException;
import org.appwork.shutdown.ShutdownController;
import org.appwork.storage.config.handler.StorageHandler;
import org.appwork.updatesys.client.AbsoluteFile;
import org.appwork.updatesys.client.DisabledHIDProvider;
import org.appwork.updatesys.client.DownloadPackageInfo;
import org.appwork.updatesys.client.FailedActionException;
import org.appwork.updatesys.client.FileAccessHandler;
import org.appwork.updatesys.client.InstallException;
import org.appwork.updatesys.client.RandomAnonymousUIDProvider;
import org.appwork.updatesys.client.Setup;
import org.appwork.updatesys.client.UpdateClient;
import org.appwork.updatesys.client.UpdateClientSetupInterface;
import org.appwork.updatesys.client.http.ProxySelectorException;
import org.appwork.updatesys.client.iid.HIDProviderInterface;
import org.appwork.updatesys.client.iid.UIDProviderInterface;
import org.appwork.updatesys.client.install.AbstractBackupFileWriter;
import org.appwork.updatesys.client.install.InstallerAction;
import org.appwork.updatesys.client.jardelta.JarMergeException;
import org.appwork.updatesys.client.tracker.Tracker;
import org.appwork.updatesys.transport.Pkg;
import org.appwork.updatesys.transport.TransportException;
import org.appwork.updatesys.transport.exchange.DeduplicationMode;
import org.appwork.updatesys.transport.exchange.DownloadMirror;
import org.appwork.updatesys.transport.exchange.PackageInstallationHistory;
import org.appwork.updatesys.transport.exchange.Revision;
import org.appwork.updatesys.transport.exchange.SessionInitData;
import org.appwork.updatesys.transport.exchange.UninstallInfo;
import org.appwork.updatesys.transport.exchange.interfaces.PackageResponseInterface;
import org.appwork.updatesys.transport.exchange.track.DiscardReason;
import org.appwork.updatesys.transport.exchange.track.TrafficLog;
import org.appwork.utils.Application;
import org.appwork.utils.DebugMode;
import org.appwork.utils.ExtIOException;
import org.appwork.utils.NonInterruptibleRunnable;
import org.appwork.utils.StringUtils;
import org.appwork.utils.os.CrossSystem;
import org.jdownloader.update.JDUpdateClient;
import org.jdownloader.update.RevFile;
import org.jdownloader.update.SelfUpdateException;
import org.jdownloader.update.UpdateManager;
import org.jdownloader.updatev2.RestartController;
import org.jdownloader.updatev2.SmartRlyExitRequest;

public class SelfUpdateClient
extends UpdateClient {
    public static final String SELFTEST = "selftest";
    public static final String SELFUPDATE_ERROR = "selfupdateerror";
    public static final String OK = "OK";
    private UpdateManager updateManager;
    private ArrayList<String> installLog;
    private String jarname;
    protected final Tracker tracker;

    private static Setup convert(final UpdateClientSetupInterface setup) {
        Setup ret = new Setup(){

            @Override
            public String getApplicationIdentifier() {
                return "JDU";
            }

            @Override
            public String getPublicSignatureKey() {
                return setup.getPublicSignatureKey();
            }

            @Override
            public StorageHandler<?> _getStorageHandler() {
                throw new WTFException("Not Implemented");
            }

            @Override
            public String[] getUpdateServers() {
                return setup.getUpdateServers();
            }

            @Override
            public String getNamespace() {
                return "JDU";
            }

            @Override
            public UninstallInfo getUninstall() {
                return null;
            }
        };
        return ret;
    }

    public ArrayList<String> getInstallLog() {
        return this.installLog;
    }

    @Override
    protected String[] getUpdateServers() {
        return JDUpdateClient.getUpdateServers(this, super.getUpdateServers());
    }

    @Override
    protected void jarCopy(AbstractBackupFileWriter backuplist, AbsoluteFile local, String relPath) throws FailedActionException {
        try {
            if (local.exists()) {
                return;
            }
            File orgFile = Application.getResource(relPath);
            if (orgFile.exists()) {
                AbsoluteFile parent = local.getParentFile();
                if (!parent.exists()) {
                    this.installFolder(backuplist, parent.getRelative(), null, false);
                }
                this.getFileSystem().copyFile(orgFile, local, true, null);
            }
        }
        catch (Exception e) {
            throw new FailedActionException((UpdateClient)this, (Throwable)new JarMergeException(local.getName() + "copy  error", e));
        }
    }

    public Tracker getTracker() {
        return this.tracker;
    }

    @Override
    protected File download(DownloadMirror mirrorToUseFirst) throws TransportException, InterruptedException, IOException, URISyntaxException, InstallException, ProxySelectorException {
        return super.download(mirrorToUseFirst);
    }

    @Override
    public void trackException(Throwable e) {
        this.getLogger().log(e);
        try {
            Tracker tracker = this.getTracker();
            if (tracker != null && tracker.isEnabled()) {
                tracker.pushItem(tracker.wrap(e));
            }
        }
        catch (Throwable e1) {
            this.getLogger().log(e1);
        }
    }

    @Override
    protected Pkg createPkgRequest() throws ExtIOException {
        return new Pkg(this){

            @Override
            protected DownloadPackageInfo getDownloadPackageInfo() {
                return null;
            }

            @Override
            public String getResumeUrlParameter() {
                return null;
            }
        };
    }

    @Override
    protected ArrayList<InstallerAction> installFile(AbstractBackupFileWriter backuplist, InputStream input, String relPath, String signature) throws FailedActionException, InterruptedException {
        if (this.installLog != null) {
            this.installLog.add(relPath);
        }
        return super.installFile(backuplist, input, relPath, signature);
    }

    public SelfUpdateClient(JDUpdateClient updater, UpdateManager updateManager) throws InvalidKeySpecException, NoSuchAlgorithmException, IOException, InterruptedException {
        super(SelfUpdateClient.convert(updater.getSetup()), updater.getBuilder());
        this.updateManager = updateManager;
        this.tracker = new Tracker(this){

            @Override
            public boolean isEnabled() {
                return DebugMode.TRUE_IN_IDE_ELSE_FALSE;
            }
        };
    }

    @Override
    protected File initWorkingDirectory() {
        String nameSpace = this.getSetup().getNamespace();
        if (StringUtils.isEmpty(nameSpace)) {
            nameSpace = "JDU";
        }
        return Application.getTempResource("update/self/" + nameSpace + "/");
    }

    @Override
    protected void fixPathesToToUniqueSetupIDChange(UpdateClientSetupInterface setup) throws InterruptedException {
        super.fixPathesToToUniqueSetupIDChange(setup);
        if (DebugMode.TRUE_IN_IDE_ELSE_FALSE) {
            File repoConfig = this.getPathBuilder().getRepoStorageResource(this, "");
            String oldID = setup.getApplicationIdentifier();
            File oldRepoConfig = new File(repoConfig.getAbsolutePath().replaceAll(Pattern.quote(setup.getNamespace()), oldID).replace("\\repos\\", "\\versioninfo\\"));
            File revisionFile = this.getPathBuilder().getRevisionFile(this);
            File backupFile = this.getPathBuilder().getBackupFile(this);
            File failedCleanUps = this.getPathBuilder().getFailedCleanupsFile(this);
            File filelist = this.getPathBuilder().getFilelist(this);
            File serverOptions = this.getPathBuilder().getServerOptionsFilePath(this);
            File tmpFolder = this.getPathBuilder().getTmpFolder(this);
            File uid = this.getPathBuilder().getUIDFile(this);
            String optionals = this.getPathBuilder().getOptionalConfigPath(this);
            System.out.println(uid);
        }
    }

    @Override
    protected void trackDownloadTraffic(TrafficLog entry, TrafficLog.STATUS status, Throwable throwable) {
    }

    @Override
    protected void trackDiscardedPackage(PackageResponseInterface pkg, long fileSize, DiscardReason reason) {
    }

    private void move(File root, String string) throws ExtIOException, InterruptedException {
        File src = Application.getResource(string);
        if (src.isFile()) {
            File dest = new File(root, string);
            FileAccessHandler fileSystem = this.getFileSystem();
            fileSystem.mkdirs(dest.getParentFile());
            fileSystem.copyFile(src, dest, true, null);
            this.getLogger().info("Copy from src:" + src + " -> dest:" + dest);
            this.getLogger().info("File exists: " + dest.exists() + " " + dest.length() + " bytes - " + dest);
        }
    }

    @Override
    protected void installJarDif(String relPath, String filename) {
        this.installLog.add("JD: " + relPath + "/" + filename);
    }

    public void finishSelfUpdate() throws SelfUpdateException, InterruptedException {
        File root = Application.getTemp().getParentFile();
        String relSelfTest = "tmp/selftest_" + System.currentTimeMillis();
        File selfTestFile = Application.getResource(relSelfTest);
        try {
            this.getFileSystem().deleteFileIfExists(selfTestFile);
        }
        catch (ExtIOException e) {
            throw new SelfUpdateException(e, "Cannot delete " + selfTestFile);
        }
        ArrayList<String> call = new ArrayList<String>();
        call.add(CrossSystem.getJavaBinary());
        List<String> lst = ManagementFactory.getRuntimeMXBean().getInputArguments();
        for (String h : lst) {
            if (h.startsWith("-agentlib:") || h.startsWith("-Djava.library.path=") || h.startsWith("-Dinstall4j.launcherId=") || h.startsWith("-Dexe4j.consoleCodepage=") || h.startsWith("-Dinstall4j.swt=") || h.startsWith("-Dexe4j.semaphoreName=") || h.startsWith("-Dexe4j.isInstall4j=") || h.startsWith("-Dexe4j.tempDir=") || h.startsWith("-Dexe4j.unextractedPosition=") || !h.startsWith("-")) continue;
            this.getLogger().info("Added argument " + h);
            call.add(h);
        }
        call.add("-jar");
        call.add(new File(this.getWorkingDirectory(), "JDownloader.jar").getAbsolutePath());
        call.add("-selftest");
        call.add(relSelfTest);
        call.add(root.getAbsolutePath());
        Process process = null;
        try {
            try {
                File workingDir = this.getWorkingDirectory();
                this.move(workingDir, "libs/laf/synthetica.jar");
                this.move(workingDir, "libs/laf/syntheticaJDCustom.jar");
                this.move(workingDir, "libs/laf/syntheticaSimple2D.jar");
                this.move(workingDir, "cfg/updateclient/HttpSettings.proxy.json");
                this.move(workingDir, "cfg/updateclient/HttpSettings.json");
                this.move(workingDir, "cfg/org.jdownloader.settings.InternetConnectionSettings.json");
                this.move(workingDir, "cfg/org.jdownloader.settings.InternetConnectionSettings.customproxylist.json");
                this.move(workingDir, "cfg/org.jdownloader.settings.InternetConnectionSettings.directgatewaylist.json");
                this.getLogger().info("Call " + call + " in " + root);
                for (String s : call) {
                    this.getLogger().info(s);
                }
                process = this.updateManager.runExeAsynch(call, root);
                if (process == null && CrossSystem.isOS2()) {
                    this.logger.info("Could not start ProcessBuilder on OS2");
                }
                long start = System.currentTimeMillis();
                final Process finalProcess = process;
                final AtomicLong processDuration = new AtomicLong(-1L);
                final long currentTimeStamp = System.currentTimeMillis();
                final AtomicBoolean processWaitForWorkaround = new AtomicBoolean(false);
                Thread processObserver = new Thread("ProcessObserver"){

                    @Override
                    public void run() {
                        int exitCode = -1;
                        try {
                            exitCode = finalProcess.waitFor();
                            SelfUpdateClient.this.logger.info("Process terminated. This should not happen! Exit Value: " + exitCode);
                        }
                        catch (InterruptedException e) {
                            SelfUpdateClient.this.logger.log(e);
                            return;
                        }
                        finally {
                            processDuration.set(System.currentTimeMillis() - currentTimeStamp);
                            if (CrossSystem.isLinux() && processDuration.get() < 5000L && StringUtils.contains(System.getProperty("os.version"), "2.6.")) {
                                System.out.println("Enable Workaround for Process.waitFor issue!");
                                processWaitForWorkaround.set(true);
                            }
                        }
                    }
                };
                try {
                    processObserver.setDaemon(true);
                    processObserver.start();
                    while (true) {
                        Thread.sleep(1000L);
                        this.logger.info("Test ");
                        if (Thread.interrupted()) {
                            throw new InterruptedException();
                        }
                        if (System.currentTimeMillis() - start > 300000L) {
                            this.logger.info("5 min ex ");
                            throw new SelfUpdateException("Selftest took more than 5 minutes");
                        }
                        if (!processObserver.isAlive()) {
                            if (processWaitForWorkaround.get()) {
                                System.out.println("Workaround for Process.waitFor issue!");
                            } else {
                                throw new SelfUpdateException("Selftest has been terminated unexpectedly");
                            }
                        }
                        this.logger.info("Running ");
                        if (!selfTestFile.exists()) continue;
                        this.logger.info("File exists ");
                        Thread.sleep(2000L);
                        boolean b = this.validateSelfTestFile(selfTestFile);
                        if (!b) break;
                    }
                    throw new InterruptedException("Vetos in Shutdown");
                }
                catch (Throwable throwable) {
                    processObserver.interrupt();
                    throw throwable;
                }
            }
            catch (IOException e1) {
                throw new SelfUpdateException(e1);
            }
        }
        catch (Throwable throwable) {
            try {
                if (process != null) {
                    process.destroy();
                }
            }
            catch (Throwable e) {
                this.getLogger().log(e);
            }
            throw throwable;
        }
    }

    @Override
    protected UIDProviderInterface initUIDProvider() throws ExtIOException {
        return new RandomAnonymousUIDProvider(this);
    }

    @Override
    public HIDProviderInterface getHIDProvider() {
        if (this.hidProvider == null) {
            this.hidProvider = new DisabledHIDProvider(this);
        }
        return this.hidProvider;
    }

    @Override
    protected Revision internalWriteRevision() throws ExtIOException {
        return (Revision)new NonInterruptibleRunnable<Revision, ExtIOException>(){

            @Override
            public Revision run() throws ExtIOException, InterruptedException {
                FileAccessHandler fileSystem = SelfUpdateClient.this.getFileSystem();
                if (new File(SelfUpdateClient.this.getWorkingDirectory(), SelfUpdateClient.this.getJarName()).exists()) {
                    Revision rev = SelfUpdateClient.this.getDestRevision();
                    File logFile = new File(SelfUpdateClient.this.getRevFile().getParentFile(), "self_" + SelfUpdateClient.this.readRevision().getId() + "_to_" + rev.getId() + ".log");
                    SelfUpdateClient.this.getRevFile().write(rev.getId());
                    try {
                        fileSystem.writeToFile(logFile, "EMPTY".getBytes(UpdateClient.UTF8), true);
                    }
                    catch (ExtIOException e) {
                        SelfUpdateClient.this.getLogger().log(e);
                    }
                    return rev;
                }
                File logFile = Application.getResource("logs/updatehistory/self_" + SelfUpdateClient.this.readRevision().getId() + "_to_" + SelfUpdateClient.this.getDestRevision().getId() + ".log");
                Revision rev = SelfUpdateClient.super.internalWriteRevision();
                try {
                    fileSystem.writeToFile(logFile, "EMPTY".getBytes(UpdateClient.UTF8), true);
                }
                catch (ExtIOException e) {
                    SelfUpdateClient.this.getLogger().log(e);
                }
                return rev;
            }
        }.startAndWait();
    }

    @Override
    protected void addPackageInstallationHistory(File file, PackageInstallationHistory marker) {
    }

    public void onSelfUpdateSuccessful() throws ExtIOException, InterruptedException {
        this.cleanupTmp();
    }

    protected boolean isJarUpdateEntryLoggingEnabled() {
        return true;
    }

    @Override
    public void runPackageInstallation(File file) throws InterruptedException, InstallException {
        super.runPackageInstallation(file);
    }

    protected String getJarName() {
        try {
            if (this.jarname != null) {
                return this.jarname;
            }
            this.jarname = Application.getJarName(null);
            return this.jarname;
        }
        catch (IllegalStateException e) {
            this.jarname = "JDownloader.jar";
            return "JDownloader.jar";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean validateSelfTestFile(final File file) throws SelfUpdateException, IOException {
        String selfTestResult = (String)new NonInterruptibleRunnable<String, ExtIOException>(){

            @Override
            public String run() throws ExtIOException, InterruptedException {
                return SelfUpdateClient.this.getFileSystem().readFileToString(file);
            }
        }.startAndWait();
        this.logger.info("Validate:  " + selfTestResult);
        this.getLogger().info("SelfTest Results: \r\n" + selfTestResult);
        if (OK.equals(selfTestResult.trim())) {
            this.logger.info(OK);
            file.deleteOnExit();
            this.logger.info("Self Update successful");
            if (Application.isHeadless() && AbstractConsole.newInstance() != null) {
                Object object = AbstractConsole.LOCK;
                synchronized (object) {
                    ConsoleDialog cd = new ConsoleDialog("Restart Required");
                    cd.start();
                    boolean norestart = false;
                    for (String s : RestartController.getInstance().getFilteredRestartParameters(new String[0])) {
                        if (!s.equalsIgnoreCase("-norestart")) continue;
                        norestart = true;
                        break;
                    }
                    if (!norestart) {
                        cd.println("JDownloader Updated and restarted itself.");
                        cd.println("The process restarted itself and runs now in the background: " + ManagementFactory.getRuntimeMXBean().getName());
                        cd.println("If you do not want JD to restart itself, use the -norestart switch.");
                        cd.end();
                    } else {
                        cd.println("JDownloader Updated Itself and will exit now.");
                        cd.println("Please restart JDownloader after a few seconds.");
                        cd.println("Make sure that there is no running JDownloader process before restarting.");
                        cd.end();
                    }
                    Application.STD_OUT.setBufferEnabled(true);
                    Application.ERR_OUT.setBufferEnabled(true);
                }
            }
            return ShutdownController.getInstance().requestShutdown(new SmartRlyExitRequest());
        }
        this.logger.info("Exception");
        throw new SelfUpdateException("Unexpected Selftest Result: " + selfTestResult);
    }

    @Override
    public void writeRevisionFile() {
    }

    public void writeSuperRevision(int getdRev) throws ExtIOException {
        File dest = this.getRevisionFile();
        FileAccessHandler fileSystem = this.getFileSystem();
        fileSystem.secureWrite(dest, String.valueOf(getdRev).getBytes(UpdateClient.UTF8), true);
    }

    @Override
    public void runPackageInstallation(File file, boolean awfFormat) throws InterruptedException, InstallException {
        this.installLog = new ArrayList();
        FileAccessHandler fileSystem = this.getFileSystem();
        File jd = new File(this.getWorkingDirectory(), this.updateManager.getJarName());
        File jdTmp = new File(jd.getAbsolutePath() + ".backup");
        try {
            if (jd.exists()) {
                fileSystem.deleteFileIfExists(jdTmp);
                fileSystem.mkdirs(jdTmp.getParentFile());
                fileSystem.copyFile(jd, jdTmp, true, null);
            }
            int preRevision = this.readRevision().getId();
            RevFile revFile = this.getRevFile();
            super.runPackageInstallation(file, awfFormat);
            if (!jd.exists()) {
                File dest = this.getRevisionFile();
                fileSystem.secureWrite(dest, String.valueOf(this.getDestRevision().getId()).getBytes(UpdateClient.UTF8), true);
                fileSystem.deleteFileIfExists(revFile);
            } else {
                revFile.write(this.getDestRevision().getId());
            }
            this.writeInstallLog(file, preRevision);
        }
        catch (IOException e) {
            this.logger.log(e);
            if (jdTmp.exists()) {
                this.logger.info("Delete: " + jd.getAbsolutePath() + "=" + jd.delete());
            }
            this.logger.info("Rename: " + jdTmp.getAbsolutePath() + "->" + jd.getAbsolutePath() + "=" + jdTmp.renameTo(jd));
            throw new InstallException((UpdateClient)this, (Throwable)ExtIOException.getInstance(e, ExtIOException.IOExceptionType.LOCAL));
        }
        finally {
            try {
                fileSystem.deleteFileIfExists(jdTmp);
            }
            catch (ExtIOException e) {
                throw new InstallException((UpdateClient)this, (Throwable)e);
            }
        }
    }

    @Override
    protected DeduplicationMode getMaxSupportedDeduplicationMode() {
        return DeduplicationMode.INTRA;
    }

    @Override
    protected SessionInitData createSessionInitData() {
        return null;
    }

    protected void writeInstallLog(File file, int preRevision) throws ExtIOException {
        if (this.getInstallLog() != null) {
            FileOutputStream fos = null;
            Writer output = null;
            final FileAccessHandler fileSystem = this.getFileSystem();
            try {
                final File logFile = new File(this.getRevFile().getParentFile(), "self_" + preRevision + "_to_" + this.getRevFile().read() + ".log");
                fos = (FileOutputStream)new NonInterruptibleRunnable<FileOutputStream, ExtIOException>(){

                    @Override
                    public FileOutputStream run() throws ExtIOException, InterruptedException {
                        fileSystem.mkdirs(logFile.getParentFile());
                        fileSystem.deleteFileIfExists(logFile);
                        return fileSystem.openFileOutputStream(logFile, false);
                    }
                }.startAndWait();
                this.logger.info("Write LogFile: " + logFile);
                output = new BufferedWriter(new OutputStreamWriter((OutputStream)fos, "UTF-8"));
                output.write(new Date().toString());
                output.write("\r\n");
                output.write("Package: " + file.getName() + "\r\n");
                HashSet<String> set = new HashSet<String>();
                for (String s : this.sortedList(this.getInstallLog())) {
                    set.add(s);
                    this.logger.info(s);
                    output.write("   " + s + "\r\n");
                }
            }
            catch (IOException e) {
                throw ExtIOException.getInstance(e, ExtIOException.IOExceptionType.LOCAL);
            }
            finally {
                try {
                    output.flush();
                }
                catch (Throwable throwable) {}
                try {
                    output.close();
                }
                catch (Throwable throwable) {}
                try {
                    fos.close();
                }
                catch (Throwable throwable) {}
            }
        }
    }

    private List<String> sortedList(Collection<String> modifiedPlugins) {
        ArrayList<String> ret = new ArrayList<String>(modifiedPlugins);
        Collections.sort(ret);
        return ret;
    }

    public Revision superReadRevision() {
        return super.readRevision();
    }

    @Override
    public Revision readRevision() {
        Revision rev = this.superReadRevision();
        int revFile = this.getRevFile().read();
        if (revFile > rev.getId()) {
            return new Revision(revFile);
        }
        return rev;
    }

    public RevFile getRevFile() {
        RevFile revfile = new RevFile(this, this.getWorkingDirectory());
        return revfile;
    }

    public void cleanupTmp() throws ExtIOException, InterruptedException {
        int max = 5;
        while (true) {
            File logs = new File(this.getWorkingDirectory(), "logs");
            try {
                this.getFileSystem().copyFolderRecursive(logs, Application.getResource("logs"), true, null, null);
                this.deleteFileOrFolderRecursive(this.getWorkingDirectory(), null, true);
                return;
            }
            catch (ExtIOException e) {
                if (--max <= 0) {
                    throw ExtIOException.getInstance(e, ExtIOException.IOExceptionType.LOCAL);
                }
                Thread.sleep(4000L);
                continue;
            }
            break;
        }
    }

    public boolean hasPendingUpdate() {
        return new File(this.getWorkingDirectory(), this.getJarName()).exists() && this.getRevFile().read() > this.superReadRevision().getId();
    }

    public List<String> getPendingLogList() {
        ArrayList<String> ret = new ArrayList<String>();
        try {
            File[] files = this.getRevFile().getParentFile().listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.endsWith(".log");
                }
            });
            if (files != null) {
                for (File f : files) {
                    ret.add(f.getName());
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ret;
    }
}

