/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.update.gui.bubble;

import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.TrayIcon;
import javax.swing.ImageIcon;
import org.appwork.utils.swing.EDTRunner;
import org.jdownloader.update.gui.bubble.AbstractNotifyWindow;
import org.jdownloader.update.gui.bubble.UpdateNotifyContentPanel;
import org.jdownloader.update.locale.T;

public class UpdateNotifyWindow
extends AbstractNotifyWindow<UpdateNotifyContentPanel> {
    private Dimension lastPref;
    private int maxWidth = 260;
    private int maxHeight = 65;
    private TrayIcon trayIcon;

    public UpdateNotifyWindow() {
        super(T.T.installonexitframe_title(), new UpdateNotifyContentPanel());
    }

    @Override
    public void setVisible(boolean b) {
        if (b) {
            this.updateLocation();
        } else {
            GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
            Rectangle bounds = ge.getDefaultScreenDevice().getDefaultConfiguration().getBounds();
            if (this.lastPref != null) {
                this.lastPref = this.getPreferredSize();
            }
            this.setPreferedLocation(bounds.x + bounds.width - this.lastPref.width - 10, bounds.y + bounds.height);
        }
        super.setVisible(b);
    }

    protected void updateLocation() {
        Dimension pref = this.getPreferredSize();
        if (!pref.equals(this.lastPref)) {
            this.pack();
        }
        this.lastPref = pref;
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        Rectangle bounds = ge.getDefaultScreenDevice().getDefaultConfiguration().getBounds();
        Insets insets = Toolkit.getDefaultToolkit().getScreenInsets(ge.getDefaultScreenDevice().getDefaultConfiguration());
        bounds.x += insets.left;
        bounds.y += insets.top;
        bounds.width -= insets.left + insets.right;
        bounds.height -= insets.top + insets.bottom;
        this.setStartLocation(new Point(bounds.x + bounds.width - this.lastPref.width - 10, bounds.y + bounds.height + insets.bottom));
        this.setPreferedLocation(bounds.x + bounds.width - this.lastPref.width - 10, bounds.y + bounds.height - this.lastPref.height - 10);
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension ret = super.getPreferredSize();
        ret.width = Math.max(ret.width, this.maxWidth);
        ret.height = Math.max(ret.height, this.maxHeight);
        this.maxWidth = Math.max(this.maxWidth, ret.width);
        this.maxHeight = Math.max(this.maxHeight, ret.height);
        return ret;
    }

    public void setCancelText(String cancelText) {
    }

    public void setIcon(ImageIcon icon) {
    }

    public void setText(final String text) {
        new EDTRunner(){

            @Override
            protected void runInEDT() {
                ((UpdateNotifyContentPanel)UpdateNotifyWindow.this.getContentComponent()).setText(text);
                UpdateNotifyWindow.this.updateLocation();
                if (UpdateNotifyWindow.this.trayIcon != null) {
                    UpdateNotifyWindow.this.trayIcon.setToolTip(text);
                }
            }
        };
    }

    public void setProgress(final double d) {
        new EDTRunner(){

            @Override
            protected void runInEDT() {
                ((UpdateNotifyContentPanel)UpdateNotifyWindow.this.getContentComponent()).setProgress(d);
                UpdateNotifyWindow.this.updateLocation();
            }
        };
    }
}

