/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.container;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import jd.controlling.linkcrawler.CrawledLink;
import jd.crypt.AESencrypt;
import jd.crypt.Base16Decoder;
import jd.crypt.BaseDecoder;
import jd.nutils.encoding.Base64;
import jd.parser.Regex;
import jd.parser.html.HTMLParser;
import jd.plugins.ContainerStatus;
import jd.plugins.PluginsC;

public class R
extends PluginsC {
    private final byte[] RSDF = new byte[]{-116, 53, 25, 45, -106, 77, -61, 24, 44, 111, -124, -13, 37, 34, 57, -21, 74, 50, 13, 37, 0, 0, 0, 0};
    private final byte[] RSDFIV = new byte[]{-93, -43, -93, 60, -71, 90, -63, -11, -53, -37, 26, -46, 92, -80, -89, -86};

    public R() {
        super("RSDF", "file:/.+\\.rsdf$", "$Revision: 45974 $");
    }

    public R newPluginInstance() {
        return new R();
    }

    public static String asHex(byte[] buf) {
        StringBuffer strbuf = new StringBuffer(buf.length * 2);
        strbuf.append("new byte[]{");
        for (int i = 0; i < buf.length; ++i) {
            strbuf.append("(byte) 0x");
            if ((buf[i] & 0xFF) < 16) {
                strbuf.append("0");
            }
            strbuf.append(Long.toString(buf[i] & 0xFF, 16));
            if (i >= buf.length - 1) continue;
            strbuf.append(", ");
        }
        strbuf.append("};");
        return strbuf.toString();
    }

    public ContainerStatus callDecryption(File lc) {
        ContainerStatus cs = new ContainerStatus(lc);
        try {
            this.cls = new ArrayList();
            String[] fileContent = this.loadFileContent(lc.getAbsolutePath());
            if (fileContent != null) {
                for (String element : fileContent) {
                    if (element == null || element.length() <= 0) continue;
                    this.cls.add(new CrawledLink((CharSequence)element));
                }
            }
            if (this.cls.size() > 0) {
                cs.setStatus(2);
            } else {
                cs.setStatus(4);
            }
            return cs;
        }
        catch (IllegalArgumentException e) {
            this.logger.log((Throwable)e);
        }
        catch (SecurityException e) {
            this.logger.log((Throwable)e);
        }
        cs.setStatus(4);
        return cs;
    }

    private String[] decrypt(String rsdf) throws IOException, BaseDecoder.IllegalAlphabetException {
        String[] lines;
        byte[] k;
        String input64;
        String links;
        block8: {
            links = "";
            input64 = new String(new Base16Decoder().decode(rsdf.toCharArray()));
            k = null;
            try {
                k = this.RSDF;
            }
            catch (Throwable e) {
                this.logger.log(e);
                if (k != null) break block8;
                this.logger.severe("RSDF Decryption failed.");
                return null;
            }
        }
        this.getEKey(k);
        if (k == null) {
            this.logger.severe("RSDF Decryption failed.");
            return new String[0];
        }
        AESencrypt aes = new AESencrypt(k, 6);
        byte[] temp = new byte[16];
        byte[] iv = null;
        try {
            iv = this.RSDFIV;
        }
        catch (Throwable e) {
            this.logger.log(e);
        }
        for (String line : lines = Regex.getLines((String)input64)) {
            byte[] input = Base64.decode((String)line);
            byte[] output = new byte[input.length];
            for (int i = 0; i < input.length; ++i) {
                aes.Cipher(iv, temp);
                output[i] = (byte)(input[i] ^ temp[0]);
                for (int j = 1; j < 16; ++j) {
                    iv[j - 1] = iv[j];
                }
                iv[15] = input[i];
            }
            String str = new String(output);
            str = str.replaceAll("CCF\\:", " CCF: ");
            str = str.replaceAll("http:/", "\r\nhttp:/");
            links = links + str;
        }
        return HTMLParser.getHttpLinks((String)links, null);
    }

    public String[] encrypt(String plain) {
        return null;
    }

    private String filterRSDF(String rsdf) {
        rsdf = rsdf.trim().toUpperCase();
        this.logger.info("RSDF length: " + rsdf.length() + "   ");
        String ret = "";
        block3: for (int i = 0; i < rsdf.length(); ++i) {
            switch (rsdf.charAt(i)) {
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': 
                case 'A': 
                case 'B': 
                case 'C': 
                case 'D': 
                case 'E': 
                case 'F': {
                    ret = ret + rsdf.charAt(i);
                    continue block3;
                }
                default: {
                    if (i <= 0) continue block3;
                    this.logger.info("iii" + i);
                    return ret;
                }
            }
        }
        return rsdf;
    }

    public String getCoder() {
        return "astaldo/JD-Team";
    }

    private void getEKey(byte[] key) {
        for (int i = 0; i < key.length; ++i) {
            int n = i;
            key[n] = (byte)(key[n] - (byte)i);
        }
    }

    private String getLocalFile(File file) {
        StringBuffer buffer = new StringBuffer();
        try {
            String line;
            BufferedReader f = new BufferedReader(new FileReader(file));
            while ((line = f.readLine()) != null) {
                buffer.append(line + "\r\n");
            }
            f.close();
            return buffer.toString();
        }
        catch (IOException e) {
            this.logger.log((Throwable)e);
            return "";
        }
    }

    private String[] loadFileContent(String filename) {
        String rsdf = this.filterRSDF(this.getLocalFile(new File(filename)).trim());
        if (rsdf == null) {
            return new String[0];
        }
        try {
            String[] links = this.decrypt(rsdf);
            return links;
        }
        catch (Exception e) {
            this.logger.log((Throwable)e);
            return null;
        }
    }
}

