/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.extensions.extraction;

import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import jd.controlling.packagecontroller.AbstractPackageChildrenNode;
import jd.controlling.packagecontroller.AbstractPackageNode;
import org.appwork.storage.JSonStorage;
import org.appwork.storage.Storable;
import org.appwork.storage.TypeRef;
import org.appwork.utils.Hash;
import org.appwork.utils.StringUtils;
import org.jdownloader.extensions.extraction.ArchiveController;
import org.jdownloader.extensions.extraction.BooleanStatus;
import org.jdownloader.extensions.extraction.ExtractionInfo;
import org.jdownloader.settings.IfFileExistsAction;

public class ArchiveSettings
implements Storable {
    public static final TypeRef<ArchiveSettings> TYPE_REF = new TypeRef<ArchiveSettings>(){};
    private ArchiveController archiveController;
    private BooleanStatus autoExtract = BooleanStatus.UNSET;
    private ExtractionInfo extractionInfo;
    private String extractPath;
    private String finalPassword;
    private IfFileExistsAction ifFileExistsAction = null;
    private volatile CopyOnWriteArrayList<String> passwords = new CopyOnWriteArrayList();
    private BooleanStatus removeDownloadLinksAfterExtraction = BooleanStatus.UNSET;
    private BooleanStatus removeFilesAfterExtraction = BooleanStatus.UNSET;
    public static final String PASSWORD = "PASSWORD";
    public static final String AUTO_EXTRACT = "AUTO_EXTRACT";
    private String archiveID = null;
    private String settingsID = null;
    private WeakHashMap<AbstractPackageChildrenNode<?>, Object> assignedLinks = null;
    private String lastStorableHash = null;

    protected WeakHashMap<AbstractPackageChildrenNode<?>, Object> _getAssignedLinks() {
        if (this.assignedLinks == null) {
            this.assignedLinks = new WeakHashMap();
        }
        return this.assignedLinks;
    }

    public String _getArchiveID() {
        return this.archiveID;
    }

    public String _getSettingsID() {
        return this.settingsID;
    }

    protected void assignController(ArchiveController archiveController, String archiveID, String settingsID) {
        this.archiveController = archiveController;
        this.archiveID = archiveID;
        this.settingsID = settingsID;
        this.lastStorableHash = Hash.getSHA256((String)JSonStorage.toString((Object)this));
    }

    public BooleanStatus getAutoExtract() {
        return this.autoExtract;
    }

    public ExtractionInfo getExtractionInfo() {
        return this.extractionInfo;
    }

    public String getExtractPath() {
        return this.extractPath;
    }

    public String getFinalPassword() {
        return this.finalPassword;
    }

    public String getIfFileExistsAction() {
        IfFileExistsAction ifFileExistsAction = this.ifFileExistsAction;
        if (ifFileExistsAction == null) {
            return null;
        }
        return ifFileExistsAction.toString();
    }

    public IfFileExistsAction _getIfFileExistsAction() {
        return this.ifFileExistsAction;
    }

    public List<String> getPasswords() {
        return this.passwords;
    }

    public BooleanStatus getRemoveDownloadLinksAfterExtraction() {
        return this.removeDownloadLinksAfterExtraction;
    }

    public BooleanStatus getRemoveFilesAfterExtraction() {
        return this.removeFilesAfterExtraction;
    }

    private void fireUpdate() {
        if (this.archiveController != null) {
            this.archiveController.update(this);
        }
    }

    public void setAutoExtract(BooleanStatus overwriteFiles) {
        if (overwriteFiles == null) {
            overwriteFiles = BooleanStatus.UNSET;
        }
        this.autoExtract = overwriteFiles;
        this.fireUpdate();
    }

    public void setExtractionInfo(ExtractionInfo extractionInfo) {
        this.extractionInfo = extractionInfo;
        this.fireUpdate();
    }

    public void setExtractPath(String extractPath) {
        this.extractPath = extractPath;
        this.fireUpdate();
    }

    public void setFinalPassword(String password) {
        this.finalPassword = password;
        this.fireUpdate();
    }

    public void setIfFileExistsAction(String overwriteFiles) {
        try {
            if (overwriteFiles == null) {
                return;
            }
            this._setIfFileExistsAction(IfFileExistsAction.valueOf((String)overwriteFiles));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void _setIfFileExistsAction(IfFileExistsAction overwriteFiles) {
        this.ifFileExistsAction = overwriteFiles;
        this.fireUpdate();
    }

    public void setPasswords(List<String> passwords) {
        this.passwords = passwords == null || passwords.size() == 0 ? new CopyOnWriteArrayList() : new CopyOnWriteArrayList<String>(passwords);
        this.fireUpdate();
    }

    public void setRemoveDownloadLinksAfterExtraction(BooleanStatus overwriteFiles) {
        this.removeDownloadLinksAfterExtraction = overwriteFiles;
        this.fireUpdate();
    }

    public void setRemoveFilesAfterExtraction(BooleanStatus overwriteFiles) {
        this.removeFilesAfterExtraction = overwriteFiles;
        this.fireUpdate();
    }

    protected boolean _needsSaving() {
        String storableHash = Hash.getSHA256((String)JSonStorage.toString((Object)this));
        return !StringUtils.equals((String)this.lastStorableHash, (String)storableHash);
    }

    protected Boolean _exists() {
        WeakHashMap<AbstractPackageChildrenNode<?>, Object> assignedLinks = this.assignedLinks;
        if (assignedLinks == null) {
            return null;
        }
        for (Map.Entry<AbstractPackageChildrenNode<?>, Object> entry : assignedLinks.entrySet()) {
            AbstractPackageNode parent = (AbstractPackageNode)entry.getKey().getParentNode();
            if (parent == null || parent.getControlledBy() == null) continue;
            return true;
        }
        return false;
    }
}

