/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.extensions.extraction;

import java.awt.Color;
import java.text.NumberFormat;
import jd.plugins.FilePackageView;
import jd.plugins.PluginProgress;
import org.appwork.swing.exttable.columns.ExtProgressColumn;
import org.appwork.utils.formatter.TimeFormatter;
import org.jdownloader.extensions.extraction.ExtractionController;
import org.jdownloader.extensions.extraction.translate.T;
import org.jdownloader.gui.views.downloads.columns.ETAColumn;
import org.jdownloader.gui.views.downloads.columns.ProgressColumn;
import org.jdownloader.images.NewTheme;
import org.jdownloader.plugins.PluginTaskID;

public class ExtractionProgress
extends PluginProgress {
    protected long lastCurrent = -1L;
    protected long lastTotal = -1L;
    protected long startTimeStamp = -1L;
    protected String message = null;
    private NumberFormat df = NumberFormat.getInstance();

    public ExtractionProgress(ExtractionController controller, long current, long total, Color color) {
        super(current, total, color);
        this.setIcon(NewTheme.I().getIcon("extract", 16));
        this.message = T.T.plugins_optional_extraction_status_extracting2();
        super.setProgressSource((Object)controller);
    }

    public PluginTaskID getID() {
        return PluginTaskID.EXTRACTION;
    }

    public void setProgressSource(Object progressSource) {
    }

    public void updateValues(long current, long total) {
        super.updateValues(current, total);
        if (this.startTimeStamp == -1L || this.lastTotal == -1L || this.lastTotal != total || this.lastCurrent == -1L || this.lastCurrent > current) {
            this.lastTotal = total;
            this.lastCurrent = current;
            this.startTimeStamp = System.currentTimeMillis();
            return;
        }
        long currentTimeDifference = System.currentTimeMillis() - this.startTimeStamp;
        if (currentTimeDifference <= 0L) {
            return;
        }
        long speed = current * 10000L / currentTimeDifference;
        if (speed == 0L) {
            return;
        }
        long eta = (total - current) * 10000L / speed;
        this.setETA(eta);
    }

    public String getMessage(Object requestor) {
        if (requestor != null && this.getETA() > 0L) {
            if (requestor instanceof ETAColumn) {
                return TimeFormatter.formatMilliSeconds((long)this.getETA(), (int)0);
            }
            if (requestor instanceof FilePackageView) {
                return this.message + " (ETA: " + TimeFormatter.formatMilliSeconds((long)this.getETA(), (int)0) + ")";
            }
            if (requestor instanceof ProgressColumn) {
                return this.df.format(ExtProgressColumn.getPercentString((long)this.getCurrent(), (long)this.getTotal())) + "%";
            }
        }
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }
}

