/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.extensions.extraction.content;

import java.io.File;
import org.jdownloader.extensions.extraction.content.ContentNode;
import org.jdownloader.extensions.extraction.content.PackedFile;

public class ContentView
extends PackedFile {
    private volatile int totalFolderCount = 0;
    private int totalFileCount = 0;
    private long totalSize = 0L;

    public int getTotalFolderCount() {
        return this.totalFolderCount;
    }

    public int getTotalFileCount() {
        return this.totalFileCount;
    }

    public long getTotalSize() {
        return this.totalSize;
    }

    public ContentView() {
        super(true, "/", -1L);
    }

    @Override
    public synchronized void add(PackedFile packedFile) {
        ContentNode p = this.mkParent(packedFile.getParent());
        if (!packedFile.isDirectory()) {
            ++this.totalFileCount;
            if (packedFile.getSize() > 0L) {
                this.totalSize += packedFile.getSize();
            }
        } else {
            if (p.getChildren().containsKey(packedFile.getName())) {
                return;
            }
            ++this.totalFolderCount;
        }
        if (p == this) {
            super.add(packedFile);
        } else {
            p.add(packedFile);
        }
    }

    private ContentNode mkParent(String parent) {
        if (parent == null) {
            return this;
        }
        String[] path = parent.split("[/\\\\]");
        StringBuilder cPath = new StringBuilder();
        PackedFile n = this;
        for (String s : path) {
            if (cPath.length() > 0) {
                cPath.append(File.separatorChar);
            }
            cPath.append(s);
            PackedFile ret = n.getChildren().get(s);
            if (ret == null) {
                ret = new PackedFile(true, cPath.toString(), -1L);
                this.add(ret);
            }
            n = ret;
        }
        return n;
    }
}

