/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.extensions.extraction.contextmenu.downloadlist;

import java.awt.event.ActionEvent;
import java.lang.ref.WeakReference;
import java.util.List;
import jd.controlling.linkcrawler.CrawledLink;
import jd.controlling.linkcrawler.CrawledPackage;
import jd.gui.swing.jdgui.MainTabbedPane;
import jd.gui.swing.jdgui.interfaces.View;
import jd.plugins.DownloadLink;
import jd.plugins.FilePackage;
import org.appwork.utils.swing.EDTRunner;
import org.jdownloader.extensions.AbstractExtensionAction;
import org.jdownloader.extensions.extraction.Archive;
import org.jdownloader.extensions.extraction.ExtractionExtension;
import org.jdownloader.extensions.extraction.contextmenu.downloadlist.ArchiveValidator;
import org.jdownloader.gui.views.SelectionInfo;
import org.jdownloader.gui.views.components.packagetable.PackageControllerTable;
import org.jdownloader.gui.views.downloads.DownloadsView;
import org.jdownloader.gui.views.downloads.table.DownloadsTable;
import org.jdownloader.gui.views.linkgrabber.LinkGrabberTable;
import org.jdownloader.gui.views.linkgrabber.LinkGrabberView;

public abstract class AbstractExtractionContextAction
extends AbstractExtensionAction<ExtractionExtension> {
    private volatile WeakReference<PackageControllerTable.SelectionInfoCallback<?, ?>> lastCallBack = new WeakReference<Object>(null);

    public void requestUpdate(Object requestor) {
        super.requestUpdate(requestor);
        this.requestUpdateSelection();
    }

    protected void getSelectedArchives(final ArchivesCallback callback) {
        View view = MainTabbedPane.getInstance().getSelectedView();
        if (view instanceof DownloadsView) {
            DownloadsTable.getInstance().getSelectionInfo((PackageControllerTable.SelectionInfoCallback)new PackageControllerTable.SelectionInfoCallback<FilePackage, DownloadLink>(){
                {
                    AbstractExtractionContextAction.this.lastCallBack = new WeakReference<1>(this);
                }

                public void onSelectionInfo(final SelectionInfo<FilePackage, DownloadLink> selectionInfo) {
                    final ArchiveValidator.ArchiveValidation result = ArchiveValidator.validate(selectionInfo, true);
                    result.executeWhenReached(new Runnable(){

                        @Override
                        public void run() {
                            callback.onArchives(result.getArchives(), selectionInfo);
                        }
                    });
                }

                public boolean isCancelled() {
                    if (!callback.isCancellable()) {
                        return false;
                    }
                    WeakReference lastCallBack = AbstractExtractionContextAction.this.lastCallBack;
                    return lastCallBack.get() != this;
                }
            }, PackageControllerTable.SelectionType.SELECTED);
        } else if (view instanceof LinkGrabberView) {
            LinkGrabberTable.getInstance().getSelectionInfo((PackageControllerTable.SelectionInfoCallback)new PackageControllerTable.SelectionInfoCallback<CrawledPackage, CrawledLink>(){
                {
                    AbstractExtractionContextAction.this.lastCallBack = new WeakReference<2>(this);
                }

                public void onSelectionInfo(final SelectionInfo<CrawledPackage, CrawledLink> selectionInfo) {
                    final ArchiveValidator.ArchiveValidation result = ArchiveValidator.validate(selectionInfo, true);
                    result.executeWhenReached(new Runnable(){

                        @Override
                        public void run() {
                            callback.onArchives(result.getArchives(), selectionInfo);
                        }
                    });
                }

                public boolean isCancelled() {
                    if (!callback.isCancellable()) {
                        return false;
                    }
                    WeakReference lastCallBack = AbstractExtractionContextAction.this.lastCallBack;
                    return lastCallBack.get() != this;
                }
            }, PackageControllerTable.SelectionType.SELECTED);
        }
    }

    protected void onAsyncInitDone(List<Archive> archives, SelectionInfo<?, ?> selectionInfo) {
        if (selectionInfo != null && !selectionInfo.isEmpty()) {
            this.setVisible(true);
            if (archives != null && archives.size() > 0) {
                super.setEnabled(true);
            } else {
                super.setEnabled(false);
            }
        } else {
            this.setVisible(false);
            this.setEnabled(false);
        }
    }

    public void actionPerformed(final ActionEvent e) {
        this.getSelectedArchives(new ArchivesCallback(){

            @Override
            public void onArchives(final List<Archive> archives, final SelectionInfo<?, ?> selectionInfo) {
                new EDTRunner(){

                    protected void runInEDT() {
                        if (archives == null) {
                            return;
                        }
                        if (!AbstractExtractionContextAction.this.isEnabled()) {
                            return;
                        }
                        AbstractExtractionContextAction.this.onActionPerformed(e, archives, selectionInfo);
                    }
                };
            }

            @Override
            public boolean isCancellable() {
                return false;
            }
        });
    }

    protected abstract void onActionPerformed(ActionEvent var1, List<Archive> var2, SelectionInfo<?, ?> var3);

    protected void requestUpdateSelection() {
        this.setEnabled(false);
        this.getSelectedArchives(new ArchivesCallback(){

            @Override
            public void onArchives(final List<Archive> archives, final SelectionInfo<?, ?> selectionInfo) {
                new EDTRunner(){

                    protected void runInEDT() {
                        AbstractExtractionContextAction.this.onAsyncInitDone(archives, selectionInfo);
                    }
                };
            }

            @Override
            public boolean isCancellable() {
                return true;
            }
        });
    }

    protected static interface ArchivesCallback {
        public void onArchives(List<Archive> var1, SelectionInfo<?, ?> var2);

        public boolean isCancellable();
    }
}

