/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.extensions.extraction.contextmenu.downloadlist.action;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import org.appwork.utils.StringUtils;
import org.appwork.utils.swing.dialog.Dialog;
import org.appwork.utils.swing.dialog.DialogCanceledException;
import org.appwork.utils.swing.dialog.DialogClosedException;
import org.jdownloader.extensions.extraction.Archive;
import org.jdownloader.extensions.extraction.contextmenu.downloadlist.AbstractExtractionContextAction;
import org.jdownloader.extensions.extraction.translate.T;
import org.jdownloader.gui.views.SelectionInfo;
import org.jdownloader.images.NewTheme;

public class SetExtractPasswordAction
extends AbstractExtractionContextAction {
    public SetExtractPasswordAction() {
        this.setName(T.T.contextmenu_password());
        this.setIconKey("password");
    }

    @Override
    protected void onActionPerformed(ActionEvent e, List<Archive> archives, SelectionInfo<?, ?> selectionInfo) {
        try {
            String pw;
            StringBuilder sb = new StringBuilder();
            LinkedHashSet<String> list = new LinkedHashSet<String>();
            for (Archive archive : archives) {
                String finalPassword = archive.getSettings().getFinalPassword();
                if (finalPassword == null) continue;
                list.add(finalPassword);
            }
            for (Archive archive : archives) {
                List<String> pws = archive.getSettings().getPasswords();
                if (pws == null) continue;
                list.addAll(pws);
            }
            if (list != null && list.size() > 0) {
                for (String s : list) {
                    if (sb.length() > 0) {
                        sb.append("\r\n");
                    }
                    sb.append(s);
                }
            }
            if (!StringUtils.isEmpty((String)(pw = archives.size() > 1 ? Dialog.getInstance().showInputDialog(0, T.T.context_password(), list == null || list.size() == 0 ? T.T.context_password_msg_multi() : T.T.context_password_msg2_multi(sb.toString()), null, NewTheme.getInstance().getIcon("password", 32), null, null) : Dialog.getInstance().showInputDialog(0, T.T.context_password(), list == null || list.size() == 0 ? T.T.context_password_msg(archives.get(0).getName()) : T.T.context_password_msg2(archives.get(0).getName(), sb.toString()), null, NewTheme.getInstance().getIcon("password", 32), null, null)))) {
                list.add(pw);
                for (Archive archive : archives) {
                    archive.setPasswords(new ArrayList<String>(list));
                }
            }
        }
        catch (DialogClosedException e1) {
            e1.printStackTrace();
        }
        catch (DialogCanceledException e1) {
            e1.printStackTrace();
        }
    }
}

