/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.extensions.extraction.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import jd.controlling.TaskQueue;
import jd.gui.swing.jdgui.components.IconedProcessIndicator;
import org.appwork.swing.components.ExtButton;
import org.appwork.swing.components.tooltips.ExtTooltip;
import org.appwork.swing.components.tooltips.ToolTipController;
import org.appwork.swing.components.tooltips.ToolTipHandler;
import org.appwork.swing.exttable.ExtColumn;
import org.appwork.swing.exttable.columns.ExtComponentColumn;
import org.appwork.utils.event.queue.QueueAction;
import org.jdownloader.actions.AppAction;
import org.jdownloader.extensions.extraction.ExtractionController;
import org.jdownloader.extensions.extraction.ExtractionEvent;
import org.jdownloader.extensions.extraction.ExtractionExtension;
import org.jdownloader.extensions.extraction.gui.ExtractionJobTable;
import org.jdownloader.extensions.extraction.gui.ExtractionJobTableModel;
import org.jdownloader.extensions.extraction.gui.ExtractorToolTip;
import org.jdownloader.gui.translate._GUI;
import org.jdownloader.images.AbstractIcon;
import org.jdownloader.images.NewTheme;

public class ExtractorProgress
extends IconedProcessIndicator {
    private static final long serialVersionUID = -7582954114939419184L;
    private ExtractorToolTip tooltip;
    private ExtractionExtension extension;
    private JPopupMenu pu;
    private ExtractionJobTableModel tModel;
    private ExtractionJobTable table;

    public ExtractorProgress(ExtractionExtension extractionExtension) {
        super(NewTheme.I().getIcon("extract", 16));
        this.setEnabled(false);
        this.setTitle(_GUI.T.StatusBarImpl_initGUI_extract());
        this.extension = extractionExtension;
        this.tooltip = new ExtractorToolTip(extractionExtension);
        this.pu = new JPopupMenu();
        this.tModel = new ExtractionJobTableModel(){
            private static final long serialVersionUID = 7254604415572431495L;

            @Override
            protected void initColumns() {
                super.initColumns();
                this.addColumn((ExtColumn)new ExtComponentColumn<ExtractionController>(_GUI.T.lit_cancel()){
                    private static final long serialVersionUID = 261994408344732524L;
                    private ExtButton renderer;
                    private ExtButton editor;
                    private ExtractionController activeValue;
                    {
                        this.renderer = this.getButton();
                        this.editor = this.getButton();
                    }

                    protected JComponent getInternalEditorComponent(ExtractionController value, boolean isSelected, int row, int column) {
                        return this.editor;
                    }

                    private ExtButton getButton() {
                        ExtButton ret = new ExtButton((AbstractAction)new AppAction(){
                            private static final long serialVersionUID = -2183896670625238331L;
                            {
                                this.setSmallIcon((Icon)new AbstractIcon("cancel", 16));
                            }

                            public void actionPerformed(ActionEvent e) {
                                TaskQueue.getQueue().add((QueueAction)new QueueAction<Void, RuntimeException>(){

                                    protected Void run() throws RuntimeException {
                                        ExtractorProgress.this.extension.cancel(activeValue);
                                        return null;
                                    }
                                });
                                ExtractorProgress.this.pu.setVisible(false);
                            }
                        });
                        ret.setRolloverEffectEnabled(true);
                        return ret;
                    }

                    public int getDefaultWidth() {
                        return 25;
                    }

                    public int getMaxWidth() {
                        return this.getDefaultWidth();
                    }

                    public int getMinWidth() {
                        return this.getDefaultWidth();
                    }

                    protected JComponent getInternalRendererComponent(ExtractionController value, boolean isSelected, boolean hasFocus, int row, int column) {
                        return this.renderer;
                    }

                    public void configureEditorComponent(ExtractionController value, boolean isSelected, int row, int column) {
                        this.activeValue = value;
                    }

                    public void configureRendererComponent(ExtractionController value, boolean isSelected, boolean hasFocus, int row, int column) {
                    }

                    public void resetEditor() {
                    }

                    public void resetRenderer() {
                    }
                });
            }
        };
        this.table = new ExtractionJobTable(this.tModel);
        this.pu.add((Component)((Object)this.table));
        this.pu.add((Component)new ExtButton((AbstractAction)new AppAction(){
            private static final long serialVersionUID = -2183896670625238331L;
            {
                this.setSmallIcon((Icon)new AbstractIcon("cancel", 16));
                this.setName(_GUI.T.literally_abort_all());
            }

            public void actionPerformed(ActionEvent e) {
                TaskQueue.getQueue().add((QueueAction)new QueueAction<Void, RuntimeException>(){

                    protected Void run() throws RuntimeException {
                        ExtractorProgress.this.extension.abortAll();
                        return null;
                    }
                });
                ExtractorProgress.this.pu.setVisible(false);
            }
        }));
        this.pu.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                ToolTipController.getInstance().register((ToolTipHandler)ExtractorProgress.this);
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
                ToolTipController.getInstance().register((ToolTipHandler)ExtractorProgress.this);
            }
        });
    }

    public boolean isTooltipDisabledUntilNextRefocus() {
        return false;
    }

    public ExtTooltip createExtTooltip(Point mousePosition) {
        this.tooltip.update();
        return this.tooltip;
    }

    public void mouseClicked(MouseEvent e) {
        if (e.isPopupTrigger() || e.getButton() == 3) {
            List<ExtractionController> jpobs;
            if (this.table.isEditing()) {
                this.table.getCellEditor().stopCellEditing();
            }
            if ((jpobs = this.extension.getJobQueue().getJobs()).size() > 0) {
                this.tModel._fireTableStructureChanged(jpobs, true);
                ToolTipController.getInstance().unregister((ToolTipHandler)this);
                Dimension psize = this.pu.getPreferredSize();
                this.pu.show((Component)((Object)this), -psize.width + this.getWidth(), -psize.height);
            } else {
                ToolTipController.getInstance().show((ToolTipHandler)this);
            }
        } else {
            ToolTipController.getInstance().show((ToolTipHandler)this);
        }
    }

    public void update(ExtractionEvent.Type type, ExtractionController con) {
        if (this.tooltip.getParent() != null) {
            this.tooltip.update();
        }
        switch (type) {
            case EXTRACTING: {
                this.setIndeterminate(false);
                break;
            }
            case START: {
                this.setIndeterminate(true);
                this.setValue(10);
            }
            case QUEUED: {
                if (con.getExtractionQueue().size() > 0 && !this.isEnabled()) {
                    this.setEnabled(true);
                }
                if (this.pu.isVisible()) {
                    if (this.table.isEditing()) {
                        this.table.getCellEditor().stopCellEditing();
                    }
                    this.tModel._fireTableStructureChanged(this.extension.getJobQueue().getJobs(), true);
                }
                return;
            }
            case CLEANUP: {
                this.setIndeterminate(false);
                if (this.pu.isVisible()) {
                    if (this.table.isEditing()) {
                        this.table.getCellEditor().stopCellEditing();
                    }
                    this.tModel._fireTableStructureChanged(this.extension.getJobQueue().getJobs(), true);
                }
                this.setValue(0);
                if (con.getExtractionQueue().size() <= 1 && this.isEnabled()) {
                    this.setEnabled(false);
                }
                return;
            }
        }
        List<ExtractionController> entries = this.extension.getJobQueue().getJobs();
        double progress = 0.0;
        for (ExtractionController ec : entries) {
            if (ec.getArchive().getContentView().getTotalSize() <= 0L) continue;
            progress += ec.getProgress();
        }
        if (entries.size() > 0) {
            progress /= (double)entries.size();
        }
        this.setValue((int)progress);
        if (!this.isIndeterminate() && progress <= 0.0) {
            this.setIndeterminate(true);
        }
        if (this.pu.isVisible()) {
            this.tModel.refreshSort();
        }
    }
}

