/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.extensions.extraction.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import javax.swing.JLabel;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import org.appwork.swing.components.tooltips.PanelToolTip;
import org.appwork.swing.components.tooltips.TooltipPanel;
import org.appwork.utils.swing.SwingUtils;
import org.jdownloader.extensions.extraction.ExtractionController;
import org.jdownloader.extensions.extraction.ExtractionExtension;
import org.jdownloader.extensions.extraction.gui.ExtractionJobTable;
import org.jdownloader.extensions.extraction.gui.ExtractionJobTableModel;
import org.jdownloader.extensions.extraction.translate.T;
import org.jdownloader.gui.translate._GUI;
import org.jdownloader.images.NewTheme;
import org.jdownloader.updatev2.gui.LAFOptions;

public class ExtractorToolTip
extends PanelToolTip {
    private static final long serialVersionUID = 2863662451264465139L;
    private Color color;
    private JLabel empty;
    private ExtractionJobTable table;
    private ExtractionExtension extractionExtension;
    private ExtractionJobTableModel model;

    public ExtractorToolTip(ExtractionExtension extractionExtension) {
        super(new TooltipPanel("ins 0,wrap 1", "[grow,fill]", "[grow,fill]"));
        this.extractionExtension = extractionExtension;
        this.color = LAFOptions.getInstance().getColorForTooltipForeground();
        this.empty = new JLabel(T.T.tooltip_empty());
        this.empty.setForeground(this.color);
        JLabel label = new JLabel(_GUI.T.ExtractorToolTip_ExtractorToolTip_title(), NewTheme.I().getIcon("extract", 20), 2);
        SwingUtils.toBold((JLabel)label);
        label.setForeground(LAFOptions.getInstance().getColorForTooltipForeground());
        this.panel.add((Component)label, (Object)"");
        this.panel.add((Component)this.empty, (Object)"hidemode 3,gapleft 23");
        this.model = new ExtractionJobTableModel();
        this.table = new ExtractionJobTable(this.model);
        this.table.setForeground(LAFOptions.getInstance().getColorForTooltipForeground());
        this.model.addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                ExtractorToolTip.this.table.getTableHeader().repaint();
            }
        });
        this.table.getTableHeader().setOpaque(false);
        this.panel.add((Component)this.table.getTableHeader(), (Object)"hidemode 3");
        this.panel.add((Component)((Object)this.table), (Object)"hidemode 3");
    }

    public void update() {
        if (this.extractionExtension.getJobQueue().getJobs().size() > 0) {
            this.model.clear();
            ExtractionController[] list = this.extractionExtension.getJobQueue().getJobs().toArray(new ExtractionController[0]);
            this.model.addAllElements((Object[])list);
            int width = 0;
            FontMetrics fm = this.getFontMetrics(new Font("Arial", 0, 12));
            for (ExtractionController ec : list) {
                String n = ec.getArchive().getName();
                width = Math.max(width, fm.stringWidth(n));
            }
            this.table.setPreferredSize(new Dimension(width + 110 + 150, list.length * 22));
            this.table.setVisible(true);
            this.table.getTableHeader().setVisible(true);
            this.empty.setVisible(false);
            this.panel.repaint();
        } else {
            this.table.setVisible(false);
            this.empty.setVisible(true);
            this.table.getTableHeader().setVisible(false);
        }
    }
}

