/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.extensions.extraction.split;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.regex.Pattern;
import org.appwork.utils.Hash;
import org.appwork.utils.Regex;
import org.jdownloader.controlling.filter.CompiledFiletypeFilter;
import org.jdownloader.extensions.extraction.Archive;
import org.jdownloader.extensions.extraction.ArchiveFactory;
import org.jdownloader.extensions.extraction.ArchiveFile;
import org.jdownloader.extensions.extraction.FileSignatures;
import org.jdownloader.extensions.extraction.MissingArchiveFile;
import org.jdownloader.extensions.extraction.Signature;
import org.jdownloader.extensions.extraction.multi.ArchiveException;
import org.jdownloader.extensions.extraction.split.HachaSplit;
import org.jdownloader.logging.LogController;

public enum SplitType {
    XTREMSPLIT{
        private final Pattern pattern = Pattern.compile("(?i)(.*)\\.(\\d{1,3})\\.xtm$");

        @Override
        public boolean matches(String filePathOrName) {
            return filePathOrName != null && this.pattern.matcher(filePathOrName).matches();
        }

        @Override
        protected String buildIDPattern(String[] matches) {
            return "\\.\\d{" + matches[1].length() + "}\\.(?i)xtm";
        }

        @Override
        public Pattern buildArchivePattern(String[] matches) {
            String pattern = "^" + this.escapeRegex(matches[0]) + this.buildIDPattern(matches) + "$";
            return Pattern.compile(pattern);
        }

        @Override
        public String[] getMatches(String filePathOrName) {
            return filePathOrName != null ? new Regex(filePathOrName, this.pattern).getRow(0) : null;
        }

        @Override
        public String getPartNumberString(String filePathOrName) {
            String[] matches = this.getMatches(filePathOrName);
            return matches != null ? matches[1] : null;
        }

        @Override
        public int getPartNumber(String partNumberString) {
            return Integer.parseInt(partNumberString);
        }

        @Override
        protected int getFirstPartIndex() {
            return 1;
        }

        @Override
        protected int getMinimumNeededPartIndex() {
            return 2;
        }

        @Override
        protected String buildMissingPart(String[] matches, int partIndex, int partStringLength) {
            return matches[0] + "." + String.format(Locale.US, "%0" + partStringLength + "d", partIndex) + ".xtm";
        }

        @Override
        public String getIconExtension() {
            return "xtm";
        }
    }
    ,
    UNIX_SPLIT{
        private final Pattern pattern = Pattern.compile("(?i)(.*)\\.((?-i)[a-z]{2,4})$");

        private int parseIndex(String index) {
            int length = index.length();
            int ret = 0;
            for (int i = 0; i < length; ++i) {
                int x = index.charAt(i) - 97;
                ret = (int)((double)ret + (double)x * Math.pow(26.0, length - 1 - i));
            }
            return ret;
        }

        private String createIndex(int value, int suffixLength) {
            char[] ret = new char[suffixLength];
            for (int index = 0; index < suffixLength; ++index) {
                int pos = (int)Math.pow(26.0, suffixLength - 1 - index);
                int remaining = value / pos;
                value %= pos;
                ret[index] = (char)(97 + remaining);
            }
            return new String(ret);
        }

        @Override
        public boolean matches(String filePathOrName) {
            return filePathOrName != null && this.pattern.matcher(filePathOrName).matches();
        }

        @Override
        protected String buildIDPattern(String[] matches) {
            return "\\.(?-i)[a-z]{2,4}";
        }

        @Override
        public Pattern buildArchivePattern(String[] matches) {
            String pattern = "^" + this.escapeRegex(matches[0]) + this.buildIDPattern(matches) + "$";
            return Pattern.compile(pattern);
        }

        @Override
        public String[] getMatches(String filePathOrName) {
            return filePathOrName != null ? new Regex(filePathOrName, this.pattern).getRow(0) : null;
        }

        @Override
        public String getPartNumberString(String filePathOrName) {
            String[] matches = this.getMatches(filePathOrName);
            return matches != null ? matches[1] : null;
        }

        @Override
        public int getPartNumber(String partNumberString) {
            return this.parseIndex(partNumberString);
        }

        @Override
        protected int getFirstPartIndex() {
            return 0;
        }

        @Override
        protected int getMinimumNeededPartIndex() {
            return 1;
        }

        @Override
        protected String buildMissingPart(String[] matches, int partIndex, int partStringLength) {
            return matches[0] + "." + this.createIndex(partIndex, partStringLength);
        }

        @Override
        protected boolean isValidPart(int partIndex, ArchiveFile archiveFile) {
            if (archiveFile == null) {
                return false;
            }
            CompiledFiletypeFilter.ExtensionsFilterInterface extension = archiveFile.getLinkInfo().getExtension().getSource();
            return partIndex != -1 || !(extension instanceof CompiledFiletypeFilter.CompiledFiletypeExtension) || extension instanceof CompiledFiletypeFilter.ArchiveExtensions;
        }

        @Override
        protected boolean looksLikeAnArchive(BitSet bitset, ArchiveFile[] archiveFiles) {
            int count = 0;
            HashSet<Integer> exclude = new HashSet<Integer>();
            for (ArchiveFile archiveFile : archiveFiles) {
                if (archiveFile == null || this.isValidPart(-1, archiveFile)) continue;
                String extension = archiveFile.getLinkInfo().getExtension().name();
                exclude.add(this.parseIndex(extension));
            }
            for (int index = 0; index < bitset.length(); ++index) {
                if (exclude.contains(index)) continue;
                if (bitset.get(index)) {
                    if (++count != 2) continue;
                    return true;
                }
                count = 0;
            }
            return false;
        }

        @Override
        public String getIconExtension() {
            return "aa";
        }
    }
    ,
    HJ_SPLIT{
        private final Pattern pattern = Pattern.compile("(?i)(.*)\\.([0-9]{3})$");

        @Override
        public boolean matches(String filePathOrName) {
            return filePathOrName != null && this.pattern.matcher(filePathOrName).matches();
        }

        @Override
        protected String buildIDPattern(String[] matches) {
            return "\\.[0-9]{3}";
        }

        @Override
        public Pattern buildArchivePattern(String[] matches) {
            String pattern = "^" + this.escapeRegex(matches[0]) + this.buildIDPattern(matches) + "$";
            return Pattern.compile(pattern);
        }

        @Override
        public String[] getMatches(String filePathOrName) {
            return filePathOrName != null ? new Regex(filePathOrName, this.pattern).getRow(0) : null;
        }

        @Override
        public String getPartNumberString(String filePathOrName) {
            String[] matches = this.getMatches(filePathOrName);
            return matches != null ? matches[1] : null;
        }

        @Override
        public int getPartNumber(String partNumberString) {
            return Integer.parseInt(partNumberString);
        }

        @Override
        protected int getFirstPartIndex() {
            return 1;
        }

        @Override
        protected int getMinimumNeededPartIndex() {
            return 2;
        }

        @Override
        protected String buildMissingPart(String[] matches, int partIndex, int partStringLength) {
            return matches[0] + "." + String.format(Locale.US, "%0" + partStringLength + "d", partIndex);
        }

        @Override
        protected boolean looksLikeAnArchive(BitSet bitset, ArchiveFile[] archiveFiles) {
            int below10Count = 0;
            int below100Count = 0;
            int below1000Count = 0;
            for (int index = 0; index < bitset.length(); ++index) {
                if (bitset.get(index)) {
                    if (index < 10) {
                        ++below10Count;
                    }
                    if (index < 100) {
                        ++below100Count;
                    }
                    if (index >= 1000) continue;
                    ++below1000Count;
                    continue;
                }
                if (index < 10 && below10Count <= 2) {
                    below10Count = 0;
                }
                if (index < 100 && below100Count <= 2) {
                    below100Count = 0;
                }
                if (index >= 1000 || below1000Count > 2) continue;
                below1000Count = 0;
            }
            if (bitset.length() < 10) {
                return below10Count >= 2;
            }
            if (bitset.length() < 100) {
                return below10Count >= 2 && below100Count >= 2;
            }
            return below10Count >= 2 && below100Count >= 2 && below1000Count >= 2;
        }

        @Override
        protected boolean isValidPart(int partIndex, ArchiveFile archiveFile) {
            if (archiveFile == null) {
                return false;
            }
            if (archiveFile.exists()) {
                String signatureString;
                try {
                    signatureString = FileSignatures.readFileSignature(new File(archiveFile.getFilePath()));
                }
                catch (IOException e) {
                    LogController.CL().log((Throwable)e);
                    return false;
                }
                Signature signature = new FileSignatures().getSignature(signatureString);
                if (partIndex == 1) {
                    if (signature != null) {
                        if ("7Z".equalsIgnoreCase(signature.getId())) {
                            return false;
                        }
                        if ("ZIP".equalsIgnoreCase(signature.getId())) {
                            return false;
                        }
                    }
                } else if (signature != null && "RAR".equalsIgnoreCase(signature.getId())) {
                    return false;
                }
            }
            return true;
        }

        @Override
        public String getIconExtension() {
            return "001";
        }
    }
    ,
    HACHA_SPLIT{
        private final Pattern pattern = Pattern.compile("(?i)(.*)\\.(\\d|[1-9][0-9]{1,2})$");

        @Override
        public boolean matches(String filePathOrName) {
            return filePathOrName != null && this.pattern.matcher(filePathOrName).matches();
        }

        @Override
        protected String buildIDPattern(String[] matches) {
            return "\\.(\\d|[1-9][0-9]{1,2})";
        }

        @Override
        public Pattern buildArchivePattern(String[] matches) {
            String pattern = "^" + this.escapeRegex(matches[0]) + this.buildIDPattern(matches) + "$";
            return Pattern.compile(pattern);
        }

        @Override
        public String[] getMatches(String filePathOrName) {
            return filePathOrName != null ? new Regex(filePathOrName, this.pattern).getRow(0) : null;
        }

        @Override
        public String getPartNumberString(String filePathOrName) {
            String[] matches = this.getMatches(filePathOrName);
            return matches != null ? matches[1] : null;
        }

        @Override
        public int getPartNumber(String partNumberString) {
            if (partNumberString.startsWith("0") && partNumberString.length() > 1) {
                return -1;
            }
            return Integer.parseInt(partNumberString);
        }

        @Override
        protected int getFirstPartIndex() {
            return 0;
        }

        @Override
        protected int getMinimumNeededPartIndex() {
            return 1;
        }

        @Override
        protected String buildMissingPart(String[] matches, int partIndex, int partStringLength) {
            return matches[0] + "." + partIndex;
        }

        @Override
        protected boolean looksLikeAnArchive(BitSet bitset, ArchiveFile[] archiveFiles) {
            int below10Count = 0;
            int below100Count = 0;
            int below1000Count = 0;
            for (int index = 0; index < bitset.length(); ++index) {
                if (bitset.get(index)) {
                    if (index < 10) {
                        ++below10Count;
                    }
                    if (index < 100) {
                        ++below100Count;
                    }
                    if (index >= 1000) continue;
                    ++below1000Count;
                    continue;
                }
                if (index < 10 && below10Count <= 2) {
                    below10Count = 0;
                }
                if (index < 100 && below100Count <= 2) {
                    below100Count = 0;
                }
                if (index >= 1000 || below1000Count > 2) continue;
                below1000Count = 0;
            }
            if (bitset.length() < 10) {
                return below10Count >= 2;
            }
            if (bitset.length() < 100) {
                return below10Count >= 2 && below100Count >= 2;
            }
            return below10Count >= 2 && below100Count >= 2 && below1000Count >= 2;
        }

        @Override
        protected boolean isValidPart(int partIndex, ArchiveFile archiveFile) {
            if (archiveFile == null) {
                return false;
            }
            if (partIndex == 0 && archiveFile.exists()) {
                try {
                    return HachaSplit.parseHachaHeader(archiveFile) != null;
                }
                catch (Exception e) {
                    LogController.CL().log((Throwable)e);
                    return false;
                }
            }
            return true;
        }

        @Override
        public String getIconExtension() {
            return "001";
        }
    };


    protected String escapeRegex(String input) {
        if (input.length() == 0) {
            return "";
        }
        return Regex.escape((String)input);
    }

    public abstract boolean matches(String var1);

    public abstract String[] getMatches(String var1);

    public abstract Pattern buildArchivePattern(String[] var1);

    protected abstract String buildIDPattern(String[] var1);

    public abstract String getPartNumberString(String var1);

    public abstract int getPartNumber(String var1);

    protected abstract int getFirstPartIndex();

    protected abstract int getMinimumNeededPartIndex();

    protected abstract String buildMissingPart(String[] var1, int var2, int var3);

    protected boolean looksLikeAnArchive(BitSet bitset, ArchiveFile[] archiveFiles) {
        return bitset.size() != 0;
    }

    public abstract String getIconExtension();

    protected boolean isValidPart(int partIndex, ArchiveFile archiveFile) {
        return archiveFile != null;
    }

    public ArchiveFile getBestArchiveFileMatch(Archive archive, String fileName) {
        SplitType splitType = archive.getSplitType();
        if (splitType == this) {
            String partNumberString = splitType.getPartNumberString(fileName);
            int partNumber = splitType.getPartNumber(partNumberString);
            for (ArchiveFile archiveFile : archive.getArchiveFiles()) {
                if (partNumber != splitType.getPartNumber(splitType.getPartNumberString(archiveFile.getName()))) continue;
                return archiveFile;
            }
        }
        return null;
    }

    public static ArchiveFile getLastArchiveFile(Archive archive) {
        SplitType type = archive.getSplitType();
        if (type != null) {
            int index = -1;
            ArchiveFile ret = null;
            for (ArchiveFile archiveFile : archive.getArchiveFiles()) {
                int partNum = type.getPartNumber(type.getPartNumberString(archiveFile.getFilePath()));
                if (index != -1 && partNum <= index) continue;
                index = partNum;
                ret = archiveFile;
            }
            return ret;
        }
        return null;
    }

    public static List<ArchiveFile> getMissingArchiveFiles(Archive archive, SplitType splitType, int numberOfParts) {
        String linkPath;
        String[] filePathParts;
        ArchiveFile firstArchiveFile;
        ArchiveFile archiveFile = firstArchiveFile = archive.getArchiveFiles().size() > 0 ? archive.getArchiveFiles().get(0) : null;
        if (firstArchiveFile != null && (filePathParts = splitType.getMatches(linkPath = firstArchiveFile.getFilePath())) != null) {
            BitSet availableParts = new BitSet();
            int partStringLength = 1;
            for (ArchiveFile archiveFile2 : archive.getArchiveFiles()) {
                String fileName = archiveFile2.getName();
                String partNumberString = splitType.getPartNumberString(fileName);
                int partNumber = splitType.getPartNumber(partNumberString);
                if (partNumberString != null) {
                    partStringLength = Math.max(partStringLength, partNumberString.length());
                }
                if (partNumber < 0) continue;
                availableParts.set(partNumber);
            }
            ArrayList<ArchiveFile> ret = new ArrayList<ArchiveFile>();
            int minimumParts = Math.max(splitType.getMinimumNeededPartIndex(), numberOfParts) - (1 - splitType.getFirstPartIndex());
            for (int partIndex = splitType.getFirstPartIndex(); partIndex <= minimumParts; ++partIndex) {
                if (availableParts.get(partIndex)) continue;
                File missingFile = new File(splitType.buildMissingPart(filePathParts, partIndex, partStringLength));
                ret.add(new MissingArchiveFile(missingFile.getName(), missingFile.getAbsolutePath()));
            }
            return ret;
        }
        return null;
    }

    public static Archive createArchive(ArchiveFactory link, SplitType splitType, boolean allowDeepInspection) throws ArchiveException {
        String linkPath = link.getFilePath();
        String[] filePathParts = splitType.getMatches(linkPath);
        if (filePathParts != null && splitType.isValidPart(-1, link)) {
            Pattern pattern = splitType.buildArchivePattern(filePathParts);
            List<ArchiveFile> foundArchiveFiles = link.createPartFileList(linkPath, pattern.pattern());
            if (foundArchiveFiles == null || foundArchiveFiles.size() == 0) {
                throw new ArchiveException("Broken archive support!SplitType:" + splitType.name() + "|ArchiveFactory:" + link.getClass().getName() + "|Exists:" + link.exists(allowDeepInspection) + "|Path:" + linkPath + "|Pattern:" + pattern.pattern() + "|DeepInspection:" + allowDeepInspection);
            }
            BitSet availableParts = new BitSet();
            int lowestPartNumber = Integer.MAX_VALUE;
            int partStringLength = 1;
            int highestPartNumber = Integer.MIN_VALUE;
            int archiveFilesGrow = 128;
            ArchiveFile[] archiveFiles = new ArchiveFile[128];
            for (ArchiveFile archiveFile : foundArchiveFiles) {
                String fileName = archiveFile.getName();
                String partNumberString = splitType.getPartNumberString(fileName);
                int partNumber = splitType.getPartNumber(partNumberString);
                if (partNumber < 0) continue;
                if (partNumberString != null) {
                    partStringLength = Math.max(partStringLength, partNumberString.length());
                }
                availableParts.set(partNumber);
                if (partNumber >= archiveFiles.length) {
                    archiveFiles = Arrays.copyOf(archiveFiles, Math.max(archiveFiles.length + 128, partNumber + 1));
                }
                archiveFiles[partNumber] = archiveFile;
                if (partNumber < lowestPartNumber) {
                    lowestPartNumber = partNumber;
                }
                if (partNumber <= highestPartNumber) continue;
                highestPartNumber = partNumber;
            }
            if (splitType.looksLikeAnArchive(availableParts, archiveFiles)) {
                String[] fileNameParts = splitType.getMatches(link.getName());
                Archive archive = link.createArchive(splitType);
                archive.setName(fileNameParts[0]);
                String rawID = splitType.name() + "|" + fileNameParts[0] + splitType.buildIDPattern(fileNameParts);
                String ID2 = Hash.getSHA256((String)rawID);
                String archiveID = Archive.getBestArchiveID(foundArchiveFiles, ID2);
                archive.setArchiveID(archiveID);
                ArrayList<ArchiveFile> sortedArchiveFiles = new ArrayList<ArchiveFile>();
                int minimumParts = Math.max(splitType.getMinimumNeededPartIndex(), highestPartNumber);
                for (int partIndex = splitType.getFirstPartIndex(); partIndex <= minimumParts; ++partIndex) {
                    if (!availableParts.get(partIndex)) {
                        File missingFile = new File(splitType.buildMissingPart(filePathParts, partIndex, partStringLength));
                        sortedArchiveFiles.add(new MissingArchiveFile(missingFile.getName(), missingFile.getAbsolutePath()));
                        continue;
                    }
                    if (allowDeepInspection && !splitType.isValidPart(partIndex, archiveFiles[partIndex])) {
                        return null;
                    }
                    sortedArchiveFiles.add(archiveFiles[partIndex]);
                }
                archive.setArchiveFiles(sortedArchiveFiles);
                return archive;
            }
        }
        return null;
    }
}

