/*
 * Decompiled with CFR 0.152.
 */
package jd.captcha;

import com.jhlabs.image.PosterizeFilter;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.util.ArrayList;
import jd.captcha.JAntiCaptcha;
import jd.captcha.LetterComperator;
import jd.captcha.pixelgrid.Captcha;
import jd.captcha.pixelgrid.Letter;
import jd.captcha.pixelgrid.PixelGrid;
import jd.captcha.pixelobject.PixelObject;
import jd.nutils.Colors;

public class ColorLetterComperator {
    private Letter a;
    private Letter b;
    private PixelObject[] aLayers;
    private PixelObject[] bLayers;
    private Captcha ca;
    private Captcha cb;
    private JAntiCaptcha owner;
    public int lettersPerfect = 2;
    public int lettersPerfectPercent = 20;
    public int maxColorDifference = 30;
    protected double valityPercent = 10000.0;
    public int colorLevels = 2;

    public ColorLetterComperator(Letter a, Letter b) {
        this.a = a;
        this.b = b;
        if (a.owner != null) {
            this.owner = a.owner;
        } else if (b.owner != null) {
            this.owner = b.owner;
        }
    }

    public void setLetterA(Letter a) {
        this.a = a;
        this.ca = null;
        this.aLayers = null;
    }

    public void setLetterB(Letter b) {
        this.b = b;
        this.cb = null;
        this.bLayers = null;
    }

    private Letter getSWLetter(PixelObject obj) {
        int[][] lgrid = new int[obj.getWidth()][obj.getHeight()];
        for (int x = 0; x < obj.getWidth(); ++x) {
            for (int y = 0; y < obj.getHeight(); ++y) {
                lgrid[x][y] = 0xFFFFFF;
            }
        }
        int w = 0;
        for (int d = 0; d < obj.getSize(); ++d) {
            ++w;
            int[] akt = obj.elementAt(d);
            lgrid[akt[0] - obj.getXMin()][akt[1] - obj.getYMin()] = 0;
        }
        if (obj.getArea() / 2 < w) {
            for (int x = 0; x < obj.getWidth(); ++x) {
                for (int y = 0; y < obj.getHeight(); ++y) {
                    lgrid[x][y] = lgrid[x][y] == 0xFFFFFF ? 0 : 0xFFFFFF;
                }
            }
        }
        Letter ret = obj.owner.createLetter();
        ret.setElementPixel(obj.getSize());
        ret.setLocation(new int[]{obj.getXMin(), obj.getYMin()});
        ret.setGrid(lgrid);
        ret.detected = obj.detected;
        return ret;
    }

    public double run() throws InterruptedException {
        int bArea;
        if (this.aLayers != null && this.bLayers != null) {
            return this.valityPercent;
        }
        int aArea = this.a.getArea();
        if (aArea / 5 > (bArea = this.b.getArea()) || bArea / 5 > aArea) {
            this.valityPercent = 10000.0;
            return this.valityPercent;
        }
        if (this.ca == null) {
            this.ca = this.reduceColors(this.a);
        }
        if (this.cb == null) {
            this.cb = this.reduceColors(this.b);
        }
        if (this.aLayers == null) {
            this.aLayers = ColorLetterComperator.getObjects(this.ca);
        }
        if (this.bLayers == null) {
            this.bLayers = ColorLetterComperator.getObjects(this.cb);
        }
        double ret = 0.0;
        int minl = Math.min(this.aLayers.length, this.bLayers.length);
        int perf = 0;
        int maxl = Math.max(this.aLayers.length, this.bLayers.length);
        boolean minla = this.aLayers.length == minl;
        PixelObject[][] bestarray = new PixelObject[minl][2];
        for (int i = 0; i < minl; ++i) {
            double best = Double.MAX_VALUE;
            PixelObject[] bestobj = null;
            for (int j = maxl - i - 1; j >= 0; --j) {
                double value = 0.0;
                int a = j;
                int b = i;
                if (minla) {
                    a = i;
                    b = j;
                }
                if ((value = Colors.getColorDifference((int)this.aLayers[a].getAverage(), (int)this.bLayers[b].getAverage())) == 0.0) {
                    bestobj = new PixelObject[]{this.aLayers[a], this.bLayers[b]};
                    break;
                }
                if (!(value < best)) continue;
                best = value;
                bestobj = new PixelObject[]{this.aLayers[a], this.bLayers[b]};
            }
            bestarray[i] = bestobj;
        }
        int bestarrayLength = bestarray.length;
        for (int i = 0; i < bestarrayLength; ++i) {
            if (Colors.getColorDifference((int)bestarray[i][0].getAverage(), (int)bestarray[i][1].getAverage()) > (double)this.maxColorDifference) {
                ret += 100.0;
                continue;
            }
            try {
                Letter leta = this.getSWLetter(bestarray[i][0]);
                LetterComperator lc = new LetterComperator(leta, this.getSWLetter(bestarray[i][1]));
                lc.setOwner(this.getJac());
                bestarray[i][0].detected = lc;
                lc.run();
                double vall = lc.getValityPercent();
                if (vall < (double)this.lettersPerfectPercent) {
                    this.valityPercent = 0.0;
                    if (++perf == this.lettersPerfect) {
                        return 0.0;
                    }
                }
                ret += lc.getValityPercent();
                continue;
            }
            catch (Exception e) {
                ret += ret / (double)i;
            }
        }
        this.valityPercent = (ret += (double)((maxl - minl) * 100)) / (double)maxl;
        return this.valityPercent;
    }

    private JAntiCaptcha getJac() {
        if (this.owner == null) {
            String hoster = "EasyCaptcha";
            this.owner = new JAntiCaptcha("EasyCaptcha");
        }
        return this.owner;
    }

    public static PixelObject[] getObjects(PixelGrid grid) {
        ArrayList<PixelObject> ret = new ArrayList<PixelObject>();
        int gridWidth = grid.getWidth();
        int gridHeight = grid.getHeight();
        int[][] gridGrid = grid.getGrid();
        for (int x = 0; x < gridWidth; ++x) {
            for (int y = 0; y < gridHeight; ++y) {
                PixelObject n = new PixelObject(grid);
                int color = gridGrid[x][y];
                n.add(x, y, color);
                ArrayList<PixelObject> merge = new ArrayList<PixelObject>();
                for (PixelObject o : ret) {
                    if (color != o.getAverage()) continue;
                    merge.add(o);
                }
                int mergeSize = merge.size();
                if (mergeSize == 0) {
                    ret.add(n);
                    continue;
                }
                if (mergeSize == 1) {
                    ((PixelObject)merge.get(0)).add(n);
                    continue;
                }
                for (PixelObject po : merge) {
                    ret.remove(po);
                    n.add(po);
                }
                ret.add(n);
            }
        }
        return ret.toArray(new PixelObject[0]);
    }

    private Captcha reduceColors(Letter letter) throws InterruptedException {
        PosterizeFilter qf = new PosterizeFilter();
        BufferedImage image = letter.getImage();
        BufferedImage dest = qf.createCompatibleDestImage(image, ColorModel.getRGBdefault());
        qf.setNumLevels(this.colorLevels);
        qf.filter(image, dest);
        return this.getJac().createCaptcha(dest);
    }
}

