/*
 * Decompiled with CFR 0.152.
 */
package jd.captcha.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Image;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import jd.captcha.gui.BasicWindow;
import jd.captcha.gui.ImageComponent;

public class ScrollPaneWindow
extends BasicWindow {
    private static final long serialVersionUID = 4174011156785741071L;
    private JPanel panel;

    public ScrollPaneWindow() {
        this.setAlwaysOnTop(true);
        this.panel = new JPanel();
        this.panel.setLayout(new GridBagLayout());
        this.setLayout(new BorderLayout());
        this.add(new JScrollPane(this.panel), "Center");
        this.setSize(200, 200);
        this.setLocation(0, 0);
        this.setTitle("new ScrollPaneWindow");
        this.refreshUI();
        this.setVisible(true);
    }

    public void setComponent(final int x, final int y, final Component cmp) {
        if (cmp == null) {
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ScrollPaneWindow.this.panel.add(cmp, ScrollPaneWindow.this.getGBC(x, y, 1, 1));
            }
        });
    }

    public void setImage(int x, int y, Image img) {
        if (img == null) {
            return;
        }
        this.setComponent(x, y, new ImageComponent(img));
    }

    public void setText(int x, int y, Object cmp) {
        if (cmp == null) {
            return;
        }
        this.setComponent(x, y, new JTextField(cmp.toString()));
    }
}

