/*
 * Decompiled with CFR 0.152.
 */
package jd.captcha.pixelgrid;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import jd.captcha.pixelgrid.BinLetter;
import jd.captcha.pixelgrid.Letter;
import jd.captcha.pixelgrid.LevenshteinLetter;

public class BinLetters {
    FileInputStream in;
    File file;

    public static boolean[] fromByte(byte b) {
        boolean[] bits = new boolean[8];
        for (int i = 0; i < 8; ++i) {
            bits[i] = (b & 1) == 1;
            b = (byte)(b >> 1);
        }
        return bits;
    }

    public BinLetters(File file) {
        this.file = file;
    }

    public BinLetters getNewInstance() {
        return new BinLetters(this.file);
    }

    public BinLetters open() throws FileNotFoundException {
        try {
            this.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.in = new FileInputStream(this.file);
        return this;
    }

    public LevenshteinLetter getLetter(int i) throws IOException {
        this.open();
        for (int j = 0; j < i; ++j) {
            this.in.skip(this.readNextBinHeader().bytes);
        }
        LevenshteinLetter n = this.readNext();
        this.in.close();
        return n;
    }

    private int getInt() throws IOException {
        byte[] bytes = new byte[4];
        this.in.read(bytes);
        return BinLetters.byte2int(bytes);
    }

    private static byte[] int2byte(int number) {
        byte[] data = new byte[4];
        for (int i = 0; i < 4; ++i) {
            int shift = i << 3;
            data[3 - i] = (byte)((number & 255 << shift) >>> shift);
        }
        return data;
    }

    private static int byte2int(byte[] data) {
        int number = 0;
        for (int i = 0; i < 4; ++i) {
            number |= (data[3 - i] & 0xFF) << (i << 3);
        }
        return number;
    }

    public List<LevenshteinLetter> readAll() throws IOException {
        this.open();
        ArrayList<LevenshteinLetter> lets = new ArrayList<LevenshteinLetter>();
        while (this.hasNext()) {
            lets.add(this.readNext());
        }
        return lets;
    }

    public boolean hasNext() {
        try {
            return this.in.available() > 7;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public boolean contains(Letter let) throws IOException {
        return this.contains(new LevenshteinLetter(let));
    }

    public boolean contains(LevenshteinLetter let) throws IOException {
        return this.contains(BinLetter.LevenshteinLetter2BinLetter(let));
    }

    public boolean contains(BinLetter let) throws IOException {
        this.open();
        while (this.hasNext()) {
            BinLetter bin = this.readNextBinHeader();
            if (bin.value == let.value && bin.hight == let.hight && bin.width == let.width) {
                this.readBody(bin);
                byte[] letBytesArray = let.bytesArray;
                byte[] binBytesArray = bin.bytesArray;
                int letBytesArrayLength = letBytesArray.length;
                for (int i = 0; i < letBytesArrayLength; ++i) {
                    if (letBytesArray[i] == binBytesArray[i]) continue;
                }
                return true;
            }
            this.in.skip(bin.bytes);
        }
        return false;
    }

    public boolean containsNoValue(BinLetter let) throws IOException {
        this.open();
        while (this.hasNext()) {
            BinLetter bin = this.readNextBinHeader();
            if (bin.hight == let.hight && bin.width == let.width) {
                this.readBody(bin);
                byte[] letBytesArray = let.bytesArray;
                byte[] binBytesArray = bin.bytesArray;
                int letBytesArrayLength = letBytesArray.length;
                for (int i = 0; i < letBytesArrayLength; ++i) {
                    if (letBytesArray[i] == binBytesArray[i]) continue;
                }
                return true;
            }
            this.in.skip(bin.bytes);
        }
        return false;
    }

    public BinLetter readNextBinHeader() throws IOException {
        BinLetter ret = new BinLetter();
        ret.width = this.getInt();
        ret.hight = this.getInt();
        ret.bytes = this.getInt();
        ret.value = (char)this.in.read();
        return ret;
    }

    public void readBody(BinLetter let) throws IOException {
        let.bytesArray = new byte[let.bytes];
        this.in.read(let.bytesArray);
    }

    public LevenshteinLetter readNext() throws IOException {
        BinLetter bin = this.readNextBinHeader();
        this.readBody(bin);
        int binWidth = bin.width;
        int binHight = bin.hight;
        boolean[][] ret = new boolean[binWidth][binHight];
        int xd = 0;
        int yd = 0;
        int area = binWidth * binHight;
        int cre = 0;
        block0: for (int i = 0; i < bin.bytesArray.length; ++i) {
            for (int j = 0; j < 8; ++j) {
                ret[xd][yd] = (bin.bytesArray[i] & 1) == 1;
                int n = i;
                bin.bytesArray[n] = (byte)(bin.bytesArray[n] >> 1);
                if (++xd / binWidth > 0) {
                    ++yd;
                    xd = 0;
                }
                if (++cre >= area) continue block0;
            }
        }
        LevenshteinLetter lev = new LevenshteinLetter(ret, bin.value);
        return lev;
    }

    public void close() throws IOException {
        this.in.close();
    }

    public static void write(Letter b, File file, boolean append) throws IOException {
        BinLetters.write(new LevenshteinLetter(b), file, append);
    }

    public static void write(LevenshteinLetter levenshteinLetter, File file, boolean append) throws IOException {
        BinLetters.write(BinLetter.LevenshteinLetter2BinLetter(levenshteinLetter), file, append);
    }

    public static void write(BinLetter b, File file, boolean append) throws IOException {
        FileOutputStream f = new FileOutputStream(file, append);
        f.write(BinLetters.int2byte(b.width));
        f.write(BinLetters.int2byte(b.hight));
        f.write(BinLetters.int2byte(b.bytes));
        f.write(b.value);
        f.write(b.bytesArray);
        f.close();
    }
}

