/*
 * Decompiled with CFR 0.152.
 */
package jd.captcha.specials;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.Vector;
import jd.captcha.ColorLetterComperator;
import jd.captcha.JAntiCaptcha;
import jd.captcha.LetterComperator;
import jd.captcha.easy.BackGroundImageManager;
import jd.captcha.pixelgrid.Captcha;
import jd.captcha.pixelgrid.Letter;
import jd.captcha.pixelgrid.PixelGrid;
import jd.captcha.pixelobject.PixelObject;
import org.appwork.utils.ImageProvider.ImageProvider;

public class ProtectItOrg {
    static List<PixelObject> getObjects(PixelGrid grid, int neighbourradius) {
        ArrayList<PixelObject> ret = new ArrayList<PixelObject>();
        for (int x = 0; x < grid.getWidth(); ++x) {
            for (int y = 0; y < grid.getHeight(); ++y) {
                if (grid.getGrid()[x][y] == -3151923) continue;
                PixelObject n = new PixelObject(grid);
                n.add(x, y, grid.getGrid()[x][y]);
                ArrayList<PixelObject> merge = new ArrayList<PixelObject>();
                for (PixelObject o : ret) {
                    if (!o.isTouching(x, y, true, neighbourradius, neighbourradius)) continue;
                    merge.add(o);
                }
                if (merge.size() == 0) {
                    ret.add(n);
                    continue;
                }
                if (merge.size() == 1) {
                    ((PixelObject)merge.get(0)).add(n);
                    continue;
                }
                for (PixelObject po : merge) {
                    ret.remove(po);
                    n.add(po);
                }
                ret.add(n);
            }
        }
        return ret;
    }

    public static Letter[] getLetters(Captcha captcha) throws Exception {
        captcha.crop(257, 140, 0, 0);
        ArrayList<Letter> let = new ArrayList<Letter>();
        Vector<PixelObject> objs = captcha.getObjects(0.7, 0.7);
        Collections.sort(objs);
        for (PixelObject pixelObject : objs) {
            if (pixelObject.getArea() <= 3) continue;
            let.add(pixelObject.toLetter());
        }
        int c = 0;
        ListIterator iterator = let.listIterator(let.size());
        while (iterator.hasPrevious() && c++ < 10) {
            iterator.previous();
            iterator.remove();
        }
        Letter[] lets = let.toArray(new Letter[0]);
        String code = "";
        for (Letter letter : lets) {
            LetterComperator r = captcha.owner.getLetter(letter);
            code = code + r.getDecodedValue();
            letter.detected = r;
        }
        File imageFile = captcha.owner.getResourceFile("images/" + code + ".png");
        if (imageFile.exists()) {
            captcha.reset();
            Captcha pixToFind = captcha.owner.createCaptcha(ImageProvider.read((File)imageFile));
            Letter l = captcha.createLetter();
            l.setGrid(pixToFind.grid);
            BackGroundImageManager bgit = new BackGroundImageManager(captcha);
            bgit.clearCaptchaAll();
            captcha.crop(0, 0, 0, 10);
            List<PixelObject> obj = ProtectItOrg.getObjects(captcha, 3);
            ColorLetterComperator mainCLC = new ColorLetterComperator(l, l);
            double bestVal = 1.0E7;
            PixelGrid bestLetter = null;
            for (PixelObject pixelObject : obj) {
                if (pixelObject.getWidth() > 63 || pixelObject.getHeight() > 63) {
                    PixelObject[] objb;
                    for (PixelObject pixelObject2 : objb = pixelObject.splitAt(62)) {
                        if (pixelObject.getHeight() > 63) {
                            PixelObject[] objb2;
                            for (PixelObject pixelObject3 : objb2 = pixelObject2.horizintalSplitAt(62)) {
                                Letter b = pixelObject3.toColoredLetter();
                                mainCLC.setLetterB(b);
                                double val = mainCLC.run();
                                if (!(val < bestVal)) continue;
                                bestLetter = b;
                                bestVal = val;
                            }
                            continue;
                        }
                        Letter b = pixelObject2.toColoredLetter();
                        mainCLC.setLetterB(b);
                        double val = mainCLC.run();
                        if (!(val < bestVal)) continue;
                        bestLetter = b;
                        bestVal = val;
                    }
                    continue;
                }
                Letter b = pixelObject.toColoredLetter();
                mainCLC.setLetterB(b);
                double val = mainCLC.run();
                if (!(val < bestVal)) continue;
                bestLetter = b;
                bestVal = val;
            }
            int x = bestLetter.getLocation()[0] + bestLetter.getWidth() / 2;
            int y = bestLetter.getLocation()[1] + bestLetter.getHeight() / 2;
            char[] tx = (x + ":" + y).toCharArray();
            Letter[] ret = new Letter[tx.length];
            for (int i = 0; i < tx.length; ++i) {
                Letter re = new Letter();
                re.setDecodedValue("" + tx[i]);
                LetterComperator let1 = new LetterComperator(re, re);
                let1.setValityPercent(0.0);
                re.detected = let1;
                ret[i] = re;
            }
            return ret;
        }
        return null;
    }

    public static Letter[] letterFilter(Letter[] org, JAntiCaptcha jac) {
        return org;
    }
}

