/*
 * Decompiled with CFR 0.152.
 */
package jd.captcha.specials;

import jd.captcha.easy.BackGroundImageManager;
import jd.captcha.pixelgrid.Captcha;
import jd.captcha.pixelgrid.Letter;
import jd.captcha.pixelgrid.PixelGrid;
import jd.captcha.specials.EasyCaptcha;
import jd.nutils.Colors;

public class XflsKcm {
    static boolean isRgb(int color) {
        return color == 0xFFFFFF;
    }

    private static int follow(int x, int y, int cx, int cy, Captcha captcha) {
        int ret = 0;
        if (captcha.getHeight() > y && captcha.getWidth() > x && Colors.getColorDifference((int)0xFFFFFF, (int)captcha.grid[x][y]) > 30.0) {
            ++ret;
            if (cx >= 0) {
                ret += XflsKcm.follow(x + 1, y, cx - 1, cy, captcha);
            }
            if (cy >= 0) {
                ret += XflsKcm.follow(x, y + 1, cx, cy - 1, captcha);
            }
        }
        return ret;
    }

    static void clearlines2(Captcha captcha, int val) {
        int[][] grid = PixelGrid.getGridCopy(captcha.grid);
        for (int x = 0; x < captcha.getWidth(); ++x) {
            for (int y = 0; y < captcha.getHeight(); ++y) {
                if (XflsKcm.follow(x, y, 2, 2, captcha) >= val) continue;
                grid[x][y] = 0xFFFFFF;
            }
        }
        captcha.grid = grid;
    }

    static void setDotsInDigits(Captcha captcha) {
        int[][] grid = PixelGrid.getGridCopy(captcha.grid);
        for (int x = 1; x < captcha.getWidth() - 1; ++x) {
            for (int y = 1; y < captcha.getHeight() - 1; ++y) {
                if (!XflsKcm.isRgb(captcha.grid[x][y])) continue;
                int co = captcha.grid[x + 1][y];
                int w = co != 0xFFFFFF && !XflsKcm.isRgb(co) ? 1 : 0;
                co = captcha.grid[x + 1][y + 1];
                w += co != 0xFFFFFF && !XflsKcm.isRgb(co) ? 1 : 0;
                co = captcha.grid[x][y + 1];
                w += co != 0xFFFFFF && !XflsKcm.isRgb(co) ? 1 : 0;
                co = captcha.grid[x - 1][y + 1];
                w += co != 0xFFFFFF && !XflsKcm.isRgb(co) ? 1 : 0;
                co = captcha.grid[x - 1][y - 1];
                w += co != 0xFFFFFF && !XflsKcm.isRgb(co) ? 1 : 0;
                co = captcha.grid[x + 1][y - 1];
                w += co != 0xFFFFFF && !XflsKcm.isRgb(co) ? 1 : 0;
                co = captcha.grid[x - 1][y];
                w += co != 0xFFFFFF && !XflsKcm.isRgb(co) ? 1 : 0;
                co = captcha.grid[x][y - 1];
                if ((w += co != 0xFFFFFF && !XflsKcm.isRgb(co) ? 1 : 0) <= 4) continue;
                grid[x][y] = 0;
            }
        }
        captcha.grid = grid;
    }

    static void toBlack(Captcha captcha) {
        for (int x = 0; x < captcha.getWidth(); ++x) {
            for (int y = 0; y < captcha.getHeight(); ++y) {
                captcha.grid[x][y] = captcha.grid[x][y] != -1 ? 0 : 0xFFFFFF;
            }
        }
    }

    public static Letter[] getLetters(Captcha captcha) throws InterruptedException {
        BackGroundImageManager bgit = new BackGroundImageManager(captcha);
        bgit.clearCaptchaAll();
        XflsKcm.toBlack(captcha);
        XflsKcm.setDotsInDigits(captcha);
        XflsKcm.clearlines2(captcha, 4);
        XflsKcm.clearlines2(captcha, 4);
        captcha.removeSmallObjects(0.5, 0.5, 8);
        Letter[] lets = EasyCaptcha.getLetters(captcha);
        return lets;
    }
}

