/*
 * Decompiled with CFR 0.152.
 */
package jsyntaxpane.actions.gui;

import java.awt.Dialog;
import java.awt.Dimension;
import java.util.Arrays;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.GroupLayout;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import jsyntaxpane.actions.gui.EscapeListener;
import jsyntaxpane.util.SwingUtils;

public class ShowAbbsDialog
extends JDialog
implements EscapeListener {
    private JEditorPane jEdtAbbr;
    private JList jLstAbbs;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JSplitPane jSplitPane1;
    Map<String, String> abbs;

    public ShowAbbsDialog(JEditorPane parent, Map<String, String> abbs) {
        super(SwingUtilities.getWindowAncestor(parent), Dialog.ModalityType.APPLICATION_MODAL);
        this.initComponents();
        Object[] abbsList = abbs.keySet().toArray();
        Arrays.sort(abbsList);
        this.jLstAbbs.setListData(abbsList);
        this.abbs = abbs;
        this.jEdtAbbr.setEditorKit(parent.getEditorKit());
        this.jLstAbbs.setSelectedIndex(0);
        SwingUtils.addEscapeListener(this);
        this.setVisible(true);
    }

    private void initComponents() {
        this.jSplitPane1 = new JSplitPane();
        this.jScrollPane1 = new JScrollPane();
        this.jLstAbbs = new JList();
        this.jScrollPane2 = new JScrollPane();
        this.jEdtAbbr = new JEditorPane();
        this.setDefaultCloseOperation(2);
        ResourceBundle bundle = ResourceBundle.getBundle("jsyntaxpane/Bundle");
        this.setTitle(bundle.getString("ShowAbbsDialog.title"));
        this.setLocationByPlatform(true);
        this.setMinimumSize(new Dimension(600, 300));
        this.setModal(true);
        this.setName("dlgShowAbbs");
        this.jSplitPane1.setDividerLocation(150);
        this.jSplitPane1.setDividerSize(3);
        this.jScrollPane1.setPreferredSize(new Dimension(258, 400));
        this.jLstAbbs.setSelectionMode(0);
        this.jLstAbbs.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                ShowAbbsDialog.this.jLstAbbsValueChanged(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jLstAbbs);
        this.jSplitPane1.setLeftComponent(this.jScrollPane1);
        this.jEdtAbbr.setEditable(false);
        this.jEdtAbbr.setMinimumSize(new Dimension(106, 400));
        this.jScrollPane2.setViewportView(this.jEdtAbbr);
        this.jSplitPane1.setRightComponent(this.jScrollPane2);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jSplitPane1, -1, 580, Short.MAX_VALUE).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jSplitPane1, -2, 337, -2).addContainerGap(-1, Short.MAX_VALUE)));
        this.pack();
    }

    private void jLstAbbsValueChanged(ListSelectionEvent evt) {
        Object selected;
        if (!evt.getValueIsAdjusting() && (selected = this.jLstAbbs.getSelectedValue()) != null) {
            this.jEdtAbbr.setText(this.abbs.get(selected.toString()));
        }
    }

    @Override
    public void escapePressed() {
        this.setVisible(false);
    }
}

