/*
 * Decompiled with CFR 0.152.
 */
package jd.gui.swing.dialog;

import java.awt.Cursor;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import javax.swing.JComponent;
import jd.gui.swing.dialog.AbstractImageCaptchaDialog;
import jd.gui.swing.dialog.DialogType;
import org.appwork.swing.components.ExtTextField;
import org.jdownloader.DomainInfo;
import org.jdownloader.captcha.v2.challenge.multiclickcaptcha.MultiClickCaptchaChallenge;
import org.jdownloader.captcha.v2.challenge.multiclickcaptcha.MultiClickedPoint;
import org.jdownloader.gui.translate._GUI;

public class MultiClickCaptchaDialog
extends AbstractImageCaptchaDialog<MultiClickedPoint> {
    private ArrayList<Point> rp = null;

    public MultiClickCaptchaDialog(MultiClickCaptchaChallenge captchaChallenge, int flag, DialogType type, DomainInfo domainInfo, Image[] images, String explain) {
        super(captchaChallenge, flag | 0x100, _GUI.T.gui_captchaWindow_askForInput(domainInfo.getTld()), type, domainInfo, explain, images);
    }

    @Override
    public JComponent layoutDialogContent() {
        JComponent ret = super.layoutDialogContent();
        this.iconPanel.setCursor(Cursor.getPredefinedCursor(1));
        this.iconPanel.setToolTipText(this.getHelpText());
        this.iconPanel.addMouseListener(new MouseListener(){

            @Override
            public void mouseReleased(MouseEvent e) {
                Point resultPoint = e.getPoint();
                resultPoint.x -= MultiClickCaptchaDialog.this.getOffset().x;
                resultPoint.y -= MultiClickCaptchaDialog.this.getOffset().y;
                resultPoint.x = (int)((double)resultPoint.x * MultiClickCaptchaDialog.this.getScaleFaktor());
                resultPoint.y = (int)((double)resultPoint.y * MultiClickCaptchaDialog.this.getScaleFaktor());
                if (MultiClickCaptchaDialog.this.rp == null) {
                    MultiClickCaptchaDialog.this.rp = new ArrayList();
                }
                MultiClickCaptchaDialog.this.rp.add(resultPoint);
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseClicked(MouseEvent e) {
            }
        });
        return ret;
    }

    @Override
    protected JComponent createInputComponent() {
        ExtTextField ret = new ExtTextField();
        ret.setText(this.getHelpText());
        ret.setEditable(false);
        return ret;
    }

    protected MultiClickedPoint createReturnValue() {
        if (this.rp == null) {
            return null;
        }
        MultiClickedPoint mcp = new MultiClickedPoint();
        int[] x = new int[this.rp.size()];
        int[] y = new int[this.rp.size()];
        int i = 0;
        for (Point p : this.rp) {
            x[i] = p.x;
            y[i] = p.y;
            ++i;
        }
        mcp.setX(x);
        mcp.setY(y);
        return mcp;
    }
}

