/*
 * Decompiled with CFR 0.152.
 */
package jd.gui.swing.jdgui.components;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextArea;
import org.appwork.swing.components.circlebar.CircledProgressBar;
import org.appwork.swing.components.circlebar.IconPainter;
import org.appwork.swing.components.circlebar.ImagePainter;
import org.appwork.swing.components.tooltips.ExtTooltip;
import org.appwork.swing.components.tooltips.PanelToolTip;
import org.appwork.swing.components.tooltips.ToolTipController;
import org.appwork.swing.components.tooltips.ToolTipHandler;
import org.appwork.swing.components.tooltips.TooltipPanel;
import org.appwork.utils.swing.SwingUtils;
import org.jdownloader.updatev2.gui.LAFOptions;

public class IconedProcessIndicator
extends CircledProgressBar
implements MouseListener {
    private static final long serialVersionUID = 1627427388265904122L;
    private boolean active;
    protected ImagePainter activeValuePainter;
    protected ImagePainter activeNonValuePainter;
    protected ImagePainter valuePainter;
    protected ImagePainter nonValuePainter;
    private String title = null;
    private String description = null;

    protected boolean isActive() {
        return this.active;
    }

    public boolean isTooltipWithoutFocusEnabled() {
        return false;
    }

    protected IconedProcessIndicator() {
    }

    public IconedProcessIndicator(Icon icon) {
        this.updatePainter(icon, Color.WHITE, Color.GRAY, Color.WHITE, Color.GREEN, Color.LIGHT_GRAY, Color.GREEN);
        ToolTipController.getInstance().register((ToolTipHandler)this);
        this.setActive(false);
        this.addMouseListener(this);
    }

    public void updatePainter(Icon icon, Color c1, Color c2, Color c3, Color c4, Color c5, Color c6) {
        this.valuePainter = this.getPainer(icon, 1.0f);
        this.valuePainter.setBackground(c1);
        this.valuePainter.setForeground(c2);
        this.nonValuePainter = this.getPainer(icon, 0.5f);
        this.activeValuePainter = this.getPainer(icon, 1.0f);
        this.activeValuePainter.setBackground(c3);
        this.activeValuePainter.setForeground(c4);
        this.activeNonValuePainter = this.getPainer(icon, 0.5f);
        this.activeNonValuePainter.setBackground(c5);
        this.activeNonValuePainter.setForeground(c6);
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
    }

    public ExtTooltip createExtTooltip(Point mousePosition) {
        IconedProcessIndicator comp = new IconedProcessIndicator();
        comp.valuePainter = this.valuePainter;
        comp.nonValuePainter = this.nonValuePainter;
        comp.activeValuePainter = this.activeValuePainter;
        comp.activeNonValuePainter = this.activeNonValuePainter;
        comp.setActive(this.active);
        comp.setEnabled(this.isEnabled());
        comp.setIndeterminate(this.isIndeterminate());
        comp.setPreferredSize(new Dimension(32, 32));
        comp.setValue(this.getValue());
        TooltipPanel panel = new TooltipPanel("ins 0,wrap 2", "[][grow,fill]", "[]0[grow,fill]");
        comp.setOpaque(false);
        JLabel lbl = new JLabel(this.toString());
        lbl.setForeground(LAFOptions.getInstance().getColorForTooltipForeground());
        JTextArea txt = new JTextArea();
        txt.setEditable(false);
        SwingUtils.setOpaque((JComponent)txt, (boolean)false);
        txt.setBorder(null);
        txt.setForeground(LAFOptions.getInstance().getColorForTooltipForeground());
        panel.add((Component)((Object)comp), (Object)"spany 2,aligny top");
        panel.add((Component)SwingUtils.toBold((JLabel)lbl));
        panel.add((Component)txt);
        lbl.setText(this.getTitle());
        txt.setText(this.getDescription());
        return new PanelToolTip(panel);
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setIndeterminate(boolean newValue) {
        super.setIndeterminate(newValue);
        this.setActive(newValue);
    }

    protected void setActive(boolean newValue) {
        this.active = newValue;
        if (this.active) {
            this.setValueClipPainter((IconPainter)this.activeValuePainter);
            this.setNonvalueClipPainter((IconPainter)this.activeNonValuePainter);
        } else {
            this.setValueClipPainter((IconPainter)this.valuePainter);
            this.setNonvalueClipPainter((IconPainter)this.nonValuePainter);
        }
    }

    private ImagePainter getPainer(Icon icon, float f) {
        ImagePainter ret = new ImagePainter(icon, f);
        ret.setBackground(Color.WHITE);
        ret.setForeground(Color.LIGHT_GRAY);
        return ret;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (e.isPopupTrigger() || e.getButton() == 3) {
            ToolTipController.getInstance().hideTooltip();
        } else {
            ToolTipController.getInstance().show((ToolTipHandler)this);
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }
}

