/*
 * Decompiled with CFR 0.152.
 */
package jd.gui.swing.jdgui.components;

import java.awt.Component;
import java.awt.HeadlessException;
import java.awt.LayoutManager;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import jd.SecondLevelLaunch;
import jd.controlling.downloadcontroller.DownloadLinkCandidate;
import jd.controlling.downloadcontroller.DownloadLinkCandidateResult;
import jd.controlling.downloadcontroller.DownloadWatchDog;
import jd.controlling.downloadcontroller.DownloadWatchDogProperty;
import jd.controlling.downloadcontroller.SingleDownloadController;
import jd.controlling.downloadcontroller.event.DownloadWatchdogListener;
import jd.controlling.linkchecker.LinkChecker;
import jd.controlling.linkchecker.LinkCheckerEvent;
import jd.controlling.linkchecker.LinkCheckerListener;
import jd.controlling.linkcollector.LinkCollectingJob;
import jd.controlling.linkcollector.LinkCollector;
import jd.controlling.linkcollector.LinkCollectorCrawler;
import jd.controlling.linkcollector.LinkCollectorEvent;
import jd.controlling.linkcollector.LinkCollectorListener;
import jd.controlling.linkcrawler.CrawledLink;
import jd.controlling.reconnect.Reconnecter;
import jd.controlling.reconnect.ReconnecterEvent;
import jd.controlling.reconnect.ReconnecterListener;
import jd.gui.swing.jdgui.components.CaptchaIndicator;
import jd.gui.swing.jdgui.components.IconedProcessIndicator;
import jd.gui.swing.jdgui.components.JobLinkCrawlerIndicator;
import jd.gui.swing.jdgui.components.LinkCheckerIndicator;
import jd.gui.swing.jdgui.components.ReconnectProgress;
import jd.gui.swing.jdgui.components.premiumbar.ServicePanel;
import net.miginfocom.swing.MigLayout;
import org.appwork.exceptions.WTFException;
import org.appwork.scheduler.DelayedRunnable;
import org.appwork.swing.components.tooltips.ToolTipController;
import org.appwork.utils.Application;
import org.appwork.utils.swing.EDTHelper;
import org.appwork.utils.swing.EDTRunner;
import org.jdownloader.captcha.event.ChallengeResponseListener;
import org.jdownloader.captcha.v2.AbstractResponse;
import org.jdownloader.captcha.v2.ChallengeResponseController;
import org.jdownloader.captcha.v2.ChallengeSolver;
import org.jdownloader.captcha.v2.solverjob.SolverJob;
import org.jdownloader.gui.translate._GUI;
import org.jdownloader.gui.views.linkgrabber.bottombar.AutoConfirmProcessIndicator;
import org.jdownloader.images.AbstractIcon;
import org.jdownloader.updatev2.gui.LAFOptions;

public class StatusBarImpl
extends JPanel
implements DownloadWatchdogListener {
    private static final long serialVersionUID = 3676496738341246846L;
    private ReconnectProgress reconnectIndicator;
    private JLabel statusLabel;
    private DelayedRunnable updateDelayer;
    private CopyOnWriteArraySet<JComponent> processIndicators = new CopyOnWriteArraySet();
    private IconedProcessIndicator downloadWatchdogIndicator;

    public StatusBarImpl() {
        SecondLevelLaunch.GUI_COMPLETE.executeWhenReached(new Runnable(){

            @Override
            public void run() {
                new EDTRunner(){

                    protected void runInEDT() {
                        StatusBarImpl.this.initGUI();
                    }
                };
            }
        });
    }

    private void initGUI() {
        if (LAFOptions.getInstance().isPaintStatusbarTopBorder()) {
            this.setBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, this.getBackground().darker()));
        } else {
            this.setBorder(BorderFactory.createMatteBorder(0, 0, 0, 0, this.getBackground().darker()));
        }
        this.statusLabel = new JLabel();
        this.statusLabel.setEnabled(false);
        this.reconnectIndicator = new ReconnectProgress();
        this.reconnectIndicator.setTitle(_GUI.T.StatusBarImpl_initGUI_reconnect());
        this.reconnectIndicator.setIndeterminate(false);
        this.reconnectIndicator.setEnabled(false);
        DownloadWatchDog.getInstance().getEventSender().addListener((EventListener)((Object)this));
        Reconnecter.getInstance().getEventSender().addListener((EventListener)new ReconnecterListener(){

            public void onBeforeReconnect(ReconnecterEvent event) {
                new EDTRunner(){

                    protected void runInEDT() {
                        StatusBarImpl.this.reconnectIndicator.setEnabled(true);
                        StatusBarImpl.this.reconnectIndicator.setIndeterminate(true);
                    }
                };
            }

            public void onAfterReconnect(ReconnecterEvent event) {
                new EDTRunner(){

                    protected void runInEDT() {
                        StatusBarImpl.this.reconnectIndicator.setEnabled(false);
                        StatusBarImpl.this.reconnectIndicator.setIndeterminate(false);
                    }
                };
            }
        });
        LinkCollector.getInstance().getEventsender().addListener((EventListener)new LinkCollectorListener(){

            public void onLinkCrawlerStopped(LinkCollectorCrawler crawler) {
            }

            public void onLinkCrawlerStarted(LinkCollectorCrawler crawler) {
            }

            public void onLinkCrawlerNewJob(LinkCollectingJob job) {
            }

            public void onLinkCrawlerFinished() {
            }

            public void onLinkCrawlerAdded(final LinkCollectorCrawler crawler) {
                if (crawler instanceof LinkCollector.JobLinkCrawler) {
                    new EDTRunner(){

                        protected void runInEDT() {
                            new JobLinkCrawlerIndicator(StatusBarImpl.this, (LinkCollector.JobLinkCrawler)crawler);
                        }
                    };
                }
            }

            public void onLinkCollectorStructureRefresh(LinkCollectorEvent event) {
            }

            public void onLinkCollectorLinkAdded(LinkCollectorEvent event, CrawledLink link) {
            }

            public void onLinkCollectorFilteredLinksEmpty(LinkCollectorEvent event) {
            }

            public void onLinkCollectorFilteredLinksAvailable(LinkCollectorEvent event) {
            }

            public void onLinkCollectorDupeAdded(LinkCollectorEvent event, CrawledLink link) {
            }

            public void onLinkCollectorDataRefresh(LinkCollectorEvent event) {
            }

            public void onLinkCollectorContentRemoved(LinkCollectorEvent event) {
            }

            public void onLinkCollectorContentAdded(LinkCollectorEvent event) {
            }

            public void onLinkCollectorAbort(LinkCollectorEvent event) {
            }
        });
        LinkChecker.getEventSender().addListener((EventListener)new LinkCheckerListener(){

            public void onLinkCheckerEvent(final LinkCheckerEvent event) {
                if (!(event.getCaller() instanceof LinkCollector.JobLinkChecker) && LinkCheckerEvent.Type.STARTED.equals(event.getType())) {
                    new EDTRunner(){

                        protected void runInEDT() {
                            new LinkCheckerIndicator(StatusBarImpl.this, (LinkChecker)event.getCaller());
                        }
                    };
                }
            }
        });
        ChallengeResponseController.getInstance().getEventSender().addListener((EventListener)new ChallengeResponseListener(){

            public void onNewJobAnswer(SolverJob<?> job, AbstractResponse<?> response) {
            }

            public void onNewJob(final SolverJob<?> job) {
                new EDTRunner(){

                    protected void runInEDT() {
                        new CaptchaIndicator(StatusBarImpl.this, job);
                    }
                };
            }

            public void onJobSolverStart(ChallengeSolver<?> solver, SolverJob<?> job) {
            }

            public void onJobSolverEnd(ChallengeSolver<?> solver, SolverJob<?> job) {
            }

            public void onJobDone(SolverJob<?> job) {
            }
        });
        AutoConfirmProcessIndicator autoConfirmProcessIndicator = new AutoConfirmProcessIndicator();
        LinkCollector.getInstance().getAutoStartManager().getEventSender().addListener((EventListener)autoConfirmProcessIndicator);
        if (LinkCollector.getInstance().getAutoStartManager().isRunning()) {
            autoConfirmProcessIndicator.onAutoStartManagerRunning();
        }
        this.statusLabel.setHorizontalAlignment(4);
        this.updateDelayer = new DelayedRunnable(ToolTipController.EXECUTER, 1000L, 2000L){

            public String getID() {
                return "StatusBar";
            }

            public void delayedrun() {
                new EDTRunner(){

                    protected void runInEDT() {
                        StatusBarImpl.this.redoLayout();
                    }
                };
            }
        };
        this.redoLayout();
    }

    private void redoLayout() {
        StringBuilder sb = new StringBuilder();
        sb.append("[left]0[grow,fill]");
        ArrayList<JComponent> lprocessIndicators = new ArrayList<JComponent>(this.processIndicators);
        for (int i = -1; i < lprocessIndicators.size(); ++i) {
            sb.append("1[fill,22!]");
        }
        sb.append("3");
        this.setLayout((LayoutManager)new MigLayout("ins 0", sb.toString(), "[fill,22!]"));
        super.removeAll();
        JScrollPane p = new JScrollPane(ServicePanel.getInstance());
        p.setBorder(null);
        p.setHorizontalScrollBarPolicy(31);
        p.setVerticalScrollBarPolicy(21);
        super.add(p);
        super.add((Component)this.statusLabel, "height 22!,gapright 10!");
        super.add((Component)((Object)this.reconnectIndicator), "");
        for (JComponent c : lprocessIndicators) {
            super.add((Component)c, "");
        }
        this.repaint();
        this.revalidate();
    }

    public void removeProcessIndicator(JComponent icon) {
        if (this.processIndicators.remove(icon)) {
            this.updateDelayer.resetAndStart();
        }
    }

    public void addProcessIndicator(JComponent icon) {
        if (this.processIndicators.add(icon)) {
            if (SwingUtilities.isEventDispatchThread()) {
                this.redoLayout();
            } else {
                this.updateDelayer.resetAndStart();
            }
        }
    }

    @Override
    public void remove(Component comp) {
        throw new WTFException("Use #removeProcessIndicator");
    }

    @Override
    public void add(Component comp, Object constraints) {
        throw new WTFException("Use #addProcessIndicator");
    }

    @Override
    public Component add(Component comp) {
        throw new WTFException("Use #addProcessIndicator");
    }

    private JComponent lazyGetDownloadWatchdogIndicator() {
        if (this.downloadWatchdogIndicator != null) {
            return this.downloadWatchdogIndicator;
        }
        this.downloadWatchdogIndicator = (IconedProcessIndicator)new EDTHelper<IconedProcessIndicator>(){

            public IconedProcessIndicator edtRun() {
                if (StatusBarImpl.this.downloadWatchdogIndicator != null) {
                    return StatusBarImpl.this.downloadWatchdogIndicator;
                }
                IconedProcessIndicator ldownloadWatchdogIndicator = new IconedProcessIndicator((Icon)new AbstractIcon("skipped", 16));
                ldownloadWatchdogIndicator.setTitle(_GUI.T.StatusBarImpl_skippedLinksMarker_title());
                ldownloadWatchdogIndicator.setIndeterminate(false);
                ldownloadWatchdogIndicator.setEnabled(true);
                ldownloadWatchdogIndicator.setValue(100);
                ldownloadWatchdogIndicator.addMouseListener(new MouseListener(){

                    @Override
                    public void mouseReleased(MouseEvent e) {
                        DownloadWatchDog.getInstance().unSkipAllSkipped();
                    }

                    @Override
                    public void mousePressed(MouseEvent e) {
                    }

                    @Override
                    public void mouseExited(MouseEvent e) {
                    }

                    @Override
                    public void mouseEntered(MouseEvent e) {
                    }

                    @Override
                    public void mouseClicked(MouseEvent e) {
                    }
                });
                return ldownloadWatchdogIndicator;
            }
        }.getReturnValue();
        return this.downloadWatchdogIndicator;
    }

    public void onDownloadWatchdogDataUpdate() {
        if (DownloadWatchDog.getInstance().getSession().getSkipCounter() > 0) {
            if (!this.hasProcessIndicator(this.lazyGetDownloadWatchdogIndicator())) {
                this.addProcessIndicator(this.lazyGetDownloadWatchdogIndicator());
            }
            new EDTRunner(){

                protected void runInEDT() {
                    if (StatusBarImpl.this.downloadWatchdogIndicator != null) {
                        StatusBarImpl.this.downloadWatchdogIndicator.setDescription(_GUI.T.StatusBarImpl_skippedLinksMarker_desc(DownloadWatchDog.getInstance().getSession().getSkipCounter()));
                    }
                }
            };
        } else if (DownloadWatchDog.getInstance().getSession().getSkipCounter() <= 0 && this.downloadWatchdogIndicator != null) {
            this.removeProcessIndicator(this.lazyGetDownloadWatchdogIndicator());
        }
    }

    private boolean hasProcessIndicator(JComponent icon) {
        return this.processIndicators.contains(icon);
    }

    public void onDownloadWatchdogStateIsIdle() {
    }

    public void onDownloadWatchdogStateIsPause() {
    }

    public void onDownloadWatchdogStateIsRunning() {
    }

    public void onDownloadWatchdogStateIsStopped() {
        if (this.downloadWatchdogIndicator != null) {
            this.removeProcessIndicator(this.lazyGetDownloadWatchdogIndicator());
        }
    }

    public void onDownloadWatchdogStateIsStopping() {
    }

    public void onDownloadControllerStart(SingleDownloadController downloadController, DownloadLinkCandidate candidate) {
    }

    public void onDownloadControllerStopped(SingleDownloadController downloadController, DownloadLinkCandidate candidate, DownloadLinkCandidateResult result) {
    }

    public void onDownloadWatchDogPropertyChange(DownloadWatchDogProperty propertyChange) {
    }

    static {
        if (Application.isHeadless()) {
            throw new HeadlessException();
        }
    }
}

