/*
 * Decompiled with CFR 0.152.
 */
package jd.gui.swing.jdgui.components.premiumbar;

import java.awt.Color;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventListener;
import java.util.LinkedList;
import java.util.concurrent.ScheduledExecutorService;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.table.JTableHeader;
import jd.controlling.AccountController;
import jd.controlling.AccountControllerEvent;
import jd.controlling.AccountControllerListener;
import jd.controlling.accountchecker.AccountChecker;
import jd.controlling.accountchecker.AccountCheckerEventListener;
import jd.gui.swing.jdgui.GUIUtils;
import jd.gui.swing.jdgui.components.premiumbar.AccountListTable;
import jd.gui.swing.jdgui.components.premiumbar.AccountTooltip;
import jd.gui.swing.jdgui.components.premiumbar.AccountTooltipOwner;
import jd.gui.swing.jdgui.components.premiumbar.ServicePanel;
import jd.gui.swing.jdgui.views.settings.panels.accountmanager.AccountEntry;
import jd.plugins.Account;
import jd.plugins.AccountInfo;
import jd.plugins.AccountTrafficView;
import org.appwork.scheduler.DelayedRunnable;
import org.appwork.storage.config.JsonConfig;
import org.appwork.sunwrapper.sun.swing.SwingUtilities2Wrapper;
import org.appwork.swing.components.ExtMergedIcon;
import org.appwork.swing.exttable.ExtColumn;
import org.appwork.swing.exttable.ExtDefaultRowSorter;
import org.appwork.swing.exttable.ExtTableHeaderRenderer;
import org.appwork.swing.exttable.ExtTableModel;
import org.appwork.swing.exttable.columns.ExtCheckColumn;
import org.appwork.swing.exttable.columns.ExtComponentColumn;
import org.appwork.swing.exttable.columns.ExtDateColumn;
import org.appwork.swing.exttable.columns.ExtProgressColumn;
import org.appwork.swing.exttable.columns.ExtTextColumn;
import org.appwork.utils.StringUtils;
import org.appwork.utils.formatter.TimeFormatter;
import org.appwork.utils.swing.EDTRunner;
import org.jdownloader.gui.components.ColumnButton;
import org.jdownloader.gui.translate._GUI;
import org.jdownloader.images.AbstractIcon;
import org.jdownloader.images.NewTheme;
import org.jdownloader.settings.GraphicalUserInterfaceSettings;
import org.jdownloader.updatev2.gui.LAFOptions;

public class AccountListTableModel
extends ExtTableModel<AccountEntry>
implements AccountCheckerEventListener,
AccountControllerListener {
    private static final long serialVersionUID = 3120481189794897020L;
    private DelayedRunnable delayedFill;
    private volatile boolean checkRunning = false;
    private DelayedRunnable delayedUpdate;
    private LinkedList<AccountEntry> accounts;
    private AccountTooltipOwner owner;

    public AccountListTableModel(AccountTooltip accountTooltip, AccountTooltipOwner owner) {
        super("PremiumAccountfilteredTableModel3");
        this.owner = owner;
        ScheduledExecutorService scheduler = DelayedRunnable.getNewScheduledExecutorService();
        this.delayedFill = new DelayedRunnable(scheduler, 250L){

            public String getID() {
                return "PremiumAccountFilteredTableFill";
            }

            public void delayedrun() {
                AccountListTableModel.this._refill();
            }
        };
        this.delayedUpdate = new DelayedRunnable(scheduler, 250L){

            public String getID() {
                return "PremiumAccountFilteredTableUpdate";
            }

            public void delayedrun() {
                AccountListTableModel.this._update();
            }
        };
        AccountController.getInstance().getEventSender().addListener((EventListener)((Object)this), true);
        AccountChecker.getInstance().getEventSender().addListener((EventListener)((Object)this), true);
        if (AccountChecker.getInstance().isRunning()) {
            this.onCheckStarted();
        }
        super.initModel();
    }

    protected void initModel() {
    }

    public void fill() {
        this.delayedFill.run();
    }

    protected void initColumns() {
        if (this.owner != null && this.owner instanceof ServicePanel) {
            this.addColumn((ExtColumn)new ExtCheckColumn<AccountEntry>(_GUI.T.premiumaccounttablemodel_column_enabled()){
                private static final long serialVersionUID = 1515656228974789237L;

                public ExtTableHeaderRenderer getHeaderRenderer(JTableHeader jTableHeader) {
                    ExtTableHeaderRenderer ret = new ExtTableHeaderRenderer((ExtColumn)this, jTableHeader){
                        private final Icon ok;
                        private static final long serialVersionUID = 3224931991570756349L;
                        {
                            this.ok = NewTheme.I().getIcon("ok", 14);
                            AccountListTable.setHeaderRendererColors(this);
                        }

                        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                            this.setIcon(this.ok);
                            this.setHorizontalAlignment(0);
                            this.setText(null);
                            return this;
                        }
                    };
                    return ret;
                }

                public int getMaxWidth() {
                    return 30;
                }

                protected boolean getBooleanValue(AccountEntry value) {
                    return value.getAccount().isEnabled();
                }

                public boolean isEditable(AccountEntry obj) {
                    return true;
                }

                protected void setBooleanValue(boolean enabled, AccountEntry object) {
                    object.getAccount().setEnabled(enabled);
                    AccountListTableModel.this.fireTableStructureChanged();
                }
            });
        }
        this.addColumn((ExtColumn)new ExtTextColumn<AccountEntry>(_GUI.T.premiumaccounttablemodel_column_hoster()){
            private static final long serialVersionUID = -3693931358975303164L;
            {
                AccountListTableModel.this.replaceSorter((ExtColumn<AccountEntry>)((ExtColumn)this));
            }

            public boolean isEnabled(AccountEntry obj) {
                return obj.getAccount().isEnabled();
            }

            protected Icon getIcon(AccountEntry value) {
                return value.getAccount().getDomainInfo().getFavIcon(false);
            }

            public int getDefaultWidth() {
                return 120;
            }

            public int getMinWidth() {
                return 30;
            }

            protected String getTooltipText(AccountEntry obj) {
                return obj.getAccount().getHosterByPlugin();
            }

            public void configureRendererComponent(AccountEntry value, boolean isSelected, boolean hasFocus, int row, int column) {
                this.rendererIcon.setIcon(this.getIcon(value));
                String str = null;
                if (this.getWidth() > 60) {
                    str = this.getStringValue(value);
                }
                if (str == null) {
                    str = "";
                }
                if (this.getTableColumn() != null) {
                    this.rendererField.setText(SwingUtilities2Wrapper.clipStringIfNecessary((JComponent)this.rendererField, (FontMetrics)this.rendererField.getFontMetrics(this.rendererField.getFont()), (String)str, (int)(this.getTableColumn().getWidth() - this.rendererIcon.getPreferredSize().width - 5)));
                } else {
                    this.rendererField.setText(str);
                }
            }

            public String getStringValue(AccountEntry value) {
                return value.getAccount().getHosterByPlugin();
            }
        });
        this.addColumn((ExtColumn)new ExtTextColumn<AccountEntry>(_GUI.T.premiumaccounttablemodel_column_status()){
            private static final long serialVersionUID = -3693931358975303164L;
            final Icon error;
            final Icon okay;
            final Icon wait;
            final Icon expired;
            {
                AccountListTableModel.this.replaceSorter((ExtColumn<AccountEntry>)((ExtColumn)this));
                this.error = NewTheme.I().getIcon("error", 16);
                this.okay = NewTheme.I().getIcon("ok", 16);
                this.wait = NewTheme.I().getIcon("wait", 16);
                this.expired = new ExtMergedIcon((Icon)new AbstractIcon("error", 18)).add((Icon)new AbstractIcon("wait", 12), 6, 6);
            }

            public boolean isEnabled(AccountEntry obj) {
                return obj.getAccount().isEnabled();
            }

            protected Icon getIcon(AccountEntry value) {
                if (value.getAccount().getError() == null) {
                    if (value.getAccount().isTempDisabled()) {
                        return this.wait;
                    }
                    return this.okay;
                }
                switch (value.getAccount().getError()) {
                    case EXPIRED: {
                        return this.expired;
                    }
                    case INVALID: {
                        return this.error;
                    }
                    case PLUGIN_ERROR: {
                        return this.error;
                    }
                }
                return this.okay;
            }

            public int getDefaultWidth() {
                return 160;
            }

            public int getMinWidth() {
                return 24;
            }

            public String getStringValue(AccountEntry value) {
                if (value.getAccount().getError() == null) {
                    String ret;
                    AccountInfo ai = value.getAccount().getAccountInfo();
                    String string = ret = ai == null ? null : ai.getStatus();
                    if (StringUtils.isEmpty((String)ret)) {
                        if (value.getAccount().isTempDisabled()) {
                            if (StringUtils.isNotEmpty((String)value.getAccount().getErrorString())) {
                                return value.getAccount().getErrorString();
                            }
                            ret = _GUI.T.PremiumAccountTableModel_getStringValue_temp_disabled();
                        } else {
                            ret = _GUI.T.PremiumAccountTableModel_getStringValue_account_ok_();
                        }
                    } else {
                        ret = _GUI.T.PremiumAccountTableModel_getStringValue_account_ok_2(ret);
                    }
                    return ret;
                }
                if (StringUtils.isNotEmpty((String)value.getAccount().getErrorString())) {
                    return value.getAccount().getErrorString();
                }
                switch (value.getAccount().getError()) {
                    case EXPIRED: {
                        return _GUI.T.PremiumAccountTableModel_getStringValue_status_expired();
                    }
                    case INVALID: {
                        return _GUI.T.PremiumAccountTableModel_getStringValue_status_invalid();
                    }
                    case PLUGIN_ERROR: {
                        return _GUI.T.PremiumAccountTableModel_getStringValue_status_plugin_error();
                    }
                }
                return _GUI.T.PremiumAccountTableModel_getStringValue_status_unknown_error();
            }
        });
        this.addColumn((ExtColumn)new ExtTextColumn<AccountEntry>(_GUI.T.premiumaccounttablemodel_column_user()){
            private static final long serialVersionUID = -8070328156326837828L;
            {
                AccountListTableModel.this.replaceSorter((ExtColumn<AccountEntry>)((ExtColumn)this));
            }

            public boolean isHidable() {
                return false;
            }

            public int getDefaultWidth() {
                return this.getMinWidth();
            }

            protected Color getDefaultForeground() {
                return LAFOptions.getInstance().getColorForTooltipForeground();
            }

            public int getMinWidth() {
                return 70;
            }

            public boolean isEnabled(AccountEntry obj) {
                return obj.getAccount().isEnabled();
            }

            public boolean isEditable(AccountEntry obj) {
                return false;
            }

            protected void setStringValue(String value, AccountEntry object) {
                object.getAccount().setUser(value);
            }

            public String getStringValue(AccountEntry value) {
                return GUIUtils.getAccountName(value.getAccount().getUser());
            }
        });
        this.addColumn((ExtColumn)new ExtDateColumn<AccountEntry>(_GUI.T.premiumaccounttablemodel_column_expiredate()){
            private static final long serialVersionUID = 5067606909520874358L;
            {
                AccountListTableModel.this.replaceSorter((ExtColumn<AccountEntry>)((ExtColumn)this));
            }

            public boolean isEnabled(AccountEntry obj) {
                return obj.getAccount().isEnabled();
            }

            public int getMaxWidth() {
                return 100;
            }

            protected Color getDefaultForeground() {
                return LAFOptions.getInstance().getColorForTooltipForeground();
            }

            public void resetRenderer() {
                super.resetRenderer();
                this.rendererField.setForeground(LAFOptions.getInstance().getColorForTooltipForeground());
            }

            public int getDefaultWidth() {
                return this.getMinWidth();
            }

            public int getMinWidth() {
                return 100;
            }

            protected String getDateFormatString() {
                return Account.getExpireDateFormatString((Object)((Object)this));
            }

            protected Date getDate(AccountEntry o2, Date date) {
                AccountInfo ai = o2.getAccount().getAccountInfo();
                if (ai == null) {
                    return null;
                }
                if (ai.getValidUntil() <= 0L) {
                    return null;
                }
                return new Date(ai.getValidUntil());
            }
        });
        this.addColumn((ExtColumn)new ExtProgressColumn<AccountEntry>(_GUI.T.premiumaccounttablemodel_column_trafficleft()){
            private final GraphicalUserInterfaceSettings.SIZEUNIT maxSizeUnit;
            private final DecimalFormat formatter;
            private static final long serialVersionUID = -8376056840172682617L;
            {
                this.maxSizeUnit = ((GraphicalUserInterfaceSettings)JsonConfig.create(GraphicalUserInterfaceSettings.class)).getMaxSizeUnit();
                this.formatter = new DecimalFormat();
                this.setRowSorter((ExtDefaultRowSorter)new ExtDefaultRowSorter<AccountEntry>(){

                    private int compareLong(long x, long y) {
                        return x < y ? -1 : (x == y ? 0 : 1);
                    }

                    private int compareTraffic(AccountEntry o1, AccountEntry o2) {
                        long t1 = this.getValue(o1);
                        long t2 = this.getValue(o2);
                        return this.compareLong(t1, t2);
                    }

                    private int compareEnabled(boolean x, boolean y) {
                        return x == y ? 0 : (x ? -1 : 1);
                    }

                    public int compare(AccountEntry o1, AccountEntry o2) {
                        boolean b2;
                        boolean b1 = o1.getAccount().isEnabled();
                        if (b1 == (b2 = o2.getAccount().isEnabled())) {
                            if (this.getSortOrderIdentifier() != "ASC") {
                                return this.compareTraffic(o1, o2);
                            }
                            return -this.compareTraffic(o1, o2);
                        }
                        return this.compareEnabled(b1, b2);
                    }
                });
            }

            public boolean isEnabled(AccountEntry obj) {
                return obj.getAccount().isEnabled();
            }

            public int getMinWidth() {
                return 140;
            }

            protected boolean isIndeterminated(AccountEntry value, boolean isSelected, boolean hasFocus, int row, int column) {
                if (AccountListTableModel.this.checkRunning) {
                    return AccountChecker.getInstance().contains(value.getAccount());
                }
                return value.getAccount().isValid() && value.getAccount().isEnabled() && value.getAccount().isTempDisabled();
            }

            protected String getString(AccountEntry ac, long current, long total) {
                if (!ac.getAccount().isValid()) {
                    return "";
                }
                long timeout = -1L;
                if (ac.getAccount().isEnabled() && ac.getAccount().isTempDisabled() && (timeout = ac.getAccount().getTmpDisabledTimeout() - System.currentTimeMillis()) > 0L) {
                    return _GUI.T.premiumaccounttablemodel_column_trafficleft_tempdisabled(TimeFormatter.formatMilliSeconds((long)timeout, (int)0));
                }
                AccountTrafficView accountTrafficView = ac.getAccount().getAccountTrafficView();
                if (accountTrafficView == null) {
                    return "";
                }
                if (accountTrafficView.isUnlimitedTraffic()) {
                    return _GUI.T.premiumaccounttablemodel_column_trafficleft_unlimited();
                }
                return this.getSizeString(accountTrafficView.getTrafficLeft()) + "/" + this.getSizeString(accountTrafficView.getTrafficMax());
            }

            private final String getSizeString(long fileSize) {
                if (fileSize < 0L) {
                    return _GUI.T.SizeColumn_getSizeString_zero();
                }
                return GraphicalUserInterfaceSettings.SIZEUNIT.formatValue((GraphicalUserInterfaceSettings.SIZEUNIT)this.maxSizeUnit, (DecimalFormat)this.formatter, (long)fileSize);
            }

            protected long getMax(AccountEntry ac) {
                if (!ac.getAccount().isValid()) {
                    return 0L;
                }
                AccountTrafficView accountTrafficView = ac.getAccount().getAccountTrafficView();
                if (accountTrafficView == null) {
                    return 0L;
                }
                if (accountTrafficView.isUnlimitedTraffic()) {
                    return Long.MAX_VALUE;
                }
                return accountTrafficView.getTrafficMax();
            }

            protected long getValue(AccountEntry ac) {
                if (!ac.getAccount().isValid()) {
                    return 0L;
                }
                AccountTrafficView accountTrafficView = ac.getAccount().getAccountTrafficView();
                if (accountTrafficView == null) {
                    return 0L;
                }
                if (accountTrafficView.isUnlimitedTraffic()) {
                    return Long.MAX_VALUE;
                }
                return accountTrafficView.getTrafficLeft();
            }
        });
        if (this.owner != null && this.owner instanceof ServicePanel) {
            this.addColumn((ExtColumn)new ExtComponentColumn<AccountEntry>(_GUI.T.lit_settings()){
                private ColumnButton button;
                private ColumnButton rbutton;
                private AccountEntry editing;
                {
                    this.button = new ColumnButton((Icon)new AbstractIcon("settings", 16));
                    this.rbutton = new ColumnButton((Icon)new AbstractIcon("settings", 16));
                    this.rbutton.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            if (editing != null) {
                                editing.showConfiguration();
                            }
                        }
                    });
                }

                protected Color getDefaultForeground() {
                    return LAFOptions.getInstance().getColorForTooltipForeground();
                }

                public ExtTableHeaderRenderer getHeaderRenderer(JTableHeader jTableHeader) {
                    ExtTableHeaderRenderer ret = new ExtTableHeaderRenderer((ExtColumn)this, jTableHeader){

                        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                            this.setIcon((Icon)new AbstractIcon("settings", 16));
                            this.setHorizontalAlignment(0);
                            this.setText(null);
                            return this;
                        }
                    };
                    AccountListTable.setHeaderRendererColors(ret);
                    return ret;
                }

                public boolean isResizable() {
                    return true;
                }

                public boolean isAutoWidthEnabled() {
                    return true;
                }

                protected boolean isDefaultResizable() {
                    return true;
                }

                public boolean isEnabled(AccountEntry obj) {
                    return true;
                }

                public boolean isHidable() {
                    return false;
                }

                public boolean isEditable(AccountEntry obj) {
                    return super.isEditable((Object)obj);
                }

                public boolean onSingleClick(MouseEvent e, AccountEntry obj) {
                    return super.onSingleClick(e, (Object)obj);
                }

                protected JComponent getInternalEditorComponent(AccountEntry value, boolean isSelected, int row, int column) {
                    return this.rbutton;
                }

                protected JComponent getInternalRendererComponent(AccountEntry value, boolean isSelected, boolean hasFocus, int row, int column) {
                    return this.button;
                }

                public void configureEditorComponent(AccountEntry value, boolean isSelected, int row, int column) {
                    this.editing = value;
                }

                public void configureRendererComponent(AccountEntry value, boolean isSelected, boolean hasFocus, int row, int column) {
                }

                public void resetEditor() {
                }

                public void resetRenderer() {
                }
            });
        }
    }

    private void replaceSorter(ExtColumn<AccountEntry> column) {
        if (column == null) {
            return;
        }
        final ExtDefaultRowSorter oldSorter = column.getRowSorter();
        column.setRowSorter((ExtDefaultRowSorter)new ExtDefaultRowSorter<AccountEntry>(){

            public int compare(boolean x, boolean y) {
                return x == y ? 0 : (x ? -1 : 1);
            }

            public int compare(AccountEntry o1, AccountEntry o2) {
                boolean b2;
                boolean b1 = o1.getAccount().isEnabled();
                if (b1 == (b2 = o2.getAccount().isEnabled())) {
                    if (this.getSortOrderIdentifier() != "ASC") {
                        return oldSorter.compare((Object)o1, (Object)o2);
                    }
                    return -oldSorter.compare((Object)o1, (Object)o2);
                }
                return this.compare(b1, b2);
            }
        });
    }

    public void onCheckStarted() {
        this.checkRunning = true;
    }

    public void onCheckStopped() {
        this.checkRunning = false;
        this._update();
    }

    protected void _update() {
        new EDTRunner(){

            protected void runInEDT() {
                AccountListTableModel.this.getTable().repaint();
            }
        };
    }

    protected void _refill() {
        ArrayList<AccountEntry> newtableData = new ArrayList<AccountEntry>(this.accounts);
        this._fireTableStructureChanged(newtableData, true);
    }

    public void setData(LinkedList<AccountEntry> domains) {
        this.accounts = domains;
        this._refill();
    }

    public void onAccountControllerEvent(AccountControllerEvent event) {
        switch ((AccountControllerEvent.Types)event.getType()) {
            case ACCOUNT_CHECKED: 
            case ACCOUNT_PROPERTY_UPDATE: {
                this.delayedUpdate.run();
                break;
            }
            default: {
                this.delayedFill.run();
            }
        }
    }
}

