/*
 * Decompiled with CFR 0.152.
 */
package jd.gui.swing.jdgui.components.speedmeter;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.EventListener;
import jd.controlling.downloadcontroller.DownloadWatchDog;
import org.appwork.storage.config.JsonConfig;
import org.appwork.storage.config.ValidationException;
import org.appwork.storage.config.events.GenericConfigEventListener;
import org.appwork.storage.config.handler.KeyHandler;
import org.appwork.utils.formatter.SizeFormatter;
import org.appwork.utils.swing.EDTRunner;
import org.appwork.utils.swing.Graph;
import org.appwork.utils.swing.graph.Limiter;
import org.jdownloader.gui.translate._GUI;
import org.jdownloader.settings.GeneralSettings;
import org.jdownloader.settings.staticreferences.CFG_GENERAL;
import org.jdownloader.settings.staticreferences.CFG_GUI;
import org.jdownloader.updatev2.gui.LAFOptions;

public class SpeedMeterPanel
extends Graph {
    private static final long serialVersionUID = 5571694800446993879L;
    private final Limiter speedLimiter;
    private final GeneralSettings config;
    private final DecimalFormat decimalFormat;

    protected NumberFormat getNumberFormat() {
        return this.decimalFormat;
    }

    public SpeedMeterPanel(boolean contextMenu, boolean start) {
        int fps = Math.max(1, CFG_GUI.CFG.getSpeedMeterFramesPerSecond());
        this.setCapacity(CFG_GUI.CFG.getSpeedMeterTimeFrame() * fps / 1000);
        this.setInterval(1000 / fps);
        this.decimalFormat = new DecimalFormat("0.00");
        this.setCurrentColorTop(LAFOptions.getInstance().getColorForSpeedmeterCurrentTop());
        this.setCurrentColorBottom(LAFOptions.getInstance().getColorForSpeedmeterCurrentBottom());
        this.setAverageColor(LAFOptions.getInstance().getColorForSpeedMeterAverage());
        this.setAverageTextColor(LAFOptions.getInstance().getColorForSpeedMeterAverageText());
        this.setTextColor(LAFOptions.getInstance().getColorForSpeedMeterText());
        this.setOpaque(false);
        this.speedLimiter = new Limiter(LAFOptions.getInstance().getColorForSpeedmeterLimiterTop(), LAFOptions.getInstance().getColorForSpeedmeterLimiterBottom()){

            public String getString() {
                return _GUI.T.SpeedMeterPanel_getString_limited(SizeFormatter.formatBytes((DecimalFormat)SpeedMeterPanel.this.decimalFormat, (long)SpeedMeterPanel.this.speedLimiter.getValue()));
            }
        };
        this.config = (GeneralSettings)JsonConfig.create(GeneralSettings.class);
        this.speedLimiter.setValue(this.config.isDownloadSpeedLimitEnabled() ? this.config.getDownloadSpeedLimit() : 0);
        CFG_GENERAL.DOWNLOAD_SPEED_LIMIT.getEventSender().addListener((EventListener)new GenericConfigEventListener<Integer>(){

            public void onConfigValueModified(KeyHandler<Integer> keyHandler, Integer newValue) {
                new EDTRunner(){

                    protected void runInEDT() {
                        SpeedMeterPanel.this.speedLimiter.setValue(SpeedMeterPanel.this.config.isDownloadSpeedLimitEnabled() ? SpeedMeterPanel.this.config.getDownloadSpeedLimit() : 0);
                    }
                };
            }

            public void onConfigValidatorError(KeyHandler<Integer> keyHandler, Integer invalidValue, ValidationException validateException) {
            }
        }, false);
        CFG_GENERAL.DOWNLOAD_SPEED_LIMIT_ENABLED.getEventSender().addListener((EventListener)new GenericConfigEventListener<Boolean>(){

            public void onConfigValidatorError(KeyHandler<Boolean> keyHandler, Boolean invalidValue, ValidationException validateException) {
            }

            public void onConfigValueModified(KeyHandler<Boolean> keyHandler, Boolean newValue) {
                new EDTRunner(){

                    protected void runInEDT() {
                        SpeedMeterPanel.this.speedLimiter.setValue(SpeedMeterPanel.this.config.isDownloadSpeedLimitEnabled() ? SpeedMeterPanel.this.config.getDownloadSpeedLimit() : 0);
                    }
                };
            }
        }, false);
        this.setLimiter(new Limiter[]{this.speedLimiter});
        if (start) {
            this.start();
        }
        this.setAntiAliasing(LAFOptions.getInstance().getCfg().isSpeedmeterAntiAliasingEnabled());
    }

    protected String createTooltipText() {
        int limit = -1;
        if (this.config.isDownloadSpeedLimitEnabled() && (limit = this.config.getDownloadSpeedLimit()) > 0) {
            return this.getAverageSpeedString() + "  " + this.getSpeedString() + "\r\n" + _GUI.T.SpeedMeterPanel_createTooltipText_(SizeFormatter.formatBytes((DecimalFormat)this.decimalFormat, (long)limit));
        }
        return this.getAverageSpeedString() + "  " + this.getSpeedString();
    }

    public int getValue() {
        return DownloadWatchDog.getInstance().getDownloadSpeedManager().getSpeed();
    }
}

