/*
 * Decompiled with CFR 0.152.
 */
package jd.gui.swing.jdgui.components.toolbar.actions;

import java.awt.Dialog;
import java.awt.event.ActionEvent;
import javax.swing.Icon;
import jd.controlling.downloadcontroller.DownloadWatchDog;
import jd.controlling.downloadcontroller.SingleDownloadController;
import jd.controlling.reconnect.ReconnectException;
import jd.controlling.reconnect.Reconnecter;
import jd.gui.swing.jdgui.JDGui;
import jd.gui.swing.jdgui.WarnLevel;
import jd.gui.swing.jdgui.views.settings.panels.reconnect.ReconnectDialog;
import jd.plugins.download.DownloadInterface;
import org.appwork.storage.config.ValidationException;
import org.appwork.storage.config.events.GenericConfigEventListener;
import org.appwork.storage.config.handler.KeyHandler;
import org.appwork.uio.CloseReason;
import org.appwork.uio.ConfirmDialogInterface;
import org.appwork.uio.UIOManager;
import org.appwork.uio.UserIODefinition;
import org.appwork.utils.logging2.LogSource;
import org.appwork.utils.swing.EDTRunner;
import org.appwork.utils.swing.dialog.AbstractDialog;
import org.appwork.utils.swing.dialog.ConfirmDialog;
import org.appwork.utils.swing.dialog.Dialog;
import org.appwork.utils.swing.dialog.DialogCanceledException;
import org.appwork.utils.swing.dialog.DialogClosedException;
import org.jdownloader.gui.toolbar.action.AbstractToolBarAction;
import org.jdownloader.gui.translate._GUI;
import org.jdownloader.images.AbstractIcon;
import org.jdownloader.settings.staticreferences.CFG_RECONNECT;
import org.jdownloader.translate._JDT;

public class ReconnectAction
extends AbstractToolBarAction {
    private final GenericConfigEventListener<String> listener;

    public ReconnectAction() {
        this.setIconKey("reconnect");
        this.setAccelerator(82);
        this.listener = new GenericConfigEventListener<String>(){

            public void onConfigValueModified(KeyHandler<String> keyHandler, String newValue) {
                ReconnectAction.this.updateAction(newValue);
            }

            public void onConfigValidatorError(KeyHandler<String> keyHandler, String invalidValue, ValidationException validateException) {
            }
        };
        CFG_RECONNECT.ACTIVE_PLUGIN_ID.getEventSender().addListener(this.listener);
        this.updateAction(CFG_RECONNECT.ACTIVE_PLUGIN_ID.getValue());
    }

    private void updateAction(String activePlugin) {
        if ("DummyRouterPlugin".equalsIgnoreCase(activePlugin)) {
            new EDTRunner(){

                protected void runInEDT() {
                    ReconnectAction.this.setEnabled(false);
                }
            };
        } else {
            new EDTRunner(){

                protected void runInEDT() {
                    ReconnectAction.this.setEnabled(true);
                }
            };
        }
    }

    public void actionPerformed(ActionEvent e) {
        new Thread(){

            @Override
            public void run() {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                String dialogMessage = null;
                for (SingleDownloadController con : DownloadWatchDog.getInstance().getRunningDownloadLinks()) {
                    if (!con.isAlive()) continue;
                    dialogMessage = _JDT.T.DownloadWatchDog_onShutdownRequest_();
                    DownloadInterface dl = con.getDownloadInstance();
                    if (dl == null || con.getDownloadLink().isResumeable()) continue;
                    dialogMessage = _JDT.T.DownloadWatchDog_onShutdownRequest_nonresumable();
                    break;
                }
                dialogMessage = dialogMessage == null ? _GUI.T.gui_reconnect_confirm() : "\r\n" + _GUI.T.gui_reconnect_confirm();
                ConfirmDialog d = new ConfirmDialog(544, _GUI.T.lit_are_you_sure(), dialogMessage, (Icon)new AbstractIcon("reconnect", 32), _GUI.T.lit_yes(), _GUI.T.lit_no()){

                    public Dialog.ModalityType getModalityType() {
                        return Dialog.ModalityType.MODELESS;
                    }
                };
                if (!JDGui.bugme(WarnLevel.NORMAL) || ((ConfirmDialogInterface)UIOManager.I().show(ConfirmDialogInterface.class, (UserIODefinition)d)).getCloseReason() == CloseReason.OK) {
                    try {
                        Dialog.getInstance().showDialog((AbstractDialog)new ReconnectDialog(){

                            public Dialog.ModalityType getModalityType() {
                                return Dialog.ModalityType.MODELESS;
                            }

                            @Override
                            protected boolean startReconnectAndWait(LogSource logger) throws ReconnectException, InterruptedException {
                                return DownloadWatchDog.getInstance().requestReconnect(true) == Reconnecter.ReconnectResult.SUCCESSFUL;
                            }
                        });
                    }
                    catch (DialogClosedException e1) {
                        e1.printStackTrace();
                    }
                    catch (DialogCanceledException e1) {
                        e1.printStackTrace();
                    }
                }
            }
        }.start();
    }

    protected String createTooltip() {
        return _GUI.T.action_reconnect_invoke_tooltip();
    }
}

