/*
 * Decompiled with CFR 0.152.
 */
package jd.gui.swing.jdgui.components.toolbar.actions;

import java.awt.event.ActionEvent;
import java.util.EventListener;
import javax.swing.Icon;
import jd.controlling.TaskQueue;
import jd.controlling.downloadcontroller.DownloadLinkCandidate;
import jd.controlling.downloadcontroller.DownloadLinkCandidateResult;
import jd.controlling.downloadcontroller.DownloadWatchDog;
import jd.controlling.downloadcontroller.DownloadWatchDogProperty;
import jd.controlling.downloadcontroller.SingleDownloadController;
import jd.controlling.downloadcontroller.event.DownloadWatchdogListener;
import jd.gui.swing.jdgui.JDGui;
import jd.gui.swing.jdgui.WarnLevel;
import jd.plugins.download.DownloadInterface;
import org.appwork.controlling.State;
import org.appwork.controlling.StateMachine;
import org.appwork.uio.UIOManager;
import org.appwork.utils.event.queue.QueueAction;
import org.appwork.utils.formatter.SizeFormatter;
import org.appwork.utils.swing.EDTRunner;
import org.jdownloader.controlling.contextmenu.ActionContext;
import org.jdownloader.controlling.contextmenu.Customizer;
import org.jdownloader.gui.toolbar.action.AbstractToolBarAction;
import org.jdownloader.gui.translate._GUI;
import org.jdownloader.images.AbstractIcon;
import org.jdownloader.translate._JDT;

public class StopDownloadsAction
extends AbstractToolBarAction
implements DownloadWatchdogListener,
ActionContext {
    private boolean hideIfDownloadsAreStopped = false;
    public static final String HIDE_IF_DOWNLOADS_ARE_STOPPED = "HideIfDownloadsAreStopped";

    public StopDownloadsAction() {
        this.setIconKey("media-playback-stop");
        this.setEnabled(false);
        DownloadWatchDog.getInstance().getEventSender().addListener((EventListener)((Object)this), true);
        DownloadWatchDog.getInstance().notifyCurrentState((DownloadWatchdogListener)this);
        this.setName(_GUI.T.StopDownloadsAction());
        this.setAccelerator(83);
    }

    public void initContextDefaults() {
        this.setHideIfDownloadsAreStopped(false);
    }

    public void actionPerformed(ActionEvent e) {
        if (this.isEnabled()) {
            TaskQueue.getQueue().add((QueueAction)new QueueAction<Void, RuntimeException>(){

                protected Void run() throws RuntimeException {
                    if (StopDownloadsAction.this.isEnabled()) {
                        StateMachine stateMachine = DownloadWatchDog.getInstance().getStateMachine();
                        if (stateMachine.hasPassed(new State[]{DownloadWatchDog.STOPPING_STATE})) {
                            return null;
                        }
                        if (DownloadWatchDog.getInstance().getStateMachine().isState(new State[]{DownloadWatchDog.RUNNING_STATE, DownloadWatchDog.PAUSE_STATE, DownloadWatchDog.STOPPING_STATE})) {
                            WarnLevel level;
                            int nonResumableDownloads = 0;
                            long estimatedLostDownloadedBytes = 0L;
                            for (SingleDownloadController con : DownloadWatchDog.getInstance().getRunningDownloadLinks()) {
                                DownloadInterface dl = con.getDownloadInstance();
                                if (dl == null || con.getDownloadLink().isResumeable()) continue;
                                ++nonResumableDownloads;
                                estimatedLostDownloadedBytes += Math.max(0L, con.getDownloadLink().getView().getBytesLoaded());
                            }
                            if (nonResumableDownloads > 0 && JDGui.bugme(level = estimatedLostDownloadedBytes > 0L ? WarnLevel.SEVERE : WarnLevel.LOW) && !UIOManager.I().showConfirmDialog(544, _GUI.T.lit_are_you_sure(), _GUI.T.StopDownloadsAction_run_msg_(SizeFormatter.formatBytes((long)estimatedLostDownloadedBytes), nonResumableDownloads), (Icon)new AbstractIcon("stop", 32), _GUI.T.lit_yes(), _GUI.T.lit_no(), "jd.gui.swing.jdgui.components.toolbar.actions.StopDownloadsAction")) {
                                return null;
                            }
                        }
                        DownloadWatchDog.getInstance().stopDownloads();
                    }
                    return null;
                }
            });
        }
    }

    public static String getHideIfDownloadsAreStoppedTranslation() {
        return _JDT.T.PauseDownloadsAction_getHideIfDownloadsAreStoppedTranslation();
    }

    @Customizer(link="#getHideIfDownloadsAreStoppedTranslation")
    public boolean isHideIfDownloadsAreStopped() {
        return this.hideIfDownloadsAreStopped;
    }

    public void setHideIfDownloadsAreStopped(boolean showIfDownloadsAreRunning) {
        this.hideIfDownloadsAreStopped = showIfDownloadsAreRunning;
        if (this.isHideIfDownloadsAreStopped() && !DownloadWatchDog.getInstance().isRunning()) {
            this.setVisible(false);
        } else {
            this.setVisible(true);
        }
    }

    public String createTooltip() {
        return _GUI.T.action_stop_downloads_tooltip();
    }

    public void onDownloadWatchdogStateIsStopping() {
        new EDTRunner(){

            protected void runInEDT() {
                StopDownloadsAction.this.setEnabled(false);
            }
        };
    }

    public void onDownloadWatchdogStateIsStopped() {
        new EDTRunner(){

            protected void runInEDT() {
                StopDownloadsAction.this.setEnabled(false);
                if (StopDownloadsAction.this.isHideIfDownloadsAreStopped()) {
                    StopDownloadsAction.this.setVisible(false);
                }
            }
        };
    }

    public void onDownloadWatchdogStateIsRunning() {
        new EDTRunner(){

            protected void runInEDT() {
                StopDownloadsAction.this.setEnabled(true);
                StopDownloadsAction.this.setVisible(true);
            }
        };
    }

    public void onDownloadWatchdogStateIsPause() {
    }

    public void onDownloadWatchdogStateIsIdle() {
        new EDTRunner(){

            protected void runInEDT() {
                StopDownloadsAction.this.setEnabled(false);
                if (StopDownloadsAction.this.isHideIfDownloadsAreStopped()) {
                    StopDownloadsAction.this.setVisible(false);
                }
            }
        };
    }

    public void onDownloadWatchdogDataUpdate() {
    }

    public void onDownloadControllerStart(SingleDownloadController downloadController, DownloadLinkCandidate candidate) {
    }

    public void onDownloadControllerStopped(SingleDownloadController downloadController, DownloadLinkCandidate candidate, DownloadLinkCandidateResult result) {
    }

    public void onDownloadWatchDogPropertyChange(DownloadWatchDogProperty propertyChange) {
    }
}

