/*
 * Decompiled with CFR 0.152.
 */
package jd.gui.swing.jdgui.menu;

import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.EventListener;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import jd.controlling.downloadcontroller.DownloadLinkCandidate;
import jd.controlling.downloadcontroller.DownloadLinkCandidateResult;
import jd.controlling.downloadcontroller.DownloadWatchDog;
import jd.controlling.downloadcontroller.DownloadWatchDogProperty;
import jd.controlling.downloadcontroller.SingleDownloadController;
import jd.controlling.downloadcontroller.event.DownloadWatchdogListener;
import jd.gui.swing.jdgui.menu.MenuEditor;
import net.miginfocom.swing.MigLayout;
import org.appwork.storage.config.ValidationException;
import org.appwork.storage.config.swing.models.ConfigIntSpinnerModel;
import org.appwork.swing.components.ExtCheckBox;
import org.appwork.swing.components.SizeSpinner;
import org.appwork.utils.locale._AWU;
import org.appwork.utils.swing.EDTRunner;
import org.jdownloader.gui.translate._GUI;
import org.jdownloader.images.AbstractIcon;
import org.jdownloader.settings.staticreferences.CFG_GENERAL;

public class SpeedlimitEditor
extends MenuEditor
implements DownloadWatchdogListener {
    private static final long serialVersionUID = 5406904697287119514L;
    private JLabel lbl;
    private SizeSpinner spinner;
    private ExtCheckBox checkbox;

    public SpeedlimitEditor() {
        this(false);
    }

    public SpeedlimitEditor(boolean b) {
        super(b);
        this.setLayout((LayoutManager)new MigLayout("ins " + this.getInsetsString(), "6[grow,fill][][]", "[" + this.getComponentHeight() + "!]"));
        this.setOpaque(false);
        this.lbl = this.getLbl(_GUI.T.SpeedlimitEditor_SpeedlimitEditor_(), (Icon)new AbstractIcon("speed", 18));
        this.spinner = new SizeSpinner((SpinnerNumberModel)new ConfigIntSpinnerModel(CFG_GENERAL.DOWNLOAD_SPEED_LIMIT){
            private static final long serialVersionUID = -8549816276073605186L;

            public void setValue(Object value) {
                if (DownloadWatchDog.getInstance().isPaused()) {
                    try {
                        CFG_GENERAL.PAUSE_SPEED.setValue((Object)((Number)value).intValue());
                    }
                    catch (ValidationException e) {
                        Toolkit.getDefaultToolkit().beep();
                    }
                }
                super.setValue(value);
            }
        }){
            private static final long serialVersionUID = 1L;

            protected Object textToObject(String text) {
                if (text != null && text.trim().matches("^[0-9]+$")) {
                    return super.textToObject(text + " kb/s");
                }
                return super.textToObject(text);
            }

            protected String longToText(long longValue) {
                if (longValue <= 0L) {
                    return _GUI.T.SpeedlimitEditor_format(_AWU.T.literally_kibibyte("0"));
                }
                return _GUI.T.SpeedlimitEditor_format(super.longToText(longValue));
            }
        };
        try {
            ((JSpinner.DefaultEditor)this.spinner.getEditor()).getTextField().addFocusListener(new FocusListener(){

                @Override
                public void focusLost(FocusEvent e) {
                }

                @Override
                public void focusGained(FocusEvent e) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            ((JSpinner.DefaultEditor)SpeedlimitEditor.this.spinner.getEditor()).getTextField().selectAll();
                        }
                    });
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.add(this.lbl);
        this.checkbox = new ExtCheckBox(CFG_GENERAL.DOWNLOAD_SPEED_LIMIT_ENABLED, new JComponent[]{this.lbl});
        this.add((Component)this.checkbox, "width 20!");
        this.checkbox.setVerticalAlignment(0);
        DownloadWatchDog.getInstance().getEventSender().addListener((EventListener)((Object)this), true);
        this.add((Component)this.spinner, "width " + this.getEditorWidth() + "!");
        DownloadWatchDog.getInstance().notifyCurrentState((DownloadWatchdogListener)this);
    }

    public void onDownloadWatchdogDataUpdate() {
    }

    public void onDownloadWatchdogStateIsIdle() {
        new EDTRunner(){

            protected void runInEDT() {
                SpeedlimitEditor.this.checkbox.setEnabled(true);
            }
        };
    }

    public void onDownloadWatchdogStateIsPause() {
        new EDTRunner(){

            protected void runInEDT() {
                SpeedlimitEditor.this.checkbox.setEnabled(false);
            }
        };
    }

    public void onDownloadWatchdogStateIsRunning() {
        new EDTRunner(){

            protected void runInEDT() {
                SpeedlimitEditor.this.checkbox.setEnabled(true);
            }
        };
    }

    public void onDownloadWatchdogStateIsStopped() {
        new EDTRunner(){

            protected void runInEDT() {
                SpeedlimitEditor.this.checkbox.setEnabled(true);
            }
        };
    }

    public void onDownloadWatchdogStateIsStopping() {
        new EDTRunner(){

            protected void runInEDT() {
                SpeedlimitEditor.this.checkbox.setEnabled(true);
            }
        };
    }

    public void onDownloadControllerStart(SingleDownloadController downloadController, DownloadLinkCandidate candidate) {
    }

    public void onDownloadControllerStopped(SingleDownloadController downloadController, DownloadLinkCandidate candidate, DownloadLinkCandidateResult result) {
    }

    public void onDownloadWatchDogPropertyChange(DownloadWatchDogProperty propertyChange) {
    }
}

