/*
 * Decompiled with CFR 0.152.
 */
package jd.gui.swing.jdgui.menu.actions.sendlogs;

import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.swing.Icon;
import jd.controlling.ClipboardMonitoring;
import org.appwork.utils.logging2.LogSink;
import org.appwork.utils.logging2.LogSourceProvider;
import org.appwork.utils.logging2.sendlogs.AbstractLogAction;
import org.appwork.utils.logging2.sendlogs.LogFolder;
import org.appwork.utils.swing.dialog.Dialog;
import org.appwork.utils.swing.dialog.DialogCanceledException;
import org.appwork.utils.swing.dialog.DialogClosedException;
import org.jdownloader.gui.translate._GUI;
import org.jdownloader.images.AbstractIcon;
import org.jdownloader.jdserv.JDServUtils;
import org.jdownloader.logging.LogController;
import org.jdownloader.startup.commands.ThreadDump;

public class LogAction
extends AbstractLogAction {
    private static final long serialVersionUID = 2812939206413328737L;
    protected String id;

    public LogAction() {
        this.setName(_GUI.T.LogAction());
        this.setSmallIcon((Icon)new AbstractIcon("log", 22));
        this.setTooltipText(_GUI.T.LogAction_tooltip());
        this.id = null;
    }

    protected void create() throws DialogClosedException, DialogCanceledException {
        new ThreadDump().run(null, new String[0]);
        super.create();
    }

    protected void createPackage(List<LogFolder> selection) throws Exception {
        this.id = null;
        super.createPackage(selection);
        String id = this.id;
        if (id != null) {
            String name = this.format(selection.get(0).getCreated()) + " <--> " + this.format(selection.get(selection.size() - 1).getLastModified());
            String jdLog = "jdlog://" + id + "/";
            ClipboardMonitoring.getINSTANCE().setCurrentContent(jdLog);
            Dialog.getInstance().showInputDialog(16, _GUI.T.LogAction_actionPerformed_givelogid_(), name + " " + jdLog);
        }
    }

    protected void onNewPackage(File zip, String name) throws IOException {
        try {
            if (Thread.currentThread().isInterrupted()) {
                throw new InterruptedException("Interrupted");
            }
            this.id = JDServUtils.uploadLog((File)zip, (String)this.id);
            if (Thread.currentThread().isInterrupted()) {
                throw new InterruptedException("Interrupted");
            }
        }
        catch (InterruptedException e) {
            LogController.CL().log((Throwable)e);
        }
        catch (Exception e) {
            LogController.CL().log((Throwable)e);
            Dialog.getInstance().showExceptionDialog("Exception ocurred", e.getMessage(), (Throwable)e);
        }
    }

    protected void flushLogs() {
        LogSourceProvider.flushAllSinks((LogSink.FLUSH)LogSink.FLUSH.FORCE);
    }

    protected boolean isCurrentLogFolder(long timestamp) {
        long startup = LogController.getInstance().getInitTime();
        return startup == timestamp;
    }
}

