/*
 * Decompiled with CFR 0.152.
 */
package jd.gui.swing.jdgui.views.settings.panels;

import java.awt.Component;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.SpinnerNumberModel;
import jd.gui.swing.jdgui.views.settings.components.Checkbox;
import jd.gui.swing.jdgui.views.settings.components.ComboBox;
import jd.gui.swing.jdgui.views.settings.components.FolderChooser;
import jd.gui.swing.jdgui.views.settings.components.Spinner;
import org.appwork.storage.config.JsonConfig;
import org.appwork.storage.config.handler.KeyHandler;
import org.appwork.storage.config.swing.models.ConfigIntSpinnerModel;
import org.jdownloader.gui.settings.AbstractConfigPanel;
import org.jdownloader.gui.translate._GUI;
import org.jdownloader.images.AbstractIcon;
import org.jdownloader.settings.AutoDownloadStartOption;
import org.jdownloader.settings.CleanAfterDownloadAction;
import org.jdownloader.settings.GeneralSettings;
import org.jdownloader.settings.IfFileExistsAction;
import org.jdownloader.settings.staticreferences.CFG_GENERAL;
import org.jdownloader.settings.staticreferences.CFG_LINKGRABBER;
import org.jdownloader.translate._JDT;

public class GeneralSettingsConfigPanel
extends AbstractConfigPanel {
    private static final long serialVersionUID = 3383448498625377495L;
    private FolderChooser downloadFolder;
    private Spinner maxSimPerHost;
    private ComboBox<CleanAfterDownloadAction> remove;
    private ComboBox<IfFileExistsAction> ifFileExists;
    private Spinner maxSim;
    private GeneralSettings config = CFG_GENERAL.CFG;
    private Spinner maxchunks;
    private ComboBox<AutoDownloadStartOption> startDownloadsAfterAppStart;
    private Spinner startDownloadTimeout;
    private Checkbox subfolder;
    private Checkbox autoCRC;
    private Checkbox restartFailedCRC;
    private Checkbox simpleContainer;
    private Checkbox linkGrabberFilesPackages;

    public GeneralSettingsConfigPanel() {
        this.downloadFolder = new FolderChooser();
        this.addHeader(_GUI.T.gui_config_general_downloaddirectory(), (Icon)new AbstractIcon("downloadpath", 32));
        this.addDescription(_JDT.T.gui_settings_downloadpath_description());
        this.add((Component)((Object)this.downloadFolder));
        String[] removeDownloads = new String[]{_GUI.T.gui_config_general_toDoWithDownloads_immediate(), _GUI.T.gui_config_general_toDoWithDownloads_atstart(), _GUI.T.gui_config_general_toDoWithDownloads_packageready(), _GUI.T.gui_config_general_toDoWithDownloads_never()};
        String[] fileExists = new String[]{_GUI.T.system_download_triggerfileexists_overwrite(), CFG_GENERAL.CFG.getOnSkipDueToAlreadyExistsAction().getLabel(), _GUI.T.system_download_triggerfileexists_rename(), _GUI.T.system_download_triggerfileexists_ask(), _GUI.T.system_download_triggerfileexists_ask()};
        this.maxSim = new Spinner((SpinnerNumberModel)new ConfigIntSpinnerModel(CFG_GENERAL.MAX_SIMULTANE_DOWNLOADS));
        this.maxSimPerHost = new Spinner((SpinnerNumberModel)new ConfigIntSpinnerModel(CFG_GENERAL.MAX_SIMULTANE_DOWNLOADS_PER_HOST));
        this.maxchunks = new Spinner((SpinnerNumberModel)new ConfigIntSpinnerModel(CFG_GENERAL.MAX_CHUNKS_PER_FILE));
        this.remove = new ComboBox<CleanAfterDownloadAction>((ContentType[])CleanAfterDownloadAction.values(), removeDownloads);
        this.ifFileExists = new ComboBox<IfFileExistsAction>((ContentType[])IfFileExistsAction.values(), fileExists);
        this.addHeader(_JDT.T.gui_settings_downloadcontroll_title(), (Icon)new AbstractIcon("downloadmanagment", 32));
        this.addDescription(_JDT.T.gui_settings_downloadcontroll_description());
        this.addPair(_GUI.T.gui_config_download_simultan_downloads(), null, this.maxSim);
        this.addPair(_GUI.T.gui_config_download_simultan_downloads_per_host2(), CFG_GENERAL.MAX_DOWNLOADS_PER_HOST_ENABLED, this.maxSimPerHost);
        this.addPair(_GUI.T.gui_config_download_max_chunks(), null, this.maxchunks);
        this.addPair(_GUI.T.gui_config_general_todowithdownloads(), null, this.remove);
        this.addPair(_GUI.T.system_download_triggerfileexists(), null, this.ifFileExists);
        this.startDownloadsAfterAppStart = new ComboBox<AutoDownloadStartOption>((KeyHandler<AutoDownloadStartOption>)CFG_GENERAL.SH.getKeyHandler("AutoStartDownloadOption", KeyHandler.class), (ContentType[])AutoDownloadStartOption.values(), new String[]{_GUI.T.gui_config_general_AutoDownloadStartOption_always(), _GUI.T.gui_config_general_AutoDownloadStartOption_only_if_closed_running(), _GUI.T.gui_config_general_AutoDownloadStartOption_never()});
        this.startDownloadTimeout = new Spinner((SpinnerNumberModel)new ConfigIntSpinnerModel(CFG_GENERAL.AUTO_START_COUNTDOWN_SECONDS));
        this.addHeader(_GUI.T.gui_config_download_autostart(), (Icon)new AbstractIcon("resume", 32));
        this.addDescription(_GUI.T.gui_config_download_autostart_desc());
        this.addPair(_GUI.T.system_download_autostart(), null, this.startDownloadsAfterAppStart);
        this.addPair(_GUI.T.system_download_autostart_countdown(), CFG_GENERAL.SHOW_COUNTDOWNON_AUTO_START_DOWNLOADS, this.startDownloadTimeout);
        this.linkGrabberFilesPackages = new Checkbox(CFG_LINKGRABBER.VARIOUS_PACKAGE_ENABLED, new JComponent[0]);
        this.addHeader(_GUI.T.GeneralSettingsConfigPanel_GeneralSettingsConfigPanel_linkgrabber(), (Icon)new AbstractIcon("linkgrabber", 32));
        this.addPair(_GUI.T.GeneralSettingsConfigPanel_GeneralSettingsConfigPanel_various_package(), null, this.linkGrabberFilesPackages);
        this.autoCRC = new Checkbox();
        this.addHeader(_GUI.T.gui_config_download_write(), (Icon)new AbstractIcon("hashsum", 32));
        this.addDescription(_JDT.T.gui_settings_filewriting_description());
        this.addPair(_GUI.T.gui_config_download_crc(), null, this.autoCRC);
        this.restartFailedCRC = new Checkbox();
        this.addPair(_GUI.T.gui_config_restart_crc(), null, this.restartFailedCRC);
        this.simpleContainer = new Checkbox();
        this.addHeader(_GUI.T.gui_config_various(), (Icon)new AbstractIcon("settings", 32));
        this.addPair(_GUI.T.gui_config_simple_container(), null, this.simpleContainer);
    }

    public String getTitle() {
        return _JDT.T.gui_settings_general_title();
    }

    public String getIconKey() {
        return "settings";
    }

    public Icon getIcon() {
        return new AbstractIcon("home", 32);
    }

    public void save() {
        GeneralSettings st = (GeneralSettings)JsonConfig.create(GeneralSettings.class);
        st.setDefaultDownloadFolder(this.downloadFolder.getText());
        st.setHashCheckEnabled(this.autoCRC.isSelected());
        st.setHashRetryEnabled(this.restartFailedCRC.isSelected());
        st.setAutoOpenContainerAfterDownload(this.simpleContainer.isSelected());
        this.config.setCleanupAfterDownloadAction(this.remove.getValue());
        this.config.setIfFileExistsAction(this.ifFileExists.getValue());
    }

    public void updateContents() {
        GeneralSettings st = (GeneralSettings)JsonConfig.create(GeneralSettings.class);
        this.downloadFolder.setText(((GeneralSettings)JsonConfig.create(GeneralSettings.class)).getDefaultDownloadFolder());
        this.autoCRC.setSelected(st.isHashCheckEnabled());
        this.restartFailedCRC.setSelected(st.isHashRetryEnabled());
        this.simpleContainer.setSelected(st.isAutoOpenContainerAfterDownload());
        this.remove.setValue(this.config.getCleanupAfterDownloadAction());
        this.ifFileExists.setValue(this.config.getIfFileExistsAction());
    }
}

