/*
 * Decompiled with CFR 0.152.
 */
package jd.gui.swing.jdgui.views.settings.panels.anticaptcha;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashSet;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import org.appwork.swing.exttable.ExtColumn;
import org.appwork.swing.exttable.ExtTableModel;
import org.appwork.swing.exttable.columns.ExtSpinnerColumn;
import org.appwork.swing.exttable.columns.ExtTextColumn;
import org.appwork.utils.formatter.TimeFormatter;
import org.appwork.utils.swing.EDTRunner;
import org.appwork.utils.swing.dialog.Dialog;
import org.jdownloader.actions.AppAction;
import org.jdownloader.captcha.v2.ChallengeResponseController;
import org.jdownloader.captcha.v2.SolverService;
import org.jdownloader.captcha.v2.solver.service.AbstractSolverService;
import org.jdownloader.gui.translate._GUI;

public class TimingTableModel
extends ExtTableModel<SolverService> {
    private final SolverService mySolver;
    private ExtSpinnerColumn<SolverService> timingColumn;

    public TimingTableModel(SolverService solver) {
        super("TimingTableModel");
        this.mySolver = solver;
        this.update();
    }

    private void update() {
        new EDTRunner(){

            protected void runInEDT() {
                ArrayList<SolverService> solverList = new ArrayList<SolverService>();
                HashSet<String> dupeMap = new HashSet<String>();
                dupeMap.add(TimingTableModel.this.mySolver.getID());
                for (SolverService es : ChallengeResponseController.getInstance().listServices()) {
                    if (!dupeMap.add(es.getID())) continue;
                    solverList.add(es);
                }
                TimingTableModel.this._fireTableStructureChanged(solverList, true);
            }
        };
    }

    protected void initColumns() {
        this.addColumn((ExtColumn)new ExtTextColumn<SolverService>(_GUI.T.SolverOrderTableModel_initColumns_service()){

            public boolean isSortable(SolverService obj) {
                return false;
            }

            protected Icon getIcon(SolverService value) {
                return value.getIcon(18);
            }

            public int getDefaultWidth() {
                return 150;
            }

            public boolean isEnabled(SolverService obj) {
                return true;
            }

            public String getStringValue(SolverService value) {
                return value.getName();
            }
        });
        this.addColumn((ExtColumn)new ExtTextColumn<SolverService>(_GUI.T.SolverOrderTableModel_initColumns_type_()){

            public boolean isSortable(SolverService obj) {
                return false;
            }

            public boolean isEnabled(SolverService obj) {
                return true;
            }

            public int getDefaultWidth() {
                return 300;
            }

            public String getStringValue(SolverService value) {
                return value.getType();
            }
        });
        this.timingColumn = new ExtSpinnerColumn<SolverService>(_GUI.T.SolverOrderTableModel_initColumns_startafter()){

            public boolean isHidable() {
                return false;
            }

            public boolean isSortable(SolverService obj) {
                return false;
            }

            public boolean isEditable(SolverService obj) {
                return true;
            }

            protected String getTooltipText(SolverService obj) {
                return null;
            }

            protected boolean isEditable(SolverService obj, boolean enabled) {
                return true;
            }

            public boolean isEnabled(SolverService obj) {
                return true;
            }

            public int getDefaultWidth() {
                return 120;
            }

            protected Number getNumber(SolverService value) {
                return TimingTableModel.this.getWaittimeBySolver(value);
            }

            protected void setNumberValue(Number value, SolverService object) {
                TimingTableModel.this.mySolver.setWaitFor(object.getID(), Integer.valueOf(value.intValue() * 1000));
                ArrayList waitLoop = AbstractSolverService.validateWaittimeQueue((SolverService)TimingTableModel.this.mySolver, (SolverService)ChallengeResponseController.getInstance().getServiceByID(object.getID()));
                if (waitLoop != null) {
                    StringBuilder sb = new StringBuilder();
                    for (int i = 0; i < waitLoop.size(); ++i) {
                        SolverService next;
                        SolverService entry = (SolverService)waitLoop.get(i);
                        SolverService solverService = next = i == waitLoop.size() - 1 ? null : (SolverService)waitLoop.get(i + 1);
                        if (next == null) continue;
                        sb.append(_GUI.T.TimingTableModel_initColumns_waitloop_print(entry.getName(), TimeFormatter.formatMilliSeconds((long)entry.getWaitForByID(next.getID()), (int)0), next.getName())).append("\r\n");
                    }
                    Dialog.getInstance().showErrorDialog(0, _GUI.T.TimingTableModel_initColumns_waitloop_title(), _GUI.T.TimingTableModel_initColumns_waitloop_warning(sb.toString()));
                    TimingTableModel.this.mySolver.setWaitFor(object.getID(), Integer.valueOf(0));
                }
                TimingTableModel.this.refreshSort();
            }

            public String getStringValue(SolverService value) {
                return this.getNumber(value).intValue() + " seconds";
            }
        };
        this.addColumn((ExtColumn)this.timingColumn);
        this.sortColumn = this.timingColumn;
    }

    public int getWaittimeBySolver(SolverService value) {
        Integer v = this.mySolver.getWaitForByID(value.getID());
        if (v == null || v < 0) {
            return 0;
        }
        return v / 1000;
    }

    public AbstractAction getResetAction() {
        return new AppAction(){
            {
                this.setName(_GUI.T.lit_reset());
                this.setIconKey("reset");
            }

            public void actionPerformed(ActionEvent e) {
                TimingTableModel.this.mySolver.getConfig().setWaitForMap(null);
                TimingTableModel.this.update();
            }
        };
    }
}

