/*
 * Decompiled with CFR 0.152.
 */
package jd.gui.swing.jdgui.views.settings.panels.linkgrabberfilter.test;

import java.awt.Color;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import jd.controlling.linkchecker.LinkChecker;
import jd.controlling.linkchecker.LinkCheckerHandler;
import jd.controlling.linkcrawler.CheckableLink;
import jd.controlling.linkcrawler.CrawledLink;
import jd.controlling.linkcrawler.LinkCrawler;
import jd.controlling.linkcrawler.LinkCrawlerFilter;
import jd.controlling.linkcrawler.LinkCrawlerHandler;
import jd.gui.swing.jdgui.JDGui;
import jd.gui.swing.jdgui.views.settings.panels.linkgrabberfilter.editdialog.ExceptionsRuleDialog;
import jd.gui.swing.jdgui.views.settings.panels.linkgrabberfilter.editdialog.FilterRuleDialog;
import jd.gui.swing.jdgui.views.settings.panels.linkgrabberfilter.test.ResultTable;
import jd.gui.swing.jdgui.views.settings.panels.linkgrabberfilter.test.ResultTableModel;
import org.appwork.scheduler.DelayedRunnable;
import org.appwork.swing.MigPanel;
import org.appwork.swing.components.circlebar.CircledProgressBar;
import org.appwork.swing.components.circlebar.IconPainter;
import org.appwork.swing.components.circlebar.ImagePainter;
import org.appwork.swing.exttable.ExtTableModel;
import org.appwork.utils.swing.EDTRunner;
import org.appwork.utils.swing.dialog.AbstractDialog;
import org.appwork.utils.swing.dialog.Dialog;
import org.appwork.utils.swing.dialog.DialogCanceledException;
import org.appwork.utils.swing.dialog.DialogClosedException;
import org.jdownloader.controlling.filter.LinkFilterController;
import org.jdownloader.controlling.filter.LinkgrabberFilterRule;
import org.jdownloader.controlling.packagizer.PackagizerController;
import org.jdownloader.gui.translate._GUI;
import org.jdownloader.images.AbstractIcon;

public class TestWaitDialog
extends AbstractDialog<List<CrawledLink>> {
    private CircledProgressBar progress;
    private Thread recThread;
    private String url;
    private List<CrawledLink> found;
    private JLabel lbl;
    private int filtered;
    private ExtTableModel<CrawledLink> model;
    private final DelayedRunnable delayer;
    private final LinkFilterController linkFilterController;
    private volatile PackagizerController packagizer;

    public TestWaitDialog(String string, String title, LinkFilterController controller) {
        super(8, title, null, null, _GUI.T.literally_close());
        this.url = string;
        this.linkFilterController = controller;
        this.delayer = new DelayedRunnable(200L, 1000L){

            public String getID() {
                return "TestWaitDialog";
            }

            public void delayedrun() {
                TestWaitDialog.this.update();
            }
        };
    }

    public TestWaitDialog(String string, LinkFilterController controller) {
        this(string, _GUI.T.TestWaitDialog_TestWaitDialog_title_(), controller);
    }

    protected List<CrawledLink> createReturnValue() {
        return this.found;
    }

    private void runTest(LinkCrawler lc, final LinkChecker<CrawledLink> lch) {
        System.out.println("TEST");
        if (this.linkFilterController != null) {
            lc.setFilter((LinkCrawlerFilter)this.linkFilterController);
        }
        this.found = new ArrayList<CrawledLink>();
        this.filtered = 0;
        lch.setLinkCheckHandler((LinkCheckerHandler)new LinkCheckerHandler<CrawledLink>(){

            public void linkCheckStopped() {
            }

            public void linkCheckStarted() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void linkCheckDone(CrawledLink link) {
                List list = TestWaitDialog.this.found;
                synchronized (list) {
                    if (TestWaitDialog.this.linkFilterController != null && TestWaitDialog.this.linkFilterController.dropByFileProperties(link)) {
                        TestWaitDialog.this.filtered++;
                    }
                    if (TestWaitDialog.this.packagizer != null) {
                        TestWaitDialog.this.packagizer.runByFile(link);
                    }
                    TestWaitDialog.this.found.add(link);
                }
                TestWaitDialog.this.delayer.run();
            }
        });
        lc.setHandler(new LinkCrawlerHandler(){

            public void linkCrawlerStopped() {
            }

            public void linkCrawlerStarted() {
            }

            public void handleFinalLink(CrawledLink link) {
                lch.check((CheckableLink)link);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void handleFilteredLink(CrawledLink link) {
                List list = TestWaitDialog.this.found;
                synchronized (list) {
                    TestWaitDialog.this.filtered++;
                    TestWaitDialog.this.found.add(link);
                }
                TestWaitDialog.this.delayer.run();
            }

            public void handleBrokenLink(CrawledLink link) {
            }

            public void handleUnHandledLink(CrawledLink link) {
            }
        });
        lc.crawl(this.url, null, true);
        lc.waitForCrawling();
        lch.waitForChecked();
    }

    protected void update() {
        new EDTRunner(){

            protected void runInEDT() {
                if (TestWaitDialog.this.lbl != null) {
                    if (TestWaitDialog.this.found.size() == 0) {
                        TestWaitDialog.this.lbl.setText(_GUI.T.TestWaitDialog_runInEDTnothing_found());
                    } else {
                        TestWaitDialog.this.lbl.setText(_GUI.T.TestWaitDialog_runInEDT_(TestWaitDialog.this.filtered, TestWaitDialog.this.found.size(), (double)(TestWaitDialog.this.filtered * 10000 / TestWaitDialog.this.found.size()) / 100.0));
                    }
                }
                TestWaitDialog.this.model._fireTableStructureChanged(new ArrayList(TestWaitDialog.this.found), true);
            }
        };
    }

    public List<CrawledLink> getFound() {
        return this.found;
    }

    private Component label(String lbl) {
        JLabel ret = new JLabel(lbl);
        ret.setEnabled(false);
        return ret;
    }

    public JComponent layoutDialogContent() {
        MigPanel p = new MigPanel("ins 0,wrap 3", "[][][grow,fill]", "[][][grow,fill]");
        this.progress = new CircledProgressBar();
        this.progress.setIndeterminate(true);
        this.progress.setValueClipPainter((IconPainter)new ImagePainter((Icon)new AbstractIcon("filter", 26), 1.0f));
        ((ImagePainter)this.progress.getValueClipPainter()).setBackground(Color.WHITE);
        ((ImagePainter)this.progress.getValueClipPainter()).setForeground(Color.GREEN);
        this.progress.setNonvalueClipPainter((IconPainter)new ImagePainter((Icon)new AbstractIcon("filter", 26), 0.5f));
        ((ImagePainter)this.progress.getNonvalueClipPainter()).setBackground(Color.WHITE);
        ((ImagePainter)this.progress.getNonvalueClipPainter()).setForeground(Color.GREEN);
        p.add((Component)this.progress, (Object)"height 40!,width 40!,spany 2");
        p.add(this.label(_GUI.T.TestWaitDialog_layoutDialogContent_testlink_()), (Object)"");
        p.add((Component)new JLabel(this.url), (Object)"");
        if (this.linkFilterController != null) {
            p.add(this.label(_GUI.T.TestWaitDialog_layoutDialogContent_filtered()));
            this.lbl = new JLabel();
            p.add((Component)this.lbl);
        } else {
            p.add(Box.createGlue(), (Object)"spanx");
        }
        this.model = this.createTableModel();
        p.add((Component)new JScrollPane((Component)((Object)new ResultTable(this, this.model))), (Object)"spanx,pushx,growx,newline");
        this.recThread = new Thread("LinkFilterTesting"){
            private final LinkCrawler lc;
            private LinkChecker<CrawledLink> lch;
            {
                this.lc = new LinkCrawler(true, true){

                    protected Long getDefaultAverageRuntime() {
                        return -100L;
                    }
                };
                this.lch = new LinkChecker();
            }

            @Override
            public void interrupt() {
                this.lch.stopChecking();
                this.lc.stopCrawling();
                super.interrupt();
            }

            @Override
            public void run() {
                try {
                    TestWaitDialog.this.runTest(this.lc, (LinkChecker<CrawledLink>)this.lch);
                }
                catch (Throwable throwable) {
                    new EDTRunner(){

                        protected void runInEDT() {
                            TestWaitDialog.this.progress.setIndeterminate(false);
                            TestWaitDialog.this.setTitle(_GUI.T.TestWaitDialog_TestWaitDialog_title_finished());
                        }
                    };
                    throw throwable;
                }
                new /* invalid duplicate definition of identical inner class */;
            }
        };
        this.recThread.start();
        return p;
    }

    protected ExtTableModel<CrawledLink> createTableModel() {
        return new ResultTableModel();
    }

    protected int getPreferredWidth() {
        return JDGui.getInstance().getMainFrame().getWidth();
    }

    protected boolean isResizable() {
        return true;
    }

    public void dispose() {
        super.dispose();
        this.recThread.interrupt();
    }

    public void edit(LinkgrabberFilterRule rule) {
        try {
            if (rule.isAccept()) {
                Dialog.getInstance().showDialog((AbstractDialog)new ExceptionsRuleDialog(rule));
            } else {
                Dialog.getInstance().showDialog((AbstractDialog)new FilterRuleDialog(rule));
            }
            this.linkFilterController.update();
        }
        catch (DialogClosedException e1) {
            e1.printStackTrace();
        }
        catch (DialogCanceledException e1) {
            e1.printStackTrace();
        }
    }

    public void setPackagizer(PackagizerController packagizer) {
        this.packagizer = packagizer;
    }
}

