/*
 * Decompiled with CFR 0.152.
 */
package jd.nutils.encoding;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.HashSet;
import jd.nutils.encoding.HTMLEntities;
import jd.parser.Regex;
import org.appwork.utils.StringUtils;
import org.appwork.utils.encoding.Base64;
import org.appwork.utils.logging2.extmanager.LoggerFactory;

public class Encoding {
    private static final char[] HEX = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public static String base16Encode(String input) {
        byte[] byteArray = input.getBytes();
        StringBuffer hexBuffer = new StringBuffer(byteArray.length * 2);
        for (byte element : byteArray) {
            for (int j = 1; j >= 0; --j) {
                hexBuffer.append(HEX[element >> j * 4 & 0xF]);
            }
        }
        return hexBuffer.toString();
    }

    public static byte[] base16Decode(String code) {
        while (code.length() % 2 > 0) {
            code = code + "0";
        }
        byte[] res = new byte[code.length() / 2];
        for (int i = 0; i < code.length(); i += 2) {
            res[i / 2] = (byte)Integer.parseInt(code.substring(i, i + 2), 16);
        }
        return res;
    }

    public static String Base64Decode(String base64) {
        if (base64 == null) {
            return null;
        }
        return Encoding.Base64Decode((CharSequence)base64).toString();
    }

    public static CharSequence Base64Decode(CharSequence base64) {
        if (base64 == null) {
            return null;
        }
        try {
            byte[] plain = Base64.decode((CharSequence)base64);
            if (plain == null || plain.length == 0) {
                plain = Base64.decodeFast((CharSequence)base64);
            }
            if (plain != null && plain.length > 0) {
                return new String(plain, "UTF-8");
            }
        }
        catch (ArrayIndexOutOfBoundsException plain) {
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return base64;
    }

    public static String Base64Encode(String plain) {
        String base64;
        if (plain == null) {
            return null;
        }
        try {
            base64 = new String(Base64.encodeToByte((byte[])plain.getBytes("UTF-8"), (boolean)false));
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            base64 = new String(Base64.encodeToByte((byte[])plain.getBytes(), (boolean)false));
        }
        return base64;
    }

    public static String cdataEncode(String str) {
        if (str == null) {
            return null;
        }
        str = str.replaceAll("<", "&lt;");
        str = str.replaceAll(">", "&gt;");
        return str;
    }

    public static String deepHtmlDecode(String string) {
        String decoded;
        String tmp = Encoding.htmlDecode(string);
        int i = 50;
        while (!tmp.equals(decoded = Encoding.htmlDecode(tmp))) {
            tmp = decoded;
            if (i-- > 0) continue;
            System.err.println("Max Decodeingloop 50 reached!!!");
            return tmp;
        }
        return tmp;
    }

    public static String filterString(String str, String filter) {
        if (str == null || filter == null) {
            return "";
        }
        byte[] org = str.getBytes();
        byte[] mask = filter.getBytes();
        byte[] ret = new byte[org.length];
        int count = 0;
        block0: for (int i = 0; i < org.length; ++i) {
            byte letter = org[i];
            for (byte element : mask) {
                if (letter != element) continue;
                ret[count] = letter;
                ++count;
                continue block0;
            }
        }
        return new String(ret).trim();
    }

    public static String htmlDecode(String str) {
        if (str == null) {
            return null;
        }
        try {
            str = URLDecoder.decode(str, "UTF-8");
        }
        catch (Throwable e) {
            LoggerFactory.getDefaultLogger().log(e);
        }
        return Encoding.htmlOnlyDecode(str);
    }

    public static String htmlOnlyDecode(String str) {
        return Encoding.htmlOnlyDecode(str, true);
    }

    public static String htmlOnlyDecode(String str, boolean trim) {
        if (str == null) {
            return null;
        }
        str = HTMLEntities.unhtmlentities(str, trim);
        str = HTMLEntities.unhtmlAmpersand(str);
        str = HTMLEntities.unhtmlAngleBrackets(str);
        str = HTMLEntities.unhtmlDoubleQuotes(str);
        str = HTMLEntities.unhtmlQuotes(str, trim);
        str = HTMLEntities.unhtmlSingleQuotes(str);
        return str;
    }

    public static boolean isUrlCoded(String str) {
        if (str == null) {
            return false;
        }
        try {
            return URLDecoder.decode(str, "UTF-8").length() != str.length();
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isHtmlEntityCoded(String str) {
        if (str == null) {
            return false;
        }
        try {
            return Encoding.htmlOnlyDecode(str).length() != str.length();
        }
        catch (Exception e) {
            return false;
        }
    }

    public static String unicodeDecode(String input) {
        return Encoding.unicodeDecode(input, false);
    }

    public static CharSequence unicodeDecode(CharSequence input) {
        return Encoding.unicodeDecode(input, false);
    }

    public static String unicodeDecode(String input, boolean ignoreInvalidSequences) {
        CharSequence ret = Encoding.unicodeDecode((CharSequence)input, ignoreInvalidSequences);
        if (ret != null) {
            return ((Object)ret).toString();
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    public static CharSequence unicodeDecode(CharSequence input, boolean ignoreInvalidSequences) {
        if (input == null) {
            return null;
        }
        s = input;
        regex = "(&#x([0-9a-f]{4});)";
        rmHtml = new Regex((Object)s, "(&#x([0-9a-f]{4});)").getColumn(0);
        if (rmHtml != null && rmHtml.length != 0) {
            pre = s.toString();
            replace = false;
            dupe = new HashSet<String>();
            for (String htmlrm : rmHtml) {
                if (!dupe.add(htmlrm) || (rm = new Regex(htmlrm, "(&#x([0-9a-f]{4});)").getRow(0))[1] == null) continue;
                pre = pre.replaceAll(rm[0], "\\\\u" + rm[1]);
                replace = true;
            }
            if (replace) {
                s = pre;
            }
        }
        sb = new StringBuilder();
        decode = new StringBuilder();
        block10: for (i = 0; i < s.length(); ++i) {
            ch = s.charAt(i);
            if (s.length() == i + 1) ** GOTO lbl-1000
            switch (ch) {
                case '%': 
                case '\\': {
                    escape = ch;
                    encoding = s.charAt(++i);
                    switch (encoding) {
                        case 'u': {
                            length = 4;
                            break;
                        }
                        case 'x': {
                            length = 2;
                            break;
                        }
                        default: {
                            sb.append(escape);
                            sb.append(encoding);
                            continue block10;
                        }
                    }
                    decode.setLength(0);
                    ii = ++i + length;
                    try {
                        while (i < ii) {
                            decode_ch = s.charAt(i);
                            if (!ignoreInvalidSequences) {
                                decode.append(decode_ch);
                            } else if (decode_ch >= '0' && decode_ch <= '9') {
                                decode.append(decode_ch);
                            } else if (decode_ch >= 'a' && decode_ch <= 'f') {
                                decode.append(decode_ch);
                            } else if (decode_ch >= 'A' && decode_ch <= 'F') {
                                decode.append(decode_ch);
                            } else {
                                sb.append(escape);
                                sb.append(encoding);
                                sb.append((CharSequence)decode);
                                --i;
                                continue block10;
                            }
                            ++i;
                        }
                    }
                    catch (StringIndexOutOfBoundsException e) {
                        if (ignoreInvalidSequences) {
                            sb.append(escape);
                            sb.append(encoding);
                            sb.append((CharSequence)decode);
                            return sb;
                        }
                        throw e;
                    }
                    --i;
                    sb.append((char)Encoding.parseLong(decode));
                    continue block10;
                }
                default: lbl-1000:
                // 2 sources

                {
                    sb.append(ch);
                }
            }
        }
        return sb;
    }

    private static long parseLong(CharSequence s) throws NumberFormatException {
        int radix = 16;
        long result = 0L;
        int i = 0;
        int len = s.length();
        long limit = -9223372036854775807L;
        if (len > 0) {
            long multmin = -576460752303423487L;
            while (i < len) {
                int digit;
                if ((digit = Character.digit(s.charAt(i++), 16)) < 0) {
                    throw new NumberFormatException("For input string: \"" + s + "\"");
                }
                if (result < -576460752303423487L) {
                    throw new NumberFormatException("For input string: \"" + s + "\"");
                }
                if ((result *= 16L) < -9223372036854775807L + (long)digit) {
                    throw new NumberFormatException("For input string: \"" + s + "\"");
                }
                result -= (long)digit;
            }
        } else {
            throw new NumberFormatException("For input string: \"" + s + "\"");
        }
        return -result;
    }

    @Deprecated
    public static String urlDecode(String urlcoded, boolean isUrl) {
        if (urlcoded == null) {
            return null;
        }
        if (isUrl) {
            boolean seemsFileURL;
            boolean seemsValidURL;
            boolean bl = seemsValidURL = urlcoded.startsWith("http://") || urlcoded.startsWith("https://");
            if (!seemsValidURL) {
                urlcoded = urlcoded.replaceAll("%2F", "/");
                urlcoded = urlcoded.replaceAll("%3A", ":");
                urlcoded = urlcoded.replaceAll("%3F", "?");
                urlcoded = urlcoded.replaceAll("%3D", "=");
                urlcoded = urlcoded.replaceAll("%26", "&");
                urlcoded = urlcoded.replaceAll("%23", "#");
            }
            if (seemsFileURL = StringUtils.startsWithCaseInsensitive((String)urlcoded, (String)"file:/")) {
                urlcoded = urlcoded.replaceAll("%20", " ");
            }
        } else {
            try {
                urlcoded = URLDecoder.decode(urlcoded, "UTF-8");
            }
            catch (Exception e) {
                LoggerFactory.getDefaultLogger().log((Throwable)e);
            }
        }
        return urlcoded;
    }

    public static String urlEncode(String str) {
        if (str != null) {
            try {
                return URLEncoder.encode(str, "UTF-8");
            }
            catch (Exception e) {
                LoggerFactory.getDefaultLogger().log((Throwable)e);
            }
        }
        return str;
    }

    @Deprecated
    public static String urlEncode_light(String url) {
        return (String)Encoding.urlEncodeCharSequence_light(url);
    }

    @Deprecated
    public static CharSequence urlEncodeCharSequence_light(CharSequence url) {
        if (url == null) {
            return null;
        }
        boolean urlEncodeLight = false;
        for (int i = 0; i < url.length(); ++i) {
            char ch = url.charAt(i);
            if (ch == ' ') {
                urlEncodeLight = true;
                break;
            }
            if (ch >= '!' && ch <= '&' || ch >= '(' && ch <= ';' || ch == '=' || ch >= '?' && ch <= '_' || ch >= 'a' && ch <= '~') continue;
            urlEncodeLight = true;
            break;
        }
        if (urlEncodeLight) {
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < url.length(); ++i) {
                char ch = url.charAt(i);
                if (ch == ' ') {
                    sb.append("%20");
                    continue;
                }
                if (ch >= '!' && ch <= '&') {
                    sb.append(ch);
                    continue;
                }
                if (ch >= '(' && ch <= ';') {
                    sb.append(ch);
                    continue;
                }
                if (ch == '=') {
                    sb.append(ch);
                    continue;
                }
                if (ch >= '?' && ch <= '_') {
                    sb.append(ch);
                    continue;
                }
                if (ch >= 'a' && ch <= '~') {
                    sb.append(ch);
                    continue;
                }
                try {
                    sb.append(URLEncoder.encode(String.valueOf(ch), "UTF-8"));
                    continue;
                }
                catch (Exception e) {
                    LoggerFactory.getDefaultLogger().log((Throwable)e);
                    break;
                }
            }
            return sb.toString();
        }
        return url;
    }

    public static String UTF8Decode(String str) {
        return Encoding.UTF8Decode(str, null);
    }

    public static String UTF8Decode(String str, String sourceEncoding) {
        if (str == null) {
            return null;
        }
        try {
            if (sourceEncoding != null) {
                return new String(str.getBytes(sourceEncoding), "UTF-8");
            }
            return new String(str.getBytes(), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            LoggerFactory.getDefaultLogger().log((Throwable)e);
            return str;
        }
    }

    public static String UTF8Encode(String str) {
        try {
            return new String(str.getBytes("UTF-8"));
        }
        catch (Exception e) {
            LoggerFactory.getDefaultLogger().log((Throwable)e);
            return null;
        }
    }

    public static String atbashDecode(String crypted) {
        if (crypted == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (int index = 0; index < crypted.length(); ++index) {
            char ch = crypted.charAt(index);
            if (ch >= 'a' && ch <= 'z') {
                sb.append((char)(122 - (ch - 97)));
                continue;
            }
            if (ch >= 'A' && ch <= 'Z') {
                sb.append((char)(90 - (ch - 65)));
                continue;
            }
            if (ch >= '0' && ch <= '9') {
                sb.append(ch);
                continue;
            }
            if (ch == ':') {
                sb.append(':');
                continue;
            }
            if (ch == '$') {
                sb.append('/');
                continue;
            }
            if (ch == '+') {
                sb.append('.');
                continue;
            }
            sb.append(ch);
        }
        return sb.toString();
    }

    public static String atbashEncode(String crypted) {
        if (crypted == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (int index = 0; index < crypted.length(); ++index) {
            char ch = crypted.charAt(index);
            if (ch >= 'a' && ch <= 'z') {
                sb.append((char)(97 - (ch - 122)));
                continue;
            }
            if (ch >= 'A' && ch <= 'Z') {
                sb.append((char)(65 - (ch - 90)));
                continue;
            }
            if (ch >= '0' && ch <= '9') {
                sb.append(ch);
                continue;
            }
            if (ch == ':') {
                sb.append(':');
                continue;
            }
            if (ch == '/') {
                sb.append('$');
                continue;
            }
            if (ch == '.') {
                sb.append('+');
                continue;
            }
            sb.append(ch);
        }
        return sb.toString();
    }
}

