/*
 * Decompiled with CFR 0.152.
 */
package jd.http;

import java.io.IOException;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Pattern;
import jd.http.Authentication;
import jd.http.Browser;
import jd.http.ClonedProxy;
import jd.http.Cookie;
import jd.http.Cookies;
import jd.http.HTTPConnectionFactory;
import jd.http.RequestHeader;
import jd.http.URLConnectionAdapter;
import jd.http.URLConnectionAdapterDirectImpl;
import org.appwork.exceptions.ThrowUncheckedException;
import org.appwork.exceptions.WTFException;
import org.appwork.utils.Application;
import org.appwork.utils.IO;
import org.appwork.utils.Regex;
import org.appwork.utils.StringUtils;
import org.appwork.utils.Time;
import org.appwork.utils.net.HTTPHeader;
import org.appwork.utils.net.URLHelper;
import org.appwork.utils.net.httpconnection.HTTPConnection;
import org.appwork.utils.net.httpconnection.HTTPConnectionImpl;
import org.appwork.utils.net.httpconnection.HTTPConnectionUtils;
import org.appwork.utils.net.httpconnection.HTTPProxy;
import org.appwork.utils.net.httpconnection.KeepAliveSocketStreamException;
import org.appwork.utils.net.httpconnection.SSLSocketStreamOptions;
import org.appwork.utils.net.httpconnection.SSLSocketStreamOptionsModifier;
import org.appwork.utils.os.CrossSystem;
import org.appwork.utils.parser.UrlQuery;

public abstract class Request {
    private Request redirectOrigin = null;
    protected int connectTimeout = 30000;
    protected int readTimeout = 60000;
    protected Cookies cookies = null;
    protected RequestHeader headers;
    protected String htmlCode;
    protected URLConnectionAdapter httpConnection;
    protected long readTime = -1L;
    protected boolean requested = false;
    protected int readLimit = 0x100000;
    protected HTTPProxy proxy;
    protected URL url;
    protected String customCharset = null;
    protected byte[] responseBytes = null;
    protected boolean contentDecoded = true;
    protected boolean keepByteArray = false;
    protected Boolean sslTrustALL = null;
    protected long requestID = -1L;
    protected long browserID = -1L;
    protected long browserParentID = -1L;
    protected HTTPConnectionUtils.IPVERSION ipVersion = null;
    protected InetAddress customInetAddress = null;
    protected Authentication authentication = null;
    protected String caller = null;
    protected SSLSocketStreamOptionsModifier sslSocketStreamOptionsModifier = null;
    protected static final String DEFAULTACCEPTHEADER = "text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8";
    protected String location = null;

    public static String getCookieString(Cookies cookies, URL url) {
        if (cookies != null && !cookies.isEmpty()) {
            boolean secure = "https".equalsIgnoreCase(url.getProtocol());
            StringBuilder buffer = new StringBuilder();
            for (Cookie cookie : cookies.getCookies()) {
                if (cookie.isExpired() || !secure && Boolean.TRUE.equals(cookie.isSecure())) continue;
                if (buffer.length() > 0) {
                    buffer.append("; ");
                }
                buffer.append(cookie.getKey());
                buffer.append("=");
                buffer.append(cookie.getValue());
            }
            return buffer.toString();
        }
        return null;
    }

    public Request getRedirectOrigin() {
        return this.redirectOrigin;
    }

    public void setRedirectOrigin(Request redirectOrigin) {
        if (redirectOrigin != this) {
            this.redirectOrigin = redirectOrigin;
        }
    }

    @Deprecated
    public static UrlQuery parseQuery(String query) throws MalformedURLException {
        return UrlQuery.parse((String)query);
    }

    /*
     * Exception decompiling
     */
    public static byte[] read(URLConnectionAdapter con, int readLimit) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 5[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public InetAddress getCustomInetAddress() {
        return this.customInetAddress;
    }

    public void setCustomInetAddress(InetAddress customInetAddress) {
        this.customInetAddress = customInetAddress;
    }

    public HTTPConnectionUtils.IPVERSION getIPVersion() {
        return this.ipVersion;
    }

    public void setIPVersion(HTTPConnectionUtils.IPVERSION tcpVersion) {
        this.ipVersion = tcpVersion;
    }

    protected long getBrowserParentID() {
        return this.browserParentID;
    }

    protected void setBrowserParentID(long browserParentID) {
        this.browserParentID = browserParentID;
    }

    public Authentication getAuthentication() {
        return this.authentication;
    }

    protected void setAuthentication(Authentication authentication) {
        this.authentication = authentication;
    }

    protected long getBrowserID() {
        return this.browserID;
    }

    public long getRequestID() {
        return this.requestID;
    }

    protected void setRequestID(long requestID) {
        this.requestID = requestID;
    }

    public Boolean isSSLTrustALLSet() {
        return this.sslTrustALL;
    }

    public void setSSLTrustALL(Boolean sslTrustALL) {
        this.sslTrustALL = sslTrustALL;
    }

    protected Request(Request cloneRequest) {
        this.setURL(cloneRequest.getURL());
        this.setCustomCharset(cloneRequest.getCustomCharset());
        this.setReadTimeout(cloneRequest.getReadTimeout());
        this.setConnectTimeout(cloneRequest.getConnectTimeout());
        this.setReadLimit(cloneRequest.getReadLimit());
        this.setProxy(cloneRequest.getProxy());
        this.setContentDecoded(cloneRequest.isContentDecodedSet());
        this.setAuthentication(cloneRequest.getAuthentication());
        if (cloneRequest.getHeaders() != null) {
            RequestHeader headers = new RequestHeader(cloneRequest.getHeaders());
            headers.remove("Referer");
            this.setHeaders(headers);
        } else {
            this.setHeaders(this.getDefaultRequestHeader(this.getURL()));
        }
        this.setRedirectOrigin(cloneRequest.getRedirectOrigin());
    }

    public Request(URL url) throws IOException {
        this.setURL(url);
        this.setHeaders(this.getDefaultRequestHeader(this.getURL()));
    }

    public Request(String url) throws IOException {
        this(URLHelper.createURL((String)url));
    }

    public Request(URLConnectionAdapter con) throws IOException {
        this.httpConnection = con;
        if (con.getRequest() != null) {
            this.setURL(con.getRequest().getURL());
        } else {
            this.setURL(con.getURL());
        }
        this.requested = true;
        this.getCookies().add(Cookies.parseSetCookies(this));
    }

    public Request cloneRequest() {
        throw new WTFException("Not Implemented");
    }

    public HTTPConnection.RequestMethod getRequestMethod() {
        return null;
    }

    protected String getCaller() {
        return this.caller;
    }

    protected Request connect(Browser br) throws IOException {
        if (this.requestID == -1L && br != null) {
            this.browserID = br.getBrowserID();
            this.requestID = br.getNextRequestID();
            this.browserParentID = br.getBrowserParentID();
        }
        if (this.getIPVersion() == null) {
            this.setIPVersion(br.getIPVersion());
        }
        if (this.caller == null) {
            try {
                StackTraceElement[] stackTrace;
                StringBuilder sb = new StringBuilder();
                for (StackTraceElement stack : stackTrace = new Exception().getStackTrace()) {
                    if ("jd.http.Request".equals(stack.getClassName()) || "jd.http.Browser".equals(stack.getClassName())) continue;
                    if (sb.length() > 0) {
                        sb.append("\r\n");
                    }
                    sb.append(stack.toString());
                }
                if (sb.length() > 0) {
                    this.caller = sb.toString();
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return this.connect();
    }

    protected Request connect() throws IOException {
        while (true) {
            try {
                this.disconnect();
                this.openConnection();
                this.postRequest();
                this.httpConnection.finalizeConnect();
                try {
                    this.getCookies().add(Cookies.parseSetCookies(this));
                }
                catch (NullPointerException e) {
                    throw new IOException("Malformed url?", e);
                }
                Request request = this;
                return request;
            }
            catch (KeepAliveSocketStreamException keepAliveSocketStreamException) {
                continue;
            }
            break;
        }
        finally {
            this.requested = true;
        }
    }

    public void disconnect() {
        try {
            URLConnectionAdapter lhttpConnection = this.getHttpConnection();
            if (lhttpConnection != null) {
                lhttpConnection.disconnect();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    protected SSLSocketStreamOptions getSSLSocketStreamOptions(SSLSocketStreamOptions sslSocketStreamOptions, HTTPConnection connection) {
        SSLSocketStreamOptions ret;
        SSLSocketStreamOptionsModifier sslSocketStreamOptionsModifier = this.sslSocketStreamOptionsModifier;
        if (sslSocketStreamOptionsModifier != null && (ret = sslSocketStreamOptionsModifier.modify(sslSocketStreamOptions, connection)) != null) {
            return ret;
        }
        return sslSocketStreamOptions;
    }

    protected void setSSLSocketStreamOptions(SSLSocketStreamOptionsModifier sslSocketStreamOptionsModifier) {
        this.sslSocketStreamOptionsModifier = sslSocketStreamOptionsModifier;
    }

    protected boolean requireOutputStream() {
        return false;
    }

    public String getCharsetFromMetaTags() {
        byte[] responseBytes = this.getResponseBytes();
        String requestContent = this.htmlCode;
        if (StringUtils.isEmpty((String)requestContent) && responseBytes != null && responseBytes.length > 0) {
            requestContent = new String(responseBytes);
        }
        if (StringUtils.isEmpty((String)requestContent)) {
            return null;
        }
        String charSetFromMetaTag = new Regex(requestContent, "http-equiv\\s*=\\s*(\"|'|)Content-Type(\\1)[^<>]+content\\s*=\\s*(\"|')?[^\"]+charset\\s*=\\s*([^\"<>]+)").getMatch(3);
        if (charSetFromMetaTag == null) {
            charSetFromMetaTag = new Regex(requestContent, "<meta[^>]*charset\\s*=\\s*\"([^\"]+)\"").getMatch(0);
        }
        if (charSetFromMetaTag != null) {
            return charSetFromMetaTag;
        }
        String charSetFromXmlTag = new Regex(requestContent, "<\\?xml[^>]*version[^>]*encoding\\s*=\\s*\"([^>]*?)\"[^>]*\\?>").getMatch(0);
        return charSetFromXmlTag;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public long getContentLength() {
        URLConnectionAdapter lhttpConnection = this.getHttpConnection();
        return lhttpConnection == null ? -1L : lhttpConnection.getLongContentLength();
    }

    public Cookies getCookies() {
        if (this.cookies == null) {
            this.cookies = new Cookies();
        }
        return this.cookies;
    }

    protected boolean isKeepAlivePermitted(URLConnectionAdapter con) {
        return con != null;
    }

    public String getCookieString() {
        return Request.getCookieString(this.cookies, this.getURL());
    }

    public String getCustomCharset() {
        return this.customCharset;
    }

    protected boolean isBrotliAcceptEncodingEnabled() {
        return true;
    }

    protected RequestHeader getDefaultRequestHeader(URL url) {
        RequestHeader headers = new RequestHeader();
        headers.put("User-Agent", this.getSuggestedUserAgent());
        headers.put("Accept", this.getSuggestedAcceptHeader(url));
        headers.put("Accept-Language", "de,en-gb;q=0.7,en;q=0.3");
        if (Application.getJavaVersion() >= Application.JAVA16) {
            if (this.isBrotliAcceptEncodingEnabled()) {
                headers.put("Accept-Encoding", "gzip, deflate, br");
            } else {
                headers.put("Accept-Encoding", "gzip, deflate");
            }
        } else {
            headers.put("Accept-Encoding", "gzip");
        }
        headers.put("Cache-Control", "no-cache");
        return headers;
    }

    protected String getSuggestedUserAgent() {
        String osString;
        CrossSystem.OperatingSystem os = CrossSystem.getOS();
        String archString = CrossSystem.getARCHString();
        switch (os) {
            case FREEBSD: {
                osString = "FreeBSD";
                break;
            }
            case DRAGONFLYBSD: {
                osString = "DragonFly";
                break;
            }
            case OPENBSD: {
                osString = "OpenBSD";
                break;
            }
            case NETBSD: {
                osString = "NetBSD";
                break;
            }
            case LINUX: {
                osString = "Linux";
                break;
            }
            default: {
                osString = null;
            }
        }
        String firefoxRevision = "76.0";
        if (archString != null && osString != null && !new Regex(archString, "(arm|aarch)").matches()) {
            return "Mozilla/5.0 (X11; Ubuntu; " + osString.trim() + " " + archString.trim() + "; rv:" + "76.0" + ") Gecko/20100101 Firefox/" + "76.0";
        }
        switch (os.getFamily()) {
            case WINDOWS: {
                if (os.isMinimum(CrossSystem.OperatingSystem.WINDOWS_10)) {
                    return "Mozilla/5.0 (Windows NT 10.0; WOW64; rv:76.0) Gecko/20100101 Firefox/76.0";
                }
                if (os.isMinimum(CrossSystem.OperatingSystem.WINDOWS_8)) {
                    return "Mozilla/5.0 (Windows NT 6.3; WOW64; rv:76.0) Gecko/20100101 Firefox/76.0";
                }
                if (os.isMinimum(CrossSystem.OperatingSystem.WINDOWS_7)) {
                    return "Mozilla/5.0 (Windows NT 6.1; WOW64; rv:76.0) Gecko/20100101 Firefox/76.0";
                }
                return "Mozilla/5.0 (Windows NT 6.0; WOW64; rv:76.0) Gecko/20100101 Firefox/76.0";
            }
            case MAC: {
                String macVersion = new Regex(System.getProperty("os.version"), "(\\d+\\.\\d+)").getMatch(0);
                if (macVersion != null) {
                    return "Mozilla/5.0 (Macintosh; Intel Mac OS X " + macVersion + "; rv:" + "76.0" + ") Gecko/20100101 Firefox/" + "76.0";
                }
                return "Mozilla/5.0 (Macintosh; Intel Mac OS X 10.10; rv:76.0) Gecko/20100101 Firefox/76.0";
            }
        }
        if (CrossSystem.is64BitArch()) {
            return "Mozilla/5.0 (X11; Ubuntu; Linux x86_64; rv:76.0) Gecko/20100101 Firefox/76.0";
        }
        return "Mozilla/5.0 (X11; Ubuntu; Linux i686; rv:76.0) Gecko/20100101 Firefox/76.0";
    }

    protected String getSuggestedAcceptHeader(URL url) {
        if (url != null && url.getPath() != null) {
            String path = url.getPath();
            if (path.matches(".+jpe?g$")) {
                return "image/jpeg,image/*;q=0.8,*/*;q=0.5";
            }
            if (path.matches(".+png$")) {
                return "image/png,image/*;q=0.8,*/*;q=0.5";
            }
            if (path.matches(".+gif$")) {
                return "image/gif,image/*;q=0.8,*/*;q=0.5";
            }
            if (path.matches(".+tiff?$")) {
                return "image/tiff,image/*;q=0.8,*/*;q=0.5";
            }
            if (path.matches(".+(mp4|mkv|avi|m3u8)$")) {
                return "video/*;q=0.9,*/*;q=0.5";
            }
        }
        return DEFAULTACCEPTHEADER;
    }

    public RequestHeader getHeaders() {
        return this.headers;
    }

    public String getHtmlCode(boolean throwExceptionOnWrongContentType) {
        try {
            return this.getHtmlCode();
        }
        catch (NoHTMLContentException e) {
            if (throwExceptionOnWrongContentType) {
                throw e;
            }
            return null;
        }
    }

    /*
     * Loose catch block
     */
    public String getHtmlCode() {
        byte[] responseBytes = this.getResponseBytes();
        if (this.htmlCode == null && responseBytes != null) {
            IO.BOM bom2222222222;
            String contentType = this.httpConnection != null ? this.httpConnection.getContentType() : null;
            if (contentType != null && Pattern.compile("images?/\\w*", 34).matcher(contentType).matches()) {
                throw new NoHTMLContentException("Content-Type: " + contentType);
            }
            String useCS = this.customCharset;
            if (StringUtils.isEmpty((String)useCS)) {
                useCS = this.httpConnection.getCharset();
            }
            if (StringUtils.isEmpty((String)useCS) && contentType != null) {
                if (contentType.matches("(?i)application/json")) {
                    useCS = "UTF-8";
                } else if (contentType.matches("(?i)application/javascript")) {
                    useCS = "UTF-8";
                }
            }
            if (StringUtils.isEmpty((String)useCS)) {
                useCS = this.getCharsetFromMetaTags();
            }
            if (StringUtils.isEmpty((String)useCS) && (bom2222222222 = IO.BOM.get((byte[])responseBytes)) != null) {
                useCS = bom2222222222.getCharSet().name();
            }
            try {
                block16: {
                    if (useCS == null) break block16;
                    try {
                        return this.readHtmlCode(responseBytes, useCS.toUpperCase(Locale.ENGLISH));
                    }
                    catch (IOException bom2222222222) {
                        // empty catch block
                    }
                }
                return this.readHtmlCode(responseBytes, "ISO-8859-1");
            }
            catch (IOException e) {
                System.out.println("could neither charset: " + useCS + " nor default charset");
                return this.readHtmlCode(responseBytes, null);
                {
                    catch (IOException e2) {
                        this.httpConnection.setCharset(null);
                    }
                }
            }
        }
        return this.htmlCode;
    }

    protected String readHtmlCode(byte[] responseBytes, String charSet) throws IOException {
        this.htmlCode = charSet == null ? new String(responseBytes) : new String(responseBytes, charSet);
        this.httpConnection.setCharset(charSet);
        if (!this.isKeepByteArray()) {
            this.responseBytes = null;
        }
        return this.htmlCode;
    }

    public boolean isLoaded() {
        return this.isRequested() && (this.getResponseBytes() != null || this.htmlCode != null);
    }

    protected String getHTMLSource() {
        if (!this.isRequested()) {
            return "Request not sent yet";
        }
        String htmlCode = null;
        try {
            htmlCode = this.getHtmlCode();
            if (StringUtils.isEmpty((String)htmlCode)) {
                String location = this.getLocation();
                if (location != null) {
                    return "Not HTML Code. Redirect to: " + location;
                }
                return "No htmlCode read";
            }
        }
        catch (Throwable e) {
            return "NOTEXT: " + e.getMessage();
        }
        return htmlCode;
    }

    public URLConnectionAdapter getHttpConnection() {
        return this.httpConnection;
    }

    protected String getLocationHeader(URLConnectionAdapter httpConnection) {
        if (httpConnection != null) {
            int responseCode = httpConnection.getResponseCode();
            switch (responseCode) {
                case 201: 
                case 301: 
                case 302: 
                case 303: 
                case 305: 
                case 307: 
                case 308: {
                    return httpConnection.getHeaderField("Location");
                }
            }
            return null;
        }
        return null;
    }

    public String getHTMLRefresh() {
        String refresh = new Regex(this.getHtmlCode(false), "<meta[^>]*http-equiv\\s*=\\s*(\"|')refresh\\1[^>]*content\\s*=\\s*(\"|')\\d+\\s*;\\s*URL\\s*=[\\s'\"]*(https?://[^\"']+)").getMatch(2);
        return refresh;
    }

    public String getLocation() {
        String location = this.location;
        if (location == null) {
            URLConnectionAdapter lhttpConnection = this.getHttpConnection();
            if (lhttpConnection != null) {
                String locationHeader = this.getLocationHeader(lhttpConnection);
                if (locationHeader == null) {
                    String refresh = lhttpConnection.getHeaderField("refresh");
                    if (refresh != null) {
                        String locationRefresh = new Regex(refresh, "url=(.+);?").getMatch(0);
                        this.location = Request.getLocation(locationRefresh, this);
                        return this.location;
                    }
                    this.location = "";
                    return null;
                }
                this.location = Request.getLocation(locationHeader, this);
                return this.location;
            }
            return null;
        }
        if (location.length() == 0) {
            return null;
        }
        return location;
    }

    public static String getLocation(String location, Request request) {
        if (location == null) {
            return null;
        }
        try {
            return URLHelper.fixPathTraversal((URL)URLHelper.createURL((String)location)).toString();
        }
        catch (Exception e) {
            if (request != null) {
                try {
                    return URLHelper.parseLocation((URL)request.getURL(), (String)location);
                }
                catch (Throwable wtf) {
                    return null;
                }
            }
            return null;
        }
    }

    public HTTPProxy getProxy() {
        return this.proxy;
    }

    public int getReadLimit() {
        return this.readLimit;
    }

    public long getReadTime() {
        return this.readTime;
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public long getRequestTime() {
        URLConnectionAdapter lhttpConnection = this.getHttpConnection();
        return lhttpConnection == null ? -1L : lhttpConnection.getRequestTime();
    }

    public byte[] getResponseBytes() {
        return this.responseBytes;
    }

    public String getResponseHeader(String key) {
        URLConnectionAdapter lhttpConnection = this.getHttpConnection();
        return lhttpConnection == null ? null : lhttpConnection.getHeaderField(key);
    }

    public List<String> getResponseHeaders(String key) {
        URLConnectionAdapter lhttpConnection = this.getHttpConnection();
        return lhttpConnection == null ? null : lhttpConnection.getHeaderFields(key);
    }

    public Map<String, List<String>> getResponseHeaders() {
        URLConnectionAdapter lhttpConnection = this.getHttpConnection();
        return lhttpConnection == null ? null : lhttpConnection.getHeaderFields();
    }

    public String getUrl() {
        return this.getUrl(false);
    }

    public String getUrl(boolean withUserInfo) {
        try {
            return URLHelper.getURL((URL)this.getURL(withUserInfo), (boolean)true, (boolean)withUserInfo, (boolean)false).toString();
        }
        catch (IOException e) {
            ThrowUncheckedException.throwUncheckedException((Throwable)e);
            return null;
        }
    }

    public URL getURL() {
        return this.getURL(false);
    }

    public URL getURL(boolean withUserInfo) {
        Authentication authentication;
        Authentication authentication2 = authentication = withUserInfo ? this.getAuthentication() : null;
        if (authentication != null) {
            try {
                return new URL(authentication.getURLWithUserInfo(this.url));
            }
            catch (IOException e) {
                ThrowUncheckedException.throwUncheckedException((Throwable)e);
                return null;
            }
        }
        return this.url;
    }

    protected boolean hasCookies() {
        return this.cookies != null && !this.cookies.isEmpty();
    }

    public boolean isContentDecoded() {
        URLConnectionAdapter lhttpConnection = this.getHttpConnection();
        return lhttpConnection == null ? this.isContentDecodedSet() : lhttpConnection.isContentDecoded();
    }

    public Boolean isSSLTrustALL() {
        URLConnectionAdapter lhttpConnection = this.getHttpConnection();
        return lhttpConnection == null ? this.isSSLTrustALLSet().booleanValue() : lhttpConnection.isSSLTrustALL();
    }

    public boolean isContentDecodedSet() {
        return this.contentDecoded;
    }

    public boolean isKeepByteArray() {
        return this.keepByteArray;
    }

    public boolean isRequested() {
        return this.requested;
    }

    protected boolean sendHTTPHeader(HTTPHeader header) {
        return header != null && !StringUtils.isEmpty((String)header.getKey()) && !StringUtils.isEmpty((String)header.getValue());
    }

    private void openConnection() throws IOException {
        String cookieString;
        String connectionRequest;
        RequestHeader headers;
        this.httpConnection = HTTPConnectionFactory.createHTTPConnection(URLHelper.getURL((URL)this.getURL(), (boolean)true, (boolean)false, (boolean)false), this.getProxy());
        this.httpConnection.setLegacyConnectEnabled(false);
        this.httpConnection.setRequest(this);
        this.httpConnection.setIPVersion(this.getIPVersion());
        this.httpConnection.setReadTimeout(this.getReadTimeout());
        this.httpConnection.setConnectTimeout(this.getConnectTimeout());
        this.httpConnection.setContentDecoded(this.isContentDecodedSet());
        Boolean isSSLTrustALL = this.isSSLTrustALLSet();
        if (isSSLTrustALL != null) {
            this.httpConnection.setSSLTrustALL(isSSLTrustALL);
        }
        if ((headers = this.getHeaders()) != null) {
            for (HTTPHeader header : headers) {
                if (!this.sendHTTPHeader(header)) continue;
                this.httpConnection.setRequestProperty(header.getKey(), header.getValue());
            }
        }
        if (this.httpConnection instanceof URLConnectionAdapterDirectImpl && ((connectionRequest = this.httpConnection.getRequestProperty("Connection")) == null || StringUtils.containsIgnoreCase((String)connectionRequest, (String)"Keep-Alive"))) {
            URLConnectionAdapterDirectImpl httpConnection = (URLConnectionAdapterDirectImpl)this.httpConnection;
            httpConnection.setKeepAlive(HTTPConnectionImpl.KEEPALIVE.EXTERNAL_EXCEPTION);
        }
        this.preRequest();
        if (this.hasCookies() && StringUtils.isNotEmpty((String)(cookieString = this.getCookieString()))) {
            this.httpConnection.setRequestProperty("Cookie", cookieString);
        }
    }

    public abstract long postRequest() throws IOException;

    public abstract void preRequest() throws IOException;

    public String printHeaders() {
        URLConnectionAdapter lhttpConnection = this.getHttpConnection();
        if (lhttpConnection == null) {
            return null;
        }
        return lhttpConnection.toString();
    }

    public Request read(boolean keepByteArray) throws IOException {
        this.keepByteArray = keepByteArray;
        long tima = Time.systemIndependentCurrentJVMTimeMillis();
        this.httpConnection.setCharset(this.getCustomCharset());
        this.responseBytes = Request.read(this.getHttpConnection(), this.getReadLimit());
        this.readTime = Time.systemIndependentCurrentJVMTimeMillis() - tima;
        return this;
    }

    public void setKeepByteArray(boolean keepByteArray) {
        this.keepByteArray = keepByteArray;
    }

    public void setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public void setContentDecoded(boolean c) {
        this.contentDecoded = c;
    }

    public void setCookies(Cookies cookies) {
        this.cookies = cookies;
    }

    public void setCustomCharset(String charset) {
        this.customCharset = charset;
    }

    public void setHeaders(RequestHeader headers) {
        this.headers = headers;
    }

    public void setHtmlCode(String htmlCode) {
        this.responseBytes = null;
        this.htmlCode = htmlCode;
        this.requested = true;
    }

    public void resetConnection() {
        this.disconnect();
        this.responseBytes = null;
        this.htmlCode = null;
        this.location = null;
        this.requested = false;
    }

    public void setResponseBytes(byte[] bytes) {
        this.responseBytes = bytes;
        this.htmlCode = null;
        this.requested = true;
    }

    public void setProxy(HTTPProxy proxy) {
        this.proxy = proxy == null || proxy instanceof ClonedProxy ? proxy : new ClonedProxy(proxy);
    }

    public void setProxy(ClonedProxy proxy) {
        this.proxy = proxy;
    }

    public void setReadLimit(int readLimit) {
        this.readLimit = Math.max(0, readLimit);
    }

    public void setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
        URLConnectionAdapter con = this.httpConnection;
        if (con != null) {
            con.setReadTimeout(readTimeout);
        }
    }

    public boolean containsHTML(String regex) {
        String htmlCode = this.getHtmlCode(false);
        return htmlCode != null ? new Regex(htmlCode, regex).matches() : false;
    }

    public Regex getRegex(Pattern pattern) {
        String htmlCode = this.getHtmlCode(false);
        return new Regex(htmlCode != null ? htmlCode : "", pattern);
    }

    public Regex getRegex(String string) {
        String htmlCode = this.getHtmlCode(false);
        return new Regex(htmlCode != null ? htmlCode : "", string);
    }

    public void setURL(URL url) {
        if (this.isRequested()) {
            throw new IllegalStateException("Request:" + this.getURL() + " has already been requested!");
        }
        this.url = url;
    }

    public String toString() {
        if (!this.isRequested()) {
            return "Request not sent yet";
        }
        try {
            URLConnectionAdapter lhttpConnection = this.getHttpConnection();
            if (lhttpConnection != null) {
                StringBuilder sb = new StringBuilder();
                sb.append(lhttpConnection.toString());
                sb.append("\r\n");
                this.getHtmlCode();
                sb.append(this.getHTMLSource());
                return sb.toString();
            }
            return this.getHTMLSource();
        }
        catch (Exception e) {
            return "NOTEXT: " + e.getMessage();
        }
    }

    public static class NoHTMLContentException
    extends IllegalStateException {
        protected NoHTMLContentException(String string) {
            super(string);
        }
    }
}

