/*
 * Decompiled with CFR 0.152.
 */
package jd.http;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.net.InetAddress;
import java.net.Proxy;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.URL;
import jd.http.Request;
import jd.http.URLConnectionAdapter;
import jd.http.URLConnectionAdapterDirectImpl;
import jd.http.WrappedBrotliInputStream;
import jd.http.requests.PostFormDataRequest;
import jd.http.requests.PostRequest;
import org.appwork.utils.net.httpconnection.HTTPConnection;
import org.appwork.utils.net.httpconnection.HTTPConnectionUtils;
import org.appwork.utils.net.httpconnection.HTTPProxy;
import org.appwork.utils.net.httpconnection.NativeHTTPConnectionImpl;
import org.appwork.utils.net.httpconnection.SSLSocketStreamOptions;
import org.appwork.utils.net.socketconnection.SocketConnection;

public class URLConnectionAdapterNative
extends NativeHTTPConnectionImpl
implements URLConnectionAdapter {
    private Request request;
    private boolean allResponseCodesAllowed = false;
    protected SocketAddress endPointSocketAddress;

    public URLConnectionAdapterNative(URL url) {
        super(url);
    }

    public URLConnectionAdapterNative(URL url, HTTPProxy p) {
        super(url, p);
    }

    @Override
    public InputStream getErrorStream() {
        try {
            return super.getInputStream();
        }
        catch (IOException e) {
            return null;
        }
    }

    protected SSLSocketStreamOptions getSSLSocketStreamOptions(SSLSocketStreamOptions options) {
        Request request = this.getRequest();
        if (request != null) {
            return request.getSSLSocketStreamOptions(options, this);
        }
        return options;
    }

    @Override
    public void setAllResponseCodesAllowed(boolean b) {
        this.allResponseCodesAllowed = b;
    }

    @Override
    public boolean isAllResponseCodesAllowed() {
        return this.allResponseCodesAllowed;
    }

    protected boolean isResponseCodeAllowed(int code) {
        return this.isAllResponseCodesAllowed() || super.isResponseCodeAllowed(code);
    }

    public boolean isLegacyConnectEnabled() {
        return false;
    }

    @Override
    public String getCipherSuite() {
        return null;
    }

    @Override
    public long getLongContentLength() {
        return this.getContentLength();
    }

    public long[] getRange() {
        long[] ret = super.getRange();
        if (ret == null && this.getResponseCode() == 206) {
            this.ranges = URLConnectionAdapterDirectImpl.buildFakeContentRange(this);
            return this.ranges;
        }
        return ret;
    }

    @Override
    public Request getRequest() {
        return this.request;
    }

    @Override
    public void setRequest(Request request) {
        InetAddress customInetAddress;
        this.request = request;
        if (request != null && (customInetAddress = request.getCustomInetAddress()) != null) {
            this.connectExceptions.add("CustomInetAddress not yet supported:" + customInetAddress);
        }
    }

    protected boolean isRequiresOutputStream() {
        return super.isRequiresOutputStream() || this.request != null && this.request.requireOutputStream();
    }

    public InputStream getInputStream() throws IOException {
        if (this.convertedInputStream == null && !HTTPConnection.RequestMethod.HEAD.equals((Object)this.getRequestMethod())) {
            String encoding;
            super.getInputStream();
            if (!this.isContentDecoded() && "br".equalsIgnoreCase(encoding = this.getHeaderField("Content-Encoding"))) {
                this.convertedInputStream = new WrappedBrotliInputStream(this.convertedInputStream);
                this.contentDecoded = true;
            }
        }
        this.getEndPointSocketAddress();
        return super.getInputStream();
    }

    @Override
    public byte[] peek(int numBytes) throws IOException {
        return URLConnectionAdapterDirectImpl.peek(this, numBytes);
    }

    @Override
    public InputStream setInputStream(InputStream is) throws IOException {
        if (is == null) {
            throw new IllegalArgumentException();
        }
        InputStream ret = this.convertedInputStream;
        if (ret == null) {
            ret = this.getInputStream();
        }
        if (is == ret) {
            return is;
        }
        this.convertedInputStream = is;
        return ret;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(300);
        Request req = this.getRequest();
        if (req != null) {
            sb.append("Caller: " + req.getCaller());
            sb.append("\r\n");
            sb.append("BrowserID:" + req.getBrowserID() + "|BrowserParentID:" + req.getBrowserParentID() + "|RequestID:" + req.getRequestID() + "|URL:" + req.getURL());
            sb.append("\r\n");
        }
        sb.append(this.getRequestInfo());
        if (req != null) {
            String postDataString;
            if (req instanceof PostRequest) {
                String log = ((PostRequest)req).log();
                if (log != null) {
                    sb.append("\r\n");
                    sb.append(log);
                }
            } else if (req instanceof PostFormDataRequest && (postDataString = ((PostFormDataRequest)req).getPostDataString()) != null) {
                sb.append("\r\n");
                sb.append(postDataString);
            }
            sb.append("\r\n");
        }
        sb.append(this.getResponseInfo());
        return sb.toString();
    }

    public void disconnect() {
        try {
            this.getEndPointSocketAddress();
        }
        finally {
            super.disconnect();
        }
    }

    @Override
    public SocketAddress getEndPointSocketAddress() {
        if (this.endPointSocketAddress == null) {
            Proxy proxy = null;
            Field proxyField = null;
            try {
                proxyField = this.con.getClass().getDeclaredField("instProxy");
                proxyField.setAccessible(true);
                proxy = (Proxy)proxyField.get(this.con);
            }
            catch (NoSuchFieldException noSuchFieldException) {
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
            if (proxyField == null) {
                try {
                    Field delegateField = this.con.getClass().getDeclaredField("delegate");
                    delegateField.setAccessible(true);
                    Object delegate = delegateField.get(this.con);
                    proxyField = delegate.getClass().getSuperclass().getSuperclass().getDeclaredField("instProxy");
                    proxyField.setAccessible(true);
                    proxy = (Proxy)proxyField.get(delegate);
                }
                catch (NoSuchFieldException delegateField) {
                }
                catch (IllegalAccessException delegateField) {
                    // empty catch block
                }
            }
            try {
                if (proxy != null) {
                    this.endPointSocketAddress = proxy.address();
                } else {
                    Field http = this.con.getClass().getDeclaredField("http");
                    http.setAccessible(true);
                    Object httpValue = http.get(this.con);
                    if (httpValue != null) {
                        Field serverSocket = httpValue.getClass().getSuperclass().getDeclaredField("serverSocket");
                        serverSocket.setAccessible(true);
                        this.endPointSocketAddress = SocketConnection.getRootEndPointSocketAddress((Socket)((Socket)serverSocket.get(httpValue)));
                    }
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        return this.endPointSocketAddress;
    }

    @Override
    public HTTPConnectionUtils.IPVERSION getIPVersion() {
        return HTTPConnectionUtils.IPVERSION.SYSTEM;
    }

    @Override
    public void setIPVersion(HTTPConnectionUtils.IPVERSION tcpVersion) {
    }
}

