/*
 * Decompiled with CFR 0.152.
 */
package jd;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Security;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.crypto.Cipher;

public class UJCECheck {
    private static final AtomicBoolean checked = new AtomicBoolean(false);
    private static final AtomicBoolean successful = new AtomicBoolean(false);

    private static Boolean isRestrictedCryptography() {
        try {
            int strength = Cipher.getMaxAllowedKeyLength("AES");
            if (strength > 128) {
                return false;
            }
            return true;
        }
        catch (Throwable e) {
            return null;
        }
    }

    public static boolean isSuccessful() {
        return successful.get() || Boolean.FALSE.equals(UJCECheck.isRestrictedCryptography());
    }

    public static final void check() {
        if (checked.compareAndSet(false, true)) {
            UJCECheck.removeCryptographyRestrictions();
        }
    }

    private static void modifyRestricted(Field isRestrictedField) throws NoSuchFieldException, SecurityException, IllegalArgumentException, IllegalAccessException {
        if (Modifier.isFinal(isRestrictedField.getModifiers())) {
            Field modifiers = Field.class.getDeclaredField("modifiers");
            modifiers.setAccessible(true);
            modifiers.setInt(isRestrictedField, isRestrictedField.getModifiers() & 0xFFFFFFEF);
            isRestrictedField.setAccessible(true);
            isRestrictedField.set(null, false);
            isRestrictedField.setAccessible(false);
        } else {
            isRestrictedField.setAccessible(true);
            isRestrictedField.set(null, false);
            isRestrictedField.setAccessible(false);
        }
    }

    private static void removeCryptographyRestrictions_M1() throws Throwable {
        Class<?> jceSecurity = Class.forName("javax.crypto.JceSecurity");
        Class<?> cryptoPermissions = Class.forName("javax.crypto.CryptoPermissions");
        Class<?> cryptoAllPermission = Class.forName("javax.crypto.CryptoAllPermission");
        Field isRestrictedField = jceSecurity.getDeclaredField("isRestricted");
        Field defaultPolicyField = jceSecurity.getDeclaredField("defaultPolicy");
        Field perms = cryptoPermissions.getDeclaredField("perms");
        Field instance = cryptoAllPermission.getDeclaredField("INSTANCE");
        UJCECheck.modifyRestricted(isRestrictedField);
        defaultPolicyField.setAccessible(true);
        PermissionCollection defaultPolicy = (PermissionCollection)defaultPolicyField.get(null);
        perms.setAccessible(true);
        ((Map)perms.get(defaultPolicy)).clear();
        instance.setAccessible(true);
        defaultPolicy.add((Permission)instance.get(null));
    }

    private static void removeCryptographyRestrictions_M2() throws Throwable {
        Class<?> jceSecurity = Class.forName("javax.crypto.d");
        Class<?> cryptoAllPermission = Class.forName("javax.crypto.CryptoAllPermission");
        Field defaultPolicyField = jceSecurity.getDeclaredField("a");
        Field instance = cryptoAllPermission.getDeclaredField("h");
        defaultPolicyField.setAccessible(true);
        PermissionCollection defaultPolicy = (PermissionCollection)defaultPolicyField.get(null);
        Field perms = defaultPolicy.getClass().getDeclaredField("a");
        perms.setAccessible(true);
        ((Map)perms.get(defaultPolicy)).clear();
        instance.setAccessible(true);
        defaultPolicy.add((Permission)instance.get(null));
    }

    private static void removeCryptographyRestrictions_M3() throws Throwable {
        Class<?> jceSecurity = Class.forName("javax.crypto.SunJCE_b");
        Class<?> cryptoPermissions = Class.forName("javax.crypto.SunJCE_d");
        Class<?> cryptoAllPermission = Class.forName("javax.crypto.SunJCE_k");
        Field defaultPolicyField = jceSecurity.getDeclaredField("c");
        Field perms = cryptoPermissions.getDeclaredField("a");
        Field isRestrictedField = jceSecurity.getDeclaredField("g");
        Field instance = cryptoAllPermission.getDeclaredField("b");
        UJCECheck.modifyRestricted(isRestrictedField);
        defaultPolicyField.setAccessible(true);
        PermissionCollection defaultPolicy = (PermissionCollection)defaultPolicyField.get(null);
        perms.setAccessible(true);
        ((Map)perms.get(defaultPolicy)).clear();
        instance.setAccessible(true);
        defaultPolicy.add((Permission)instance.get(null));
    }

    private static void removeCryptographyRestrictions() {
        if (Boolean.FALSE.equals(UJCECheck.isRestrictedCryptography())) {
            if (successful.get()) {
                System.out.println("Already removed cryptography restrictions");
            } else {
                System.out.println("Cryptography restrictions removal not needed");
            }
        } else if (successful.get()) {
            System.out.println("Already removed cryptography restrictions");
        } else {
            try {
                Security.setProperty("crypto.policy", "unlimited");
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                try {
                    UJCECheck.removeCryptographyRestrictions_M1();
                }
                catch (ClassNotFoundException e) {
                    e.printStackTrace();
                    try {
                        UJCECheck.removeCryptographyRestrictions_M2();
                    }
                    catch (ClassNotFoundException e2) {
                        e2.printStackTrace();
                        UJCECheck.removeCryptographyRestrictions_M3();
                    }
                }
                successful.set(true);
                System.out.println("Successfully removed cryptography restrictions");
            }
            catch (Throwable e) {
                System.out.println("Failed to remove cryptography restrictions:" + e);
            }
        }
    }
}

