/*
 * Decompiled with CFR 0.152.
 */
package jd.config;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.ref.WeakReference;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.appwork.exceptions.WTFException;
import org.appwork.storage.JSonStorage;
import org.appwork.storage.SimpleMapper;
import org.appwork.storage.TypeRef;
import org.appwork.storage.simplejson.MinimalMemoryMap;
import org.appwork.utils.ReflectionUtils;
import org.appwork.utils.net.Base64InputStream;
import org.appwork.utils.net.Base64OutputStream;
import org.appwork.utils.net.CharSequenceInputStream;

public class Property {
    private static final WeakHashMap<String, WeakReference<String>> DEDUPEMAP = new WeakHashMap();
    private static final long serialVersionUID = -6093927038856757256L;
    public static final Object NULL = new Object();
    private final Object NEWIMPLEMENTATION = new Object();
    private Object[] propertiesList = null;
    public static final Charset UTF8 = Charset.forName("UTF-8");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String dedupeString(String string) {
        if (string == null) {
            return null;
        }
        WeakHashMap<String, WeakReference<String>> weakHashMap = DEDUPEMAP;
        synchronized (weakHashMap) {
            String ret = null;
            WeakReference<String> ref = DEDUPEMAP.get(string);
            if (ref != null && (ret = (String)ref.get()) != null) {
                return ret;
            }
            ref = new WeakReference<String>(string);
            DEDUPEMAP.put(string, ref);
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String returnDedupeStringInstance(String string) {
        if (string == null) {
            return null;
        }
        WeakHashMap<String, WeakReference<String>> weakHashMap = DEDUPEMAP;
        synchronized (weakHashMap) {
            String ret;
            WeakReference<String> ref = DEDUPEMAP.get(string);
            if (ref != null && (ret = (String)ref.get()) != null) {
                return ret;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureCapacity(int capacity) {
        Object object = this.NEWIMPLEMENTATION;
        synchronized (object) {
            if (this.propertiesList == null) {
                this.propertiesList = new Object[capacity * 2];
            } else {
                int length = this.propertiesList.length;
                int grow = capacity * 2 - length;
                if (grow > 0) {
                    Object[] tmpPropertiesList = new Object[length + grow];
                    System.arraycopy(this.propertiesList, 0, tmpPropertiesList, 0, length);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean putObject(String key, Object value) {
        Object object = this.NEWIMPLEMENTATION;
        synchronized (object) {
            if (this.propertiesList == null && (value == null || value == NULL)) {
                return false;
            }
            this.ensureCapacity(1);
            Object[] propertiesList = this.propertiesList;
            if (key != null) {
                int length = propertiesList.length;
                int index = this.getObjectIndex(key);
                if (index != -1) {
                    if (value == null || value == NULL) {
                        propertiesList[index] = null;
                        propertiesList[index + 1] = null;
                        return true;
                    }
                    Object old = propertiesList[index + 1];
                    propertiesList[index + 1] = value instanceof String ? this.dedupeValueString(key, (String)value) : value;
                    if (old == null && value != null) {
                        return true;
                    }
                    return !old.equals(value);
                }
                if (value == null || value == NULL) {
                    return false;
                }
                for (index = 0; index < length; index += 2) {
                    if (propertiesList[index] != null) continue;
                    propertiesList[index] = this.dedupeKeyString(key);
                    propertiesList[index + 1] = value instanceof String ? this.dedupeValueString(key, (String)value) : value;
                    return true;
                }
                Object[] tmpPropertiesList = new Object[length + 2];
                System.arraycopy(propertiesList, 0, tmpPropertiesList, 0, length);
                tmpPropertiesList[length] = this.dedupeKeyString(key);
                tmpPropertiesList[length + 1] = value instanceof String ? this.dedupeValueString(key, (String)value) : value;
                this.propertiesList = tmpPropertiesList;
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getObject(String key) {
        Object object = this.NEWIMPLEMENTATION;
        synchronized (object) {
            Object[] propertiesList = this.propertiesList;
            if (propertiesList != null && key != null) {
                int length = propertiesList.length;
                for (int index = 0; index < length; index += 2) {
                    if (!key.equals(propertiesList[index])) continue;
                    return propertiesList[index + 1];
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getObjectIndex(String key) {
        Object object = this.NEWIMPLEMENTATION;
        synchronized (object) {
            Object[] propertiesList = this.propertiesList;
            if (propertiesList != null && key != null) {
                int length = propertiesList.length;
                for (int index = 0; index < length; index += 2) {
                    if (!key.equals(propertiesList[index])) continue;
                    return index;
                }
            }
        }
        return -1;
    }

    public boolean removeProperty(String key) {
        return this.setProperty(key, NULL);
    }

    public Boolean getBooleanProperty(String key) {
        return this.getBooleanProperty(key, false);
    }

    public <T> T getObjectProperty(String key, TypeRef<T> typeRef) {
        Object raw = this.getProperty(key);
        if (raw == null) {
            return null;
        }
        if (typeRef.getType().equals(raw.getClass())) {
            return (T)raw;
        }
        Object ret = JSonStorage.convert((Object)raw, typeRef);
        this.setProperty(key, ret);
        return (T)ret;
    }

    public Boolean getBooleanProperty(String key, boolean def) {
        return this.getBooleanProperty(key, (Boolean)def);
    }

    public Boolean getBooleanProperty(String key, Boolean def) {
        try {
            Object value = this.getProperty(key, def);
            if (value instanceof Boolean) {
                return (Boolean)value;
            }
            if (value == null) {
                return def;
            }
            String stringValue = String.valueOf(value);
            if (stringValue != null) {
                if ("true".equalsIgnoreCase(stringValue) || "1".equals(stringValue)) {
                    return true;
                }
                if ("false".equalsIgnoreCase(stringValue) || "0".equals(stringValue)) {
                    return false;
                }
                return stringValue.length() > 0;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return def;
    }

    public int getIntegerProperty(String key) {
        return this.getIntegerProperty(key, -1);
    }

    public int getIntegerProperty(String key, int def) {
        try {
            Object value = this.getProperty(key, def);
            if (value instanceof String) {
                return Integer.parseInt((String)value);
            }
            if (value instanceof Number) {
                return ((Number)value).intValue();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return def;
    }

    public long getLongProperty(String key, long def) {
        try {
            Object value = this.getProperty(key, def);
            if (value instanceof String) {
                return Long.parseLong((String)value);
            }
            if (value instanceof Number) {
                return ((Number)value).longValue();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return def;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getPropertiesSize() {
        Object object = this.NEWIMPLEMENTATION;
        synchronized (object) {
            Object[] propertiesList = this.propertiesList;
            int size = 0;
            if (propertiesList != null) {
                int length = propertiesList.length;
                for (int index = 0; index < length; index += 2) {
                    if (propertiesList[index] == null) continue;
                    ++size;
                }
            }
            return size;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> getProperties() {
        Object object = this.NEWIMPLEMENTATION;
        synchronized (object) {
            Object[] propertiesList = this.propertiesList;
            int size = this.getPropertiesSize();
            Map<String, Object> ret = Property.newMapInstance(size);
            if (propertiesList != null && size > 0) {
                int length = propertiesList.length;
                for (int index = 0; index < length; index += 2) {
                    if (propertiesList[index] == null) continue;
                    ret.put((String)propertiesList[index], propertiesList[index + 1]);
                }
            }
            return ret;
        }
    }

    public static Map<String, Object> newMapInstance(int size) {
        return new MinimalMemoryMap(size);
    }

    public Object getProperty(String key) {
        if (key == null) {
            throw new WTFException("key ==null is forbidden!");
        }
        return this.getObject(key);
    }

    public Object getProperty(String key, Object def) {
        Object ret = this.getProperty(key);
        if (def instanceof Number && ret instanceof Number) {
            if (def.getClass().equals(ret.getClass())) {
                return ret;
            }
            ret = ReflectionUtils.cast((Object)ret, def.getClass());
        }
        if (ret == null) {
            return def;
        }
        return ret;
    }

    public String getStringProperty(String key) {
        return this.getStringProperty(key, null);
    }

    public String getStringProperty(String key, String def) {
        try {
            Object r = this.getProperty(key, def);
            String ret = r == null ? null : r.toString();
            return ret;
        }
        catch (Exception e) {
            return def;
        }
    }

    public boolean hasProperty(String key) {
        if (key == null) {
            throw new WTFException("key ==null is forbidden!");
        }
        return this.getObjectIndex(key) != -1;
    }

    protected Map<String, Object> optimizeMapInstance(Map<String, Object> map) {
        if (map != null && map.size() > 0) {
            Map<String, Object> ret = Property.newMapInstance(0);
            for (Map.Entry<String, Object> next : map.entrySet()) {
                String key = next.getKey();
                Map<String, Object> value = next.getValue();
                if (key == null || value == null) continue;
                key = this.dedupeKeyString(key);
                if (value instanceof Map) {
                    if ((value = this.optimizeMapInstance(value)) == null) continue;
                    ret.put(key, value);
                    continue;
                }
                if (value instanceof String) {
                    ret.put(key, this.dedupeValueString(key, (String)((Object)value)));
                    continue;
                }
                ret.put(key, value);
            }
            if (ret.size() > 0) {
                return ret;
            }
            return null;
        }
        return null;
    }

    protected String dedupeValueString(String key, String value) {
        return Property.dedupeString(value);
    }

    protected String dedupeKeyString(String key) {
        return Property.dedupeString(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setProperties(Map<String, Object> properties) {
        Map<String, Object> newProperties = this.optimizeMapInstance(properties);
        if (newProperties != null && newProperties.size() > 0) {
            Object object = this.NEWIMPLEMENTATION;
            synchronized (object) {
                this.propertiesList = null;
                this.ensureCapacity(newProperties.size());
                for (Map.Entry<String, Object> entry : newProperties.entrySet()) {
                    this.putObject(entry.getKey(), entry.getValue());
                }
            }
        }
        Object object = this.NEWIMPLEMENTATION;
        synchronized (object) {
            this.propertiesList = null;
        }
    }

    public void setCompressedProperty(String key, Object value) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        Base64OutputStream b64os = new Base64OutputStream((OutputStream)bos);
        SimpleMapper mapper = new SimpleMapper(){

            protected void initMapper() {
            }

            public boolean isPrettyPrintEnabled() {
                return false;
            }
        };
        try {
            GZIPOutputStream gos = new GZIPOutputStream((OutputStream)b64os);
            mapper.writeObject((OutputStream)gos, value);
            gos.close();
            this.setProperty(key + ".gz", new String(bos.toByteArray(), UTF8));
        }
        catch (IOException e) {
            throw new WTFException((Throwable)e);
        }
    }

    public <T> T getCompressedProperty(String key, TypeRef<T> typeRef) {
        String compressedGZJSonString = this.getStringProperty(key + ".gz");
        if (compressedGZJSonString == null) {
            compressedGZJSonString = this.getStringProperty(key);
        }
        if (compressedGZJSonString == null) {
            return null;
        }
        try {
            GZIPInputStream is = new GZIPInputStream((InputStream)new Base64InputStream((InputStream)new CharSequenceInputStream((CharSequence)compressedGZJSonString, UTF8)));
            Object ret = JSonStorage.getMapper().inputStreamToObject((InputStream)is, typeRef);
            return (T)ret;
        }
        catch (IOException e) {
            throw new WTFException((Throwable)e);
        }
    }

    public boolean setProperty(String key, Object value) {
        if (key == null) {
            throw new WTFException("key ==null is forbidden!");
        }
        return this.putObject(key, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        Map<String, Object> lInternal = this.getProperties();
        if (lInternal == null || lInternal.size() == 0) {
            return "Property: empty";
        }
        Map<String, Object> map = lInternal;
        synchronized (map) {
            return "Property: " + lInternal;
        }
    }
}

