/*
 * Decompiled with CFR 0.152.
 */
package jd.config;

import java.io.File;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import jd.config.Property;
import org.appwork.scheduler.DelayedRunnable;
import org.appwork.shutdown.ShutdownController;
import org.appwork.shutdown.ShutdownEvent;
import org.appwork.shutdown.ShutdownRequest;
import org.appwork.storage.JSonStorage;
import org.appwork.storage.TypeRef;
import org.appwork.storage.config.handler.StorageHandler;
import org.appwork.utils.Application;
import org.appwork.utils.IO;
import org.appwork.utils.logging2.extmanager.LoggerFactory;

@Deprecated
public class SubConfiguration
extends Property
implements Serializable {
    private static final long serialVersionUID = 7803718581558607222L;
    protected final String name;
    protected final File file;
    protected final AtomicLong setMark = new AtomicLong(0L);
    protected final AtomicLong writeMark = new AtomicLong(0L);
    protected static volatile HashMap<String, SubConfiguration> SUB_CONFIGS = new HashMap();
    protected static final HashMap<String, AtomicInteger> LOCKS = new HashMap();
    protected static final byte[] KEY = new byte[]{1, 2, 17, 1, 1, 84, 1, 1, 1, 1, 18, 1, 1, 1, 34, 1};
    protected static final DelayedRunnable SAVEDELAYER = new DelayedRunnable(5000L, 30000L){

        public void delayedrun() {
            SubConfiguration.saveAll();
        }
    };

    private static void saveAll() {
        HashMap<String, SubConfiguration> localSubConfigs = SUB_CONFIGS;
        Iterator<Map.Entry<String, SubConfiguration>> it = localSubConfigs.entrySet().iterator();
        while (it.hasNext()) {
            it.next().getValue().save();
        }
    }

    public void reset() {
        this.setProperties(null);
    }

    public static File getSubConfigurationFile(String name) {
        return Application.getResource((String)("cfg/subconf_" + name + ".ejs"));
    }

    private SubConfiguration(String name) {
        this.name = name;
        this.file = SubConfiguration.getSubConfigurationFile(name);
        if (this.file.isFile()) {
            try {
                Map load = (Map)JSonStorage.restoreFrom((File)this.file, (boolean)false, (byte[])KEY, (TypeRef)TypeRef.HASHMAP, new HashMap());
                if (load != null) {
                    load.remove("saveWorkaround");
                    super.setProperties(load);
                }
            }
            catch (Throwable e) {
                LoggerFactory.getDefaultLogger().log(e);
            }
        }
    }

    public void save() {
        long lastSetMark;
        if (this.file != null && this.writeMark.getAndSet(lastSetMark = this.setMark.get()) != lastSetMark) {
            try {
                LoggerFactory.getDefaultLogger().info("Save Name:" + this.getName() + "|SetMark:" + lastSetMark + "|File:" + this.file);
                Map<String, Object> properties = this.getProperties();
                final byte[] json = properties.size() > 0 ? JSonStorage.getMapper().objectToByteArray(properties) : null;
                this.writeMark.set(this.setMark.get());
                Runnable run = new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        block7: {
                            if (json == null || json.length == 0) {
                                Object lock = JSonStorage.requestLock((File)SubConfiguration.this.file);
                                try {
                                    Object object = lock;
                                    synchronized (object) {
                                        SubConfiguration.this.file.delete();
                                        break block7;
                                    }
                                }
                                finally {
                                    JSonStorage.unLock((File)SubConfiguration.this.file);
                                }
                            }
                            JSonStorage.saveTo((File)SubConfiguration.this.file, (boolean)false, (byte[])KEY, (byte[])json, (IO.SYNC)IO.SYNC.META_AND_DATA);
                        }
                    }
                };
                StorageHandler.enqueueWrite((Runnable)run, (String)this.file.getAbsolutePath(), (boolean)true);
            }
            catch (Throwable e) {
                LoggerFactory.getDefaultLogger().log(e);
            }
        }
    }

    public String getName() {
        return this.name;
    }

    @Override
    public boolean setProperty(String key, Object value) {
        boolean change = super.setProperty(key, value);
        if (change) {
            this.setMark.incrementAndGet();
            SAVEDELAYER.run();
        }
        return change;
    }

    public boolean setPropertyWithoutMark(String key, Object value) {
        return super.setProperty(key, value);
    }

    @Override
    public void setProperties(Map<String, Object> properties) {
        super.setProperties(properties);
        this.setMark.incrementAndGet();
        SAVEDELAYER.run();
    }

    @Override
    public String toString() {
        return "SubConfig: " + this.name + "->" + super.toString();
    }

    private static synchronized Object requestLock(String name) {
        AtomicInteger lock = LOCKS.get(name);
        if (lock == null) {
            lock = new AtomicInteger(0);
            LOCKS.put(name, lock);
        }
        lock.incrementAndGet();
        return lock;
    }

    private static synchronized void unLock(String name) {
        AtomicInteger lock = LOCKS.get(name);
        if (lock != null && lock.decrementAndGet() == 0) {
            LOCKS.remove(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static SubConfiguration getConfig(String name) {
        block9: {
            SubConfiguration subConfiguration;
            SubConfiguration ret = SUB_CONFIGS.get(name);
            if (ret != null) {
                return ret;
            }
            Object lock = SubConfiguration.requestLock(name);
            try {
                Object object = lock;
                // MONITORENTER : object
                ret = SUB_CONFIGS.get(name);
                if (ret == null) break block9;
                subConfiguration = ret;
                // MONITOREXIT : object
            }
            catch (Throwable throwable) {
                SubConfiguration.unLock(name);
                throw throwable;
            }
            SubConfiguration.unLock(name);
            return subConfiguration;
        }
        SubConfiguration cfg = new SubConfiguration(name);
        Serializable serializable = LOCKS;
        // MONITORENTER : serializable
        HashMap<String, SubConfiguration> newSUB_CONFIGS = new HashMap<String, SubConfiguration>(SUB_CONFIGS);
        newSUB_CONFIGS.put(name, cfg);
        SUB_CONFIGS = newSUB_CONFIGS;
        // MONITOREXIT : serializable
        serializable = cfg;
        // MONITOREXIT : object
        SubConfiguration.unLock(name);
        return serializable;
    }

    static {
        ShutdownController.getInstance().addShutdownEvent(new ShutdownEvent(){

            public long getMaxDuration() {
                return 0L;
            }

            public String toString() {
                return "ShutdownEvent: SaveAllSubconfigurations";
            }

            public void onShutdown(ShutdownRequest shutdownRequest) {
                SubConfiguration.saveAll();
            }
        });
    }
}

