/*
 * Decompiled with CFR 0.152.
 */
package jd.controlling.accountchecker;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import jd.controlling.AccountController;
import jd.controlling.accountchecker.AccountCheckerEvent;
import jd.controlling.accountchecker.AccountCheckerEventSender;
import jd.controlling.accountchecker.AccountCheckerThread;
import jd.plugins.Account;
import jd.plugins.AccountInfo;
import org.appwork.exceptions.WTFException;
import org.appwork.utils.event.DefaultEvent;

public class AccountChecker {
    private static AccountChecker INSTANCE = new AccountChecker();
    private HashMap<String, Thread> checkThreads = new HashMap();
    private HashMap<String, LinkedList<AccountCheckJob>> jobs = new HashMap();
    private List<Account> accountJobs = new ArrayList<Account>();
    private AtomicLong jobsRequested = new AtomicLong(0L);
    private AtomicLong jobsDone = new AtomicLong(0L);
    private AccountCheckerEventSender eventSender = new AccountCheckerEventSender();

    public AccountCheckerEventSender getEventSender() {
        return this.eventSender;
    }

    public static AccountChecker getInstance() {
        return INSTANCE;
    }

    private AccountChecker() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AccountCheckJob check(Account account, boolean force) {
        AccountCheckJob ret = null;
        boolean started = false;
        Object thread = null;
        AccountChecker accountChecker = this;
        synchronized (accountChecker) {
            final String hoster = account.getHoster();
            if (hoster == null) {
                throw new WTFException("no hoster?");
            }
            LinkedList<AccountCheckJob> list = this.jobs.get(hoster);
            if (list == null) {
                list = new LinkedList();
                this.jobs.put(hoster, list);
            }
            ret = new AccountCheckJob(account, force);
            this.jobsRequested.incrementAndGet();
            list.add(ret);
            thread = this.checkThreads.get(hoster);
            if (thread == null || !((Thread)thread).isAlive()) {
                started = this.checkThreads.isEmpty();
                thread = new AccountCheckerThread(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     * Unable to fully structure code
                     */
                    public void run() {
                        job = null;
                        stopped = false;
                        while (true) lbl-1000:
                        // 4 sources

                        {
                            var3_3 = AccountChecker.this;
                            synchronized (var3_3) {
                                joblist = (LinkedList)AccountChecker.access$300(AccountChecker.this).get(hoster);
                                if (joblist == null || joblist.size() <= 0) {
                                    AccountChecker.access$300(AccountChecker.this).remove(hoster);
                                    AccountChecker.access$400(AccountChecker.this).remove(hoster);
                                    stopped = AccountChecker.access$400(AccountChecker.this).isEmpty();
                                    ** break;
                                }
                                job = (AccountCheckJob)joblist.removeFirst();
                            }
                            try {
                                this.job = job;
                                job.check();
                            }
                            catch (Throwable e) {
                                e.printStackTrace();
                            }
                            finally {
                                this.job = null;
                                continue;
                            }
                            break;
                        }
                        ** GOTO lbl-1000
lbl30:
                        // 1 sources

                        if (stopped) {
                            AccountChecker.access$500(AccountChecker.this).fireEvent((DefaultEvent)new AccountCheckerEvent(AccountChecker.this, AccountCheckerEvent.Types.CHECK_STOPPED, null));
                        }
                    }

                    public boolean isVerbose() {
                        return true;
                    }

                    public boolean isDebug() {
                        return true;
                    }
                };
                ((Thread)thread).setName("AccountChecker: " + hoster);
                ((Thread)thread).setDaemon(true);
                this.checkThreads.put(hoster, (Thread)thread);
                ((Thread)thread).start();
            }
        }
        if (started) {
            this.eventSender.fireEvent((DefaultEvent)new AccountCheckerEvent(this, AccountCheckerEvent.Types.CHECK_STARTED, null));
        }
        return ret;
    }

    public boolean isRunning() {
        return this.jobsRequested.get() != this.jobsDone.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(Account account) {
        AccountChecker accountChecker = this;
        synchronized (accountChecker) {
            return this.accountJobs.contains(account);
        }
    }

    static /* synthetic */ HashMap access$300(AccountChecker x0) {
        return x0.jobs;
    }

    static /* synthetic */ HashMap access$400(AccountChecker x0) {
        return x0.checkThreads;
    }

    static /* synthetic */ AccountCheckerEventSender access$500(AccountChecker x0) {
        return x0.eventSender;
    }

    public class AccountCheckJob {
        private final Account account;
        private volatile boolean isChecked = false;
        private volatile boolean isChecking = false;
        private final boolean force;
        private volatile AccountInfo ai = null;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private AccountCheckJob(Account account, boolean force) {
            this.account = account;
            this.force = force;
            AccountCheckJob accountCheckJob = this;
            synchronized (accountCheckJob) {
                AccountChecker.this.accountJobs.add(account);
            }
        }

        public boolean isForce() {
            return this.force;
        }

        public Account getAccount() {
            return this.account;
        }

        public AccountCheckJob(Account account) {
            this(account, false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void check() {
            this.isChecking = true;
            try {
                this.ai = AccountController.getInstance().updateAccountInfo(this.account, this.force);
            }
            finally {
                this.isChecking = false;
                AccountCheckJob accountCheckJob = this;
                synchronized (accountCheckJob) {
                    this.isChecked = true;
                    AccountChecker.this.accountJobs.remove(this.account);
                    this.notify();
                }
                AccountChecker.this.jobsDone.incrementAndGet();
            }
        }

        public boolean isChecked() {
            return this.isChecked;
        }

        public boolean isChecking() {
            return this.isChecking;
        }

        public AccountInfo getAccountInfo() {
            return this.ai;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public AccountInfo waitChecked() {
            while (!this.isChecked) {
                AccountCheckJob accountCheckJob = this;
                synchronized (accountCheckJob) {
                    if (this.isChecked) {
                        break;
                    }
                    try {
                        this.wait();
                    }
                    catch (InterruptedException e) {
                        return null;
                    }
                }
            }
            return this.ai;
        }
    }
}

