/*
 * Decompiled with CFR 0.152.
 */
package jd.controlling.downloadcontroller;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.appwork.storage.config.annotations.LabelInterface;

public class BadFilePathException
extends IOException {
    private File file;
    private PathFailureReason reason;
    private int index;

    public BadFilePathException(File file) {
        this.init(file, PathFailureReason.INVALID_DESTINATION, -1);
    }

    public BadFilePathException(File file, PathFailureReason reason) {
        this.init(file, reason, -1);
    }

    public BadFilePathException(File file, PathFailureReason reason, int index) {
        this.init(file, reason, index);
    }

    private void init(File file, PathFailureReason reason, int index) {
        this.file = file;
        this.reason = reason;
        this.index = index;
    }

    public File getFile() {
        return this.file;
    }

    public PathFailureReason getReason() {
        return this.reason;
    }

    public int getIndex() {
        return this.index;
    }

    public File getProblematicPathSegment() {
        if (this.index == -1) {
            return this.file;
        }
        ArrayList<File> pathList = new ArrayList<File>();
        File next = this.getFile();
        do {
            pathList.add(0, next);
        } while ((next = next.getParentFile()) != null);
        return (File)pathList.get(this.index);
    }

    public static enum PathFailureReason implements LabelInterface
    {
        PATH_SEGMENT_TOO_LONG{

            public String getLabel() {
                return "A segment of path is too long to be used [in the current OS]";
            }
        }
        ,
        PATH_TOO_LONG{

            public String getLabel() {
                return "Total length of path is too long";
            }
        }
        ,
        PERMISSION_PROBLEM{

            public String getLabel() {
                return "Permission to write to path is not given";
            }
        }
        ,
        FILE_ALREADY_EXISTS{

            public String getLabel() {
                return "File already exists";
            }
        }
        ,
        FILE_ALREADY_EXISTS_AS_FOLDER{

            public String getLabel() {
                return "File can't be created because a directory with the same name already exists";
            }
        }
        ,
        INVALID_DESTINATION{

            public String getLabel() {
                return "This path cannot be used for unknown reasons";
            }
        };

    }
}

