/*
 * Decompiled with CFR 0.152.
 */
package jd.controlling.downloadcontroller;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import jd.controlling.downloadcontroller.AccountCache;
import jd.controlling.downloadcontroller.DownloadLinkCandidate;
import jd.controlling.downloadcontroller.DownloadLinkCandidateResult;
import jd.controlling.downloadcontroller.DownloadLinkCandidateSelector;
import jd.controlling.downloadcontroller.HistoryEntry;
import jd.plugins.DownloadLink;
import org.appwork.exceptions.WTFException;
import org.jdownloader.logging.LogController;

public class DownloadLinkCandidateHistory {
    private final LinkedHashMap<DownloadLinkCandidate, DownloadLinkCandidateResult> history = new LinkedHashMap();

    protected DownloadLinkCandidateHistory() {
    }

    public synchronized boolean attach(DownloadLinkCandidate candidate) {
        if (this.history.containsKey(candidate)) {
            return false;
        }
        try {
            DownloadLink link = candidate.getLink();
            if (link != null) {
                link.addHistoryEntry(HistoryEntry.create(candidate));
            }
        }
        catch (Throwable e) {
            LogController.CL().log(e);
        }
        this.history.put(candidate, null);
        return true;
    }

    public synchronized boolean dettach(DownloadLinkCandidate candidate, DownloadLinkCandidateResult result) {
        if (this.history.containsKey(candidate) && this.history.get(candidate) == null) {
            try {
                HistoryEntry history;
                DownloadLink link = candidate.getLink();
                if (link != null && (history = link.getLatestHistoryEntry()) != null && history.getCandidate() == candidate) {
                    HistoryEntry.updateResult(history, candidate, result);
                }
            }
            catch (Throwable e) {
                LogController.CL().log(e);
            }
            this.history.put(candidate, result);
            return true;
        }
        return false;
    }

    protected Map<DownloadLinkCandidate, DownloadLinkCandidateResult> getHistory() {
        return this.history;
    }

    @Deprecated
    public List<DownloadLinkCandidateResult> getResults(DownloadLinkCandidate candidate) {
        return this.getResults(candidate.getCachedAccount());
    }

    public List<DownloadLinkCandidateResult> getResults(final AccountCache.CachedAccount cachedAccount) {
        return this.selectResults(new DownloadLinkCandidateHistorySelector(){

            @Override
            public boolean select(DownloadLinkCandidate candidate, DownloadLinkCandidateResult result) {
                return candidate != null && cachedAccount.equals(candidate.getCachedAccount());
            }
        });
    }

    public List<DownloadLinkCandidateResult> selectResults(DownloadLinkCandidateHistorySelector selector) {
        return DownloadLinkCandidateHistory.selectResults(this, selector);
    }

    public static List<DownloadLinkCandidateResult> selectResults(Collection<DownloadLinkCandidateHistory> histories, DownloadLinkCandidateHistorySelector selector) {
        ArrayList<DownloadLinkCandidateResult> ret = new ArrayList<DownloadLinkCandidateResult>();
        for (DownloadLinkCandidateHistory history : histories) {
            ret.addAll(DownloadLinkCandidateHistory.selectResults(history, selector));
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<DownloadLinkCandidateResult> selectResults(DownloadLinkCandidateHistory history, DownloadLinkCandidateHistorySelector selector) {
        ArrayList<DownloadLinkCandidateResult> ret = new ArrayList<DownloadLinkCandidateResult>();
        DownloadLinkCandidateHistory downloadLinkCandidateHistory = history;
        synchronized (downloadLinkCandidateHistory) {
            for (Map.Entry<DownloadLinkCandidate, DownloadLinkCandidateResult> next : history.getHistory().entrySet()) {
                DownloadLinkCandidate candidate = next.getKey();
                DownloadLinkCandidateResult result = next.getValue();
                if (candidate == null || result == null || selector != null && !selector.select(candidate, result)) continue;
                ret.add(result);
            }
        }
        return ret;
    }

    public int size() {
        return this.history.size();
    }

    public DownloadLinkCandidateResult getBlockingHistory(DownloadLinkCandidateSelector selector, DownloadLinkCandidate candidate) {
        if (selector != null && candidate != null) {
            List<DownloadLinkCandidateResult> results = this.getResults(candidate.getCachedAccount());
            for (DownloadLinkCandidateResult next : results) {
                switch (next.getResult()) {
                    case IP_BLOCKED: 
                    case HOSTER_UNAVAILABLE: {
                        break;
                    }
                    case CONDITIONAL_SKIPPED: 
                    case ACCOUNT_INVALID: 
                    case ACCOUNT_ERROR: 
                    case ACCOUNT_UNAVAILABLE: {
                        break;
                    }
                    case FINISHED: 
                    case FINISHED_EXISTS: 
                    case SKIPPED: 
                    case STOPPED: 
                    case FAILED: 
                    case FAILED_EXISTS: 
                    case OFFLINE_TRUSTED: 
                    case PROXY_UNAVAILABLE: 
                    case CONNECTION_TEMP_UNAVAILABLE: {
                        throw new WTFException("This should not happen! " + (Object)((Object)next.getResult()) + " should already be handled in onDetach!");
                    }
                    case FILE_UNAVAILABLE: 
                    case CONNECTION_ISSUES: {
                        if (next.getRemainingTime() <= 0L) break;
                    }
                    case PLUGIN_DEFECT: 
                    case ACCOUNT_REQUIRED: 
                    case FATAL_ERROR: {
                        return next;
                    }
                }
            }
            DownloadLinkCandidateResult block = selector.getBlockingDownloadLinkCandidateResult(candidate, results, this);
            if (block != null) {
                return block;
            }
        }
        return null;
    }

    public static interface DownloadLinkCandidateHistorySelector {
        public boolean select(DownloadLinkCandidate var1, DownloadLinkCandidateResult var2);
    }
}

