/*
 * Decompiled with CFR 0.152.
 */
package jd.controlling.downloadcontroller;

import java.util.Comparator;
import jd.controlling.downloadcontroller.DownloadLinkCandidate;
import jd.controlling.downloadcontroller.SingleDownloadController;
import jd.controlling.proxy.AbstractProxySelectorImpl;
import org.jdownloader.DomainInfo;

public class DownloadLinkCandidateLoadBalancer
implements Comparator<AbstractProxySelectorImpl> {
    private final String pluginHost;
    private final boolean specialHandling;
    private final DomainInfo domainInfo;

    public DownloadLinkCandidateLoadBalancer(DownloadLinkCandidate candidate) {
        this.specialHandling = candidate.getCachedAccount().getPlugin().isHandlingMultipleHosts();
        this.pluginHost = candidate.getCachedAccount().getPlugin().getHost();
        this.domainInfo = candidate.getLink().getDomainInfo();
    }

    @Override
    public int compare(int x, int y) {
        return x < y ? -1 : (x == y ? 0 : 1);
    }

    @Override
    public int compare(AbstractProxySelectorImpl proxy1, AbstractProxySelectorImpl proxy2) {
        return this.compare(this.countActiveDownloads(proxy1), this.countActiveDownloads(proxy2));
    }

    public int countActiveDownloads(AbstractProxySelectorImpl proxy) {
        int count = 0;
        if (proxy != null) {
            for (SingleDownloadController controller : proxy.getSingleDownloadControllers()) {
                if (!this.pluginHost.equals(controller.getDownloadLinkCandidate().getCachedAccount().getPlugin().getHost()) || this.specialHandling && this.domainInfo != controller.getDownloadLink().getDomainInfo()) continue;
                ++count;
            }
        }
        return count;
    }
}

